/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs.webdav;

import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.webdav.WebDavClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import se.datadosen.util.IO;

public class WebDavAdapter
implements RemoteFS {
    private WebDavClient dav = new WebDavClient();
    private String directory = "";

    public void setPort(int port) {
    }

    public int getPort() {
        throw new UnsupportedOperationException();
    }

    public void setForceUTF8(boolean force) {
    }

    public boolean isForceUTF8() {
        throw new UnsupportedOperationException();
    }

    public void setPassiveMode(boolean passive) {
    }

    public boolean isPassiveMode() {
        throw new UnsupportedOperationException();
    }

    public void connect(String server, String user, String password) throws RemoteFSException {
        this.dav.connect(server, user, password);
    }

    public void disconnect() throws RemoteFSException {
        this.dav.disconnect();
    }

    public boolean isConnected() {
        return this.dav.isConnected();
    }

    public String getDirectory() throws RemoteFSException {
        return this.directory;
    }

    public void setDirectory(String dir) throws RemoteFSException {
        this.directory = dir;
    }

    public void toParentDirectory() throws RemoteFSException {
        int lastSlash = this.directory.lastIndexOf(47);
        if (lastSlash < 0) {
            throw new RuntimeException("Can't go any higher!");
        }
        this.directory = this.directory.substring(0, lastSlash);
    }

    public void createDirectory(String name) throws RemoteFSException {
        String fullPath = name.startsWith("/") ? name : IO.combinePaths(this.directory, name);
        this.dav.createDirectory(fullPath);
    }

    public void removeDirectory(String name) throws RemoteFSException {
        this.dav.deleteDirectory(name);
    }

    public void rename(String from, String to) throws RemoteFSException {
        this.dav.move(from, to);
    }

    public RemoteFile[] getFiles() throws RemoteFSException {
        throw new UnsupportedOperationException("Use getFiles(String dir)");
    }

    public RemoteFile[] getFiles(String dir) throws RemoteFSException {
        String path;
        String string = path = dir.startsWith("/") ? dir : IO.combinePaths(this.directory, dir);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.dav.listFiles(path);
    }

    public void putFile(File file) throws RemoteFSException {
        throw new UnsupportedOperationException();
    }

    public void putFile(File file, String path) throws RemoteFSException {
        String totalPath = IO.combinePaths(this.directory, path);
        this.dav.putFile(file, totalPath);
    }

    public void removeFile(String filename) throws RemoteFSException {
        this.dav.deleteFile(filename);
    }

    public void setProgressMonitor(RemoteFSProgressMonitor monitor) {
    }

    public void abortConnect() {
        throw new UnsupportedOperationException();
    }

    public boolean exists(String path) throws RemoteFSException {
        throw new UnsupportedOperationException();
    }

    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

