/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs;

import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSFactory;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import info.cqs.remotefs.RemoteFileFilter;
import info.cqs.remotefs.annotations.RecoverFromIOException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import se.datadosen.jalbum.Config;
import se.datadosen.util.IO;
import se.datadosen.util.Stopwatch;

public class RemoteFSBean
implements RemoteFSDelegate {
    private RemoteFS remoteFS = null;
    private boolean secure = false;
    private String currentDirectory = "";
    private String server;
    private String user;
    private String password;
    public static RemoteFileFilter noDotDotDotFileFilter = new RemoteFileFilter(){

        public boolean accept(RemoteFile rf) {
            String name = rf.getName();
            return !name.equals(".") && !name.equals("..");
        }
    };

    private RemoteFSBean() {
    }

    public static RemoteFSDelegate createInstance() {
        RemoteFSBean target = new RemoteFSBean();
        return (RemoteFSDelegate)Proxy.newProxyInstance(target.getClass().getClassLoader(), target.getClass().getInterfaces(), (InvocationHandler)new RemoteFSHandler(target));
    }

    public void setSecure(boolean sec) {
        if (sec != this.secure) {
            this.remoteFS = null;
        }
        this.secure = sec;
    }

    public boolean isSecure() {
        return this.secure;
    }

    private RemoteFS getRemoteFS() throws RemoteFSException {
        if (this.remoteFS == null) {
            this.remoteFS = !this.secure ? RemoteFSFactory.getRemoteFS("ftp") : RemoteFSFactory.getRemoteFS("sftp");
        }
        return this.remoteFS;
    }

    public void testConnection(String server, String user, String password) throws IOException, RemoteFSException {
        this.connect(server, user, password);
        if (!this.isConnected()) {
            throw new RemoteFSException("Not connected to server");
        }
        this.disconnect();
        if (this.isConnected()) {
            throw new RemoteFSException("Still connected to server");
        }
    }

    public void setPort(int port) throws RemoteFSException {
        this.getRemoteFS().setPort(port);
    }

    public int getPort() throws RemoteFSException {
        return this.getRemoteFS().getPort();
    }

    public void setForceUTF8(boolean force) throws RemoteFSException {
        this.getRemoteFS().setForceUTF8(force);
    }

    public boolean isForceUTF8() throws RemoteFSException {
        return this.getRemoteFS().isForceUTF8();
    }

    public void setPassiveMode(boolean mode) throws RemoteFSException {
        this.getRemoteFS().setPassiveMode(mode);
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.getRemoteFS().isPassiveMode();
    }

    @RecoverFromIOException
    public String getDirectory() throws IOException, RemoteFSException {
        return this.getRemoteFS().getDirectory();
    }

    @RecoverFromIOException
    public void setDirectory(String directory) throws IOException, RemoteFSException {
        if (directory.length() == 0) {
            return;
        }
        this.getRemoteFS().setDirectory(directory);
        this.currentDirectory = directory.startsWith("/") ? directory : IO.combinePaths(this.currentDirectory, directory);
    }

    @RecoverFromIOException
    public void toParentDirectory() throws RemoteFSException, IOException {
        this.getRemoteFS().toParentDirectory();
        int lastSlashIndex = this.currentDirectory.lastIndexOf(47);
        this.currentDirectory = lastSlashIndex == -1 ? "" : this.currentDirectory.substring(0, lastSlashIndex);
    }

    @RecoverFromIOException
    public void createDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().createDirectory(name);
    }

    @RecoverFromIOException
    public void removeDirectory(String name) throws IOException, RemoteFSException {
        this.getRemoteFS().removeDirectory(name);
    }

    public void connect(String server, String user, String password) throws IOException, RemoteFSException {
        this.getRemoteFS().connect(server, user, password);
        this.server = server;
        this.user = user;
        this.password = password;
        this.currentDirectory = "";
    }

    public void abortConnect() throws RemoteFSException, IOException {
        this.getRemoteFS().abortConnect();
    }

    public void reconnect() throws RemoteFSException, IOException {
        this.getRemoteFS().connect(this.server, this.user, this.password);
        if (!"".equals(this.currentDirectory)) {
            this.getRemoteFS().setDirectory(this.currentDirectory);
        }
    }

    public void disconnect() throws IOException, RemoteFSException {
        this.getRemoteFS().disconnect();
    }

    public boolean isConnected() throws RemoteFSException {
        return this.getRemoteFS().isConnected();
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles() throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles();
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles(String dir) throws IOException, RemoteFSException {
        return this.getRemoteFS().getFiles(dir);
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles(RemoteFileFilter filter) throws IOException, RemoteFSException {
        return this.getFiles(".", filter);
    }

    @RecoverFromIOException
    public RemoteFile[] getFiles(String dir, RemoteFileFilter filter) throws IOException, RemoteFSException {
        RemoteFile[] allFiles = this.getFiles(dir);
        LinkedList<RemoteFile> list = new LinkedList<RemoteFile>();
        for (int i = 0; i < allFiles.length; ++i) {
            if (!filter.accept(allFiles[i])) continue;
            list.addLast(allFiles[i]);
        }
        return list.toArray(new RemoteFile[list.size()]);
    }

    @RecoverFromIOException
    public void putFile(File file) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file);
    }

    @RecoverFromIOException
    public void putFile(File file, String path) throws IOException, RemoteFSException {
        this.getRemoteFS().putFile(file, path);
    }

    @RecoverFromIOException
    public void put(InputStream in, String path) throws IOException, RemoteFSException {
        this.getRemoteFS().put(in, path);
    }

    @RecoverFromIOException
    public void get(String path, OutputStream out) throws IOException, RemoteFSException {
        this.getRemoteFS().get(path, out);
    }

    @RecoverFromIOException
    public void removeFile(String filename) throws IOException, RemoteFSException {
        this.getRemoteFS().removeFile(filename);
    }

    public void setProgressMonitor(RemoteFSProgressMonitor monitor) throws RemoteFSException {
        this.getRemoteFS().setProgressMonitor(monitor);
    }

    @RecoverFromIOException
    public void rename(String from, String to) throws IOException, RemoteFSException {
        this.getRemoteFS().rename(from, to);
    }

    @RecoverFromIOException
    public boolean exists(String path) throws IOException, RemoteFSException {
        return this.getRemoteFS().exists(path);
    }

    static class RemoteFSHandler
    implements InvocationHandler {
        RemoteFSBean bean;

        public RemoteFSHandler(RemoteFSBean bean) {
            this.bean = bean;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            method = this.bean.getClass().getMethod(method.getName(), method.getParameterTypes());
            boolean autoRecover = method.isAnnotationPresent(RecoverFromIOException.class);
            Stopwatch sw = new Stopwatch();
            sw.start();
            try {
                this.debug("Calling " + method.getName() + (autoRecover ? " with autorecover" : ""));
                Object object = method.invoke((Object)this.bean, args);
                return object;
            }
            catch (InvocationTargetException e) {
                Throwable cause = this.getEmbeddedIOException(e.getTargetException());
                if (autoRecover && cause instanceof IOException) {
                    this.log("Caught " + cause + " when calling " + method.getName() + ". Reconnecting");
                    try {
                        if (this.bean.isConnected()) {
                            try {
                                this.bean.disconnect();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        this.bean.reconnect();
                        Object ex = method.invoke((Object)this.bean, args);
                        return ex;
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (RemoteFSException ex) {
                        throw ex;
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
                throw e.getTargetException();
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
            }
            finally {
                this.debug("Done in " + sw);
            }
        }

        private Throwable getEmbeddedIOException(Throwable ex) {
            Throwable original = ex;
            do {
                if (!(ex instanceof IOException)) continue;
                return ex;
            } while ((ex = ex.getCause()) != null);
            return original;
        }

        void log(String s) {
            System.out.println("RemoteFSHandler: " + s);
        }

        void debug(String s) {
            if (Config.getConfig().isDebugMode()) {
                System.out.println("RemoteFSHandler: " + s);
            }
        }
    }
}

