/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.options;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.options.Options;

public final class PropertyOptions
extends Options {
    public static final int NO_OPTIONS = 0;
    public static final int URI = 2;
    public static final int HAS_QUALIFIERS = 16;
    public static final int QUALIFIER = 32;
    public static final int HAS_LANGUAGE = 64;
    public static final int HAS_TYPE = 128;
    public static final int STRUCT = 256;
    public static final int ARRAY = 512;
    public static final int ARRAY_ORDERED = 1024;
    public static final int ARRAY_ALTERNATE = 2048;
    public static final int ARRAY_ALT_TEXT = 4096;
    public static final int COMPACT = 8192;
    public static final int SCHEMA_NODE = Integer.MIN_VALUE;
    public static final int DELETE_EXISTING = 0x20000000;

    public PropertyOptions() {
    }

    public PropertyOptions(int n) throws XMPException {
        super(n);
    }

    public boolean isURI() {
        return this.getOption(2);
    }

    public PropertyOptions setURI(boolean bl) {
        this.setOption(2, bl);
        return this;
    }

    public boolean getHasQualifiers() {
        return this.getOption(16);
    }

    public PropertyOptions setHasQualifiers(boolean bl) {
        this.setOption(16, bl);
        return this;
    }

    public boolean isQualifier() {
        return this.getOption(32);
    }

    public PropertyOptions setQualifier(boolean bl) {
        this.setOption(32, bl);
        return this;
    }

    public boolean getHasLanguage() {
        return this.getOption(64);
    }

    public PropertyOptions setHasLanguage(boolean bl) {
        this.setOption(64, bl);
        return this;
    }

    public boolean getHasType() {
        return this.getOption(128);
    }

    public PropertyOptions setHasType(boolean bl) {
        this.setOption(128, bl);
        return this;
    }

    public boolean isStruct() {
        return this.getOption(256);
    }

    public PropertyOptions setStruct(boolean bl) {
        this.setOption(256, bl);
        return this;
    }

    public boolean isArray() {
        return this.getOption(512);
    }

    public PropertyOptions setArray(boolean bl) {
        this.setOption(512, bl);
        return this;
    }

    public boolean isArrayOrdered() {
        return this.getOption(1024);
    }

    public PropertyOptions setArrayOrdered(boolean bl) {
        this.setOption(1024, bl);
        return this;
    }

    public boolean isArrayAlternate() {
        return this.getOption(2048);
    }

    public PropertyOptions setArrayAlternate(boolean bl) {
        this.setOption(2048, bl);
        return this;
    }

    public boolean isArrayAltText() {
        return this.getOption(4096);
    }

    public PropertyOptions setArrayAltText(boolean bl) {
        this.setOption(4096, bl);
        return this;
    }

    public boolean isCompact() {
        return this.getOption(8192);
    }

    public PropertyOptions setCompact(boolean bl) {
        this.setOption(8192, bl);
        return this;
    }

    public boolean isSchemaNode() {
        return this.getOption(Integer.MIN_VALUE);
    }

    public PropertyOptions setSchemaNode(boolean bl) {
        this.setOption(Integer.MIN_VALUE, bl);
        return this;
    }

    public boolean isCompositeProperty() {
        return (this.getOptions() & 0x300) > 0;
    }

    public boolean isSimple() {
        return (this.getOptions() & 0x300) == 0;
    }

    public boolean equalArrayTypes(PropertyOptions propertyOptions) {
        return this.isArray() == propertyOptions.isArray() && this.isArrayOrdered() == propertyOptions.isArrayOrdered() && this.isArrayAlternate() == propertyOptions.isArrayAlternate() && this.isArrayAltText() == propertyOptions.isArrayAltText();
    }

    public void mergeWith(PropertyOptions propertyOptions) throws XMPException {
        if (propertyOptions != null) {
            this.setOptions(this.getOptions() | propertyOptions.getOptions());
        }
    }

    public boolean isOnlyArrayOptions() {
        return (this.getOptions() & 0xFFFFE1FF) == 0;
    }

    protected int getValidOptions() {
        return -2147467278;
    }

    protected String defineOptionName(int n) {
        switch (n) {
            case 2: {
                return "URI";
            }
            case 16: {
                return "HAS_QUALIFIER";
            }
            case 32: {
                return "QUALIFIER";
            }
            case 64: {
                return "HAS_LANGUAGE";
            }
            case 128: {
                return "HAS_TYPE";
            }
            case 256: {
                return "STRUCT";
            }
            case 512: {
                return "ARRAY";
            }
            case 1024: {
                return "ARRAY_ORDERED";
            }
            case 2048: {
                return "ARRAY_ALTERNATE";
            }
            case 4096: {
                return "ARRAY_ALT_TEXT";
            }
            case 8192: {
                return "COMPACT";
            }
            case -2147483648: {
                return "SCHEMA_NODE";
            }
        }
        return null;
    }

    public void assertConsistency(int n) throws XMPException {
        if ((n & 0x100) > 0 && (n & 0x200) > 0) {
            throw new XMPException("IsStruct and IsArray options are mutually exclusive", 103);
        }
        if ((n & 2) > 0 && (n & 0x300) > 0) {
            throw new XMPException("Structs and arrays can't have \"value\" options", 103);
        }
    }
}

