/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

class LineNumberBorder
implements Border,
CaretListener,
DocumentListener,
PropertyChangeListener,
ChangeListener {
    private static final int MIN_CELL_WIDTH = 24;
    private static final int RHS_BORDER_WIDTH = 8;
    private static final Color DEFAULT_FOREGROUND = new Color(128, 128, 128);
    private RTextArea textArea;
    private JScrollPane scrollPane;
    private Font font;
    private Color foreground;
    private Color background;
    private int currentLine;
    private int lastY = -1;
    private Insets insets;
    private int cellWidth;
    private int cellHeight;
    private int ascent;
    private int currentNumLines;

    public LineNumberBorder(JScrollPane jScrollPane, RTextArea rTextArea) {
        this(jScrollPane, rTextArea, DEFAULT_FOREGROUND);
    }

    public LineNumberBorder(JScrollPane jScrollPane, RTextArea rTextArea, Color color) {
        this.scrollPane = jScrollPane;
        this.setTextArea(rTextArea);
        this.setForeground(color != null ? color : DEFAULT_FOREGROUND);
        this.currentLine = 1;
        this.setFont(null);
        this.insets = new Insets(0, 0, 0, 0);
        this.updateCellHeights();
        this.updateCellWidths();
        this.insertUpdate(null);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.textArea.getCaretPosition();
        if (!this.textArea.getLineWrap()) {
            int n2 = this.textArea.getDocument().getDefaultRootElement().getElementIndex(n) + 1;
            if (this.currentLine != n2) {
                this.currentLine = n2;
                this.scrollPane.repaint();
            }
        } else {
            try {
                Rectangle rectangle = this.textArea.modelToView(n);
                if (rectangle != null && rectangle.y != this.lastY) {
                    this.lastY = rectangle.y;
                    this.currentLine = this.textArea.getDocument().getDefaultRootElement().getElementIndex(n) + 1;
                    this.scrollPane.repaint();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public Color getBackground() {
        return this.background;
    }

    public Insets getBorderInsets(Component component) {
        if (this.textArea == null || this.textArea.getComponentOrientation().isLeftToRight()) {
            this.insets.left = this.cellWidth;
            this.insets.right = 0;
        } else {
            this.insets.left = 0;
            this.insets.right = this.cellWidth;
        }
        return this.insets;
    }

    private static final Rectangle getChildViewBounds(View view, int n, Rectangle rectangle) {
        Shape shape = view.getChildAllocation(n, rectangle);
        return shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getLineNumberColor() {
        return this.getForeground();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n;
        int n2 = n = this.textArea != null ? this.textArea.getLineCount() : 0;
        if (n > this.currentNumLines) {
            if (n / 10 > this.currentNumLines / 10) {
                this.updateCellWidths();
            }
            this.currentNumLines = n;
        }
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.textArea == null) {
            return;
        }
        Element element = this.textArea.getDocument().getDefaultRootElement();
        Rectangle rectangle = this.textArea.getVisibleRect();
        if (rectangle == null) {
            return;
        }
        Insets insets = this.getBorderInsets(component);
        boolean bl = this.textArea.getComponentOrientation().isLeftToRight();
        if (bl) {
            n6 = n;
            n5 = insets.left;
        } else {
            n6 = n + n3 - insets.right;
            n5 = insets.right;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(n6, n2, n5, n4);
        graphics.setFont(this.font);
        if (this.textArea.getLineWrap()) {
            this.paintWrappedLineNumbers(graphics, element, n, n2, n3, rectangle);
            return;
        }
        int n7 = rectangle.y / this.cellHeight + 1;
        int n8 = Math.min(n7 + rectangle.height / this.cellHeight, element.getElementCount()) + 1;
        int n9 = n2 - rectangle.y % this.cellHeight;
        Insets insets2 = this.textArea.getInsets();
        if (insets2 != null) {
            n9 += insets2.top;
        }
        int n10 = n9 + this.ascent;
        if (this.textArea.getHighlightCurrentLine() && this.currentLine >= n7 && this.currentLine < n8) {
            graphics.setColor(this.textArea.getCurrentLineHighlightColor());
            graphics.fillRect(n6, n9 + (this.currentLine - n7) * this.cellHeight, n5, this.cellHeight);
        }
        graphics.setColor(Color.BLACK);
        if (bl) {
            graphics.drawLine(n6 + n5 - 4, 0, n6 + n5 - 4, rectangle.height + 1);
        } else {
            graphics.drawLine(n6 + 4, 0, n6 + 4, rectangle.height + 1);
        }
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (bl) {
            int n11 = n6 + insets.left - 8;
            for (int i = n7; i < n8; ++i) {
                String string = Integer.toString(i);
                int n12 = (int)fontMetrics.getStringBounds(string, graphics).getWidth();
                graphics.drawString(string, n11 - n12, n10);
                n10 += this.cellHeight;
            }
        } else {
            n6 += 8;
            for (int i = n7; i < n8; ++i) {
                String string = Integer.toString(i);
                graphics.drawString(string, n6, n10);
                n10 += this.cellHeight;
            }
        }
    }

    private void paintWrappedLineNumbers(Graphics graphics, Element element, int n, int n2, int n3, Rectangle rectangle) {
        int n4;
        int n5;
        int n6;
        Insets insets = this.getBorderInsets(this.textArea);
        boolean bl = this.textArea.getComponentOrientation().isLeftToRight();
        if (bl) {
            n6 = n;
            n5 = insets.left;
        } else {
            n6 = n + n3 - insets.right;
            n5 = insets.right;
        }
        RTextAreaUI rTextAreaUI = (RTextAreaUI)this.textArea.getUI();
        Rectangle rectangle2 = rTextAreaUI.getVisibleEditorRect();
        View view = rTextAreaUI.getRootView(this.textArea).getView(0);
        boolean bl2 = this.textArea.getHighlightCurrentLine();
        int n7 = element.getElementCount();
        int n8 = this.textArea.viewToModel(new Point(rectangle.x, rectangle.y));
        int n9 = element.getElementIndex(n8);
        Rectangle rectangle3 = LineNumberBorder.getChildViewBounds(view, n9, rectangle2);
        int n10 = rectangle3.y - rectangle.y;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n11 = n + insets.left - 8;
        int n12 = n4 + rectangle.height;
        graphics.setColor(this.getForeground());
        for (n4 = n2 + n10; n4 < n12; n4 += rectangle3.height) {
            rectangle3 = LineNumberBorder.getChildViewBounds(view, n9, rectangle2);
            int n13 = rectangle3.y + rectangle3.height - rectangle.y;
            if (bl2 && n9 == this.currentLine - 1) {
                graphics.setColor(this.textArea.getCurrentLineHighlightColor());
                graphics.fillRect(n6, n4, n5, n13 - n4 + 2);
                graphics.setColor(this.getForeground());
            }
            String string = Integer.toString(n9 + 1);
            if (bl) {
                n3 = (int)fontMetrics.getStringBounds(string, graphics).getWidth();
                graphics.drawString(string, n11 - n3, n4 + this.ascent);
                continue;
            }
            graphics.drawString(string, n6 + 8, n4 + this.ascent);
            if (++n9 < n7) continue;
            break;
        }
        graphics.setColor(Color.BLACK);
        n = bl ? n + insets.left - 4 : n6 + 4;
        graphics.drawLine(n, n2, n, n2 + rectangle.height - 1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("background")) {
            Color color = this.textArea.getBackground();
            this.setBackground(color == null ? Color.WHITE : color);
            this.scrollPane.repaint();
        }
        if (string.equals("background.image")) {
            this.setBackground(Color.WHITE);
            this.scrollPane.repaint();
        } else if (string.equals("font")) {
            this.updateCellHeights();
        } else if (string.equals("RTA.currentLineHighlight") || string.equals("RTA.currentLineHighlightColor")) {
            this.scrollPane.repaint();
        } else if (string.equals("RSTA.syntaxScheme")) {
            this.updateCellHeights();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n = this.textArea.getLineCount();
        if (n < this.currentNumLines) {
            if (n / 10 < this.currentNumLines / 10) {
                this.updateCellWidths();
            }
            this.currentNumLines = n;
            this.scrollPane.repaint();
        }
    }

    public void setBackground(Color color) {
        if (color != null && !color.equals(this.background)) {
            this.background = color;
        }
    }

    public void setFont(Font font) {
        if (font == null) {
            font = new Font("Monospaced", 0, 10);
        }
        this.font = font;
    }

    public void setForeground(Color color) {
        if (color != null && !color.equals(this.foreground)) {
            this.foreground = color;
        }
    }

    public void setLineNumberColor(Color color) {
        this.setForeground(color);
    }

    public void setTextArea(RTextArea rTextArea) {
        if (this.textArea != null) {
            this.scrollPane.getViewport().removeChangeListener(this);
            this.textArea.removeCaretListener(this);
            this.textArea.removePropertyChangeListener(this);
            this.textArea.getDocument().removeDocumentListener(this);
        }
        this.textArea = rTextArea;
        Color color = rTextArea == null ? Color.WHITE : rTextArea.getBackground();
        this.setBackground(color == null ? Color.WHITE : color);
        this.scrollPane.getViewport().addChangeListener(this);
        if (rTextArea != null) {
            rTextArea.addCaretListener(this);
            rTextArea.addPropertyChangeListener(this);
            rTextArea.getDocument().addDocumentListener(this);
            this.updateCellHeights();
            this.updateCellWidths();
            this.insertUpdate(null);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.scrollPane.repaint();
    }

    public void updateCellHeights() {
        if (this.textArea != null) {
            this.cellHeight = this.textArea.getLineHeight();
            this.ascent = this.textArea.getMaxAscent();
        } else {
            this.cellHeight = 20;
            this.ascent = 5;
        }
    }

    public void updateCellWidths() {
        if (this.textArea == null) {
            this.cellWidth = 50;
            return;
        }
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.textArea.getFontMetrics(font);
            int n = 0;
            int n2 = this.textArea.getDocument().getDefaultRootElement().getElementCount();
            while (n2 >= 10) {
                n2 /= 10;
                ++n;
            }
            this.cellWidth = Math.max(fontMetrics.charWidth('9') * (n + 2) + 5, 24);
        }
    }
}

