/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class CompletionXMLParser
extends DefaultHandler {
    private List completions;
    private CompletionProvider provider;
    private String name;
    private String type;
    private String returnType;
    private StringBuffer returnValDesc;
    private StringBuffer desc;
    private String paramName;
    private String paramType;
    private StringBuffer paramDesc;
    private List params;
    private String definedIn;
    private boolean doingKeywords;
    private boolean inKeyword;
    private boolean gettingReturnValDesc;
    private boolean gettingDesc;
    private boolean gettingParams;
    private boolean inParam;
    private boolean gettingParamDesc;
    private char paramStartChar;
    private char paramEndChar;
    private String paramSeparator;

    public CompletionXMLParser(CompletionProvider completionProvider) {
        this.provider = completionProvider;
        this.completions = new ArrayList();
        this.params = new ArrayList(1);
        this.desc = new StringBuffer();
        this.paramDesc = new StringBuffer();
        this.returnValDesc = new StringBuffer();
        this.paramEndChar = '\u0000';
        this.paramStartChar = '\u0000';
        this.paramSeparator = null;
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.gettingDesc) {
            this.desc.append(cArray, n, n2);
        } else if (this.gettingParamDesc) {
            this.paramDesc.append(cArray, n, n2);
        } else if (this.gettingReturnValDesc) {
            this.returnValDesc.append(cArray, n, n2);
        }
    }

    private FunctionCompletion createFunctionCompletion() {
        FunctionCompletion functionCompletion = new FunctionCompletion(this.provider, this.name, this.returnType);
        if (this.desc.length() > 0) {
            functionCompletion.setShortDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        functionCompletion.setParams(this.params);
        functionCompletion.setDefinedIn(this.definedIn);
        if (this.returnValDesc.length() > 0) {
            functionCompletion.setReturnValueDescription(this.returnValDesc.toString());
            this.returnValDesc.setLength(0);
        }
        return functionCompletion;
    }

    private MarkupTagCompletion createMarkupTagCompletion() {
        MarkupTagCompletion markupTagCompletion = new MarkupTagCompletion(this.provider, this.name);
        if (this.desc.length() > 0) {
            markupTagCompletion.setDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        markupTagCompletion.setAttributes(this.params);
        markupTagCompletion.setDefinedIn(this.definedIn);
        return markupTagCompletion;
    }

    private VariableCompletion createVariableCompletion() {
        VariableCompletion variableCompletion = new VariableCompletion(this.provider, this.name, this.returnType);
        if (this.desc.length() > 0) {
            variableCompletion.setShortDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        variableCompletion.setDefinedIn(this.definedIn);
        return variableCompletion;
    }

    public void endElement(String string, String string2, String string3) {
        if ("keywords".equals(string3)) {
            this.doingKeywords = false;
        } else if (this.doingKeywords) {
            if ("keyword".equals(string3)) {
                AbstractCompletion abstractCompletion = null;
                if ("function".equals(this.type)) {
                    abstractCompletion = this.createFunctionCompletion();
                } else if ("constant".equals(this.type)) {
                    abstractCompletion = this.createVariableCompletion();
                } else if ("tag".equals(this.type)) {
                    abstractCompletion = this.createMarkupTagCompletion();
                } else {
                    throw new InternalError("Unexpected type: " + this.type);
                }
                this.completions.add(abstractCompletion);
                this.inKeyword = false;
            } else if (this.inKeyword) {
                if ("returnValDesc".equals(string3)) {
                    this.gettingReturnValDesc = false;
                } else if (this.gettingParams) {
                    if ("params".equals(string3)) {
                        this.gettingParams = false;
                    } else if ("param".equals(string3)) {
                        ParameterizedCompletion.Parameter parameter = new ParameterizedCompletion.Parameter(this.paramType, this.paramName);
                        if (this.paramDesc.length() > 0) {
                            parameter.setDescription(this.paramDesc.toString());
                            this.paramDesc.setLength(0);
                        }
                        this.params.add(parameter);
                        this.inParam = false;
                    } else if (this.inParam && "desc".equals(string3)) {
                        this.gettingParamDesc = false;
                    }
                } else if ("desc".equals(string3)) {
                    this.gettingDesc = false;
                }
            }
        }
    }

    public List getCompletions() {
        return this.completions;
    }

    public char getParamEndChar() {
        return this.paramEndChar;
    }

    public String getParamSeparator() {
        return this.paramSeparator;
    }

    public char getParamStartChar() {
        return this.paramStartChar;
    }

    public void reset(CompletionProvider completionProvider) {
        this.provider = completionProvider;
        this.completions.clear();
        this.gettingParamDesc = false;
        this.inParam = false;
        this.gettingParams = false;
        this.gettingDesc = false;
        this.inKeyword = false;
        this.doingKeywords = false;
        this.paramEndChar = '\u0000';
        this.paramStartChar = '\u0000';
        this.paramSeparator = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("keywords".equals(string3)) {
            this.doingKeywords = true;
        } else if (this.doingKeywords) {
            if ("keyword".equals(string3)) {
                this.name = attributes.getValue("name");
                this.type = attributes.getValue("type");
                this.returnType = attributes.getValue("returnType");
                this.params.clear();
                this.definedIn = attributes.getValue("definedIn");
                this.inKeyword = true;
            } else if (this.inKeyword) {
                if ("returnValDesc".equals(string3)) {
                    this.gettingReturnValDesc = true;
                } else if ("params".equals(string3)) {
                    this.gettingParams = true;
                } else if (this.gettingParams) {
                    if ("param".equals(string3)) {
                        this.paramName = attributes.getValue("name");
                        this.paramType = attributes.getValue("type");
                        this.inParam = true;
                    }
                    if (this.inParam && "desc".equals(string3)) {
                        this.gettingParamDesc = true;
                    }
                } else if ("desc".equals(string3)) {
                    this.gettingDesc = true;
                }
            }
        } else if ("environment".equals(string3)) {
            this.paramStartChar = attributes.getValue("paramStartChar").charAt(0);
            this.paramEndChar = attributes.getValue("paramEndChar").charAt(0);
            this.paramSeparator = attributes.getValue("paramSeparator");
        }
    }
}

