/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.Serializable;

public class MiniConfig
implements Serializable {
    private static MiniConfig theConfig;
    public File progDir = new File("").getAbsoluteFile();
    public File skinsDir;
    public File pluginsDir;

    private MiniConfig() {
        this.newProgDir();
        if (!this.skinsDir.exists()) {
            String instDirName = System.getProperty("jalbum.installation.dir");
            if (instDirName != null) {
                this.progDir = new File(instDirName);
            } else {
                File classPath = new File(System.getProperty("java.class.path"));
                if (classPath.exists()) {
                    this.progDir = classPath.getParentFile().getAbsoluteFile();
                }
            }
            this.newProgDir();
        }
    }

    public static MiniConfig getMiniConfig() {
        if (theConfig == null) {
            theConfig = new MiniConfig();
        }
        return theConfig;
    }

    private void newProgDir() {
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
    }
}

