/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPConst;

public class Utils
implements XMPConst {
    public static final int UUID_SEGMENT_COUNT = 4;
    public static final int UUID_LENGTH = 36;
    private static boolean[] xmlNameStartChars;
    private static boolean[] xmlNameChars;

    private Utils() {
    }

    public static String normalizeLangValue(String string) {
        if ("x-default".equals(string)) {
            return string;
        }
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '-': 
                case '_': {
                    stringBuffer.append('-');
                    ++n;
                    continue block4;
                }
                case ' ': {
                    continue block4;
                }
                default: {
                    if (n != 2) {
                        stringBuffer.append(Character.toLowerCase(string.charAt(i)));
                        continue block4;
                    }
                    stringBuffer.append(Character.toUpperCase(string.charAt(i)));
                }
            }
        }
        return stringBuffer.toString();
    }

    static String[] splitNameAndValue(String string) {
        int n = string.indexOf(61);
        int n2 = 1;
        if (string.charAt(n2) == '?') {
            ++n2;
        }
        String string2 = string.substring(n2, n);
        n2 = n + 1;
        char c = string.charAt(n2);
        ++n2;
        int n3 = string.length() - 2;
        StringBuffer stringBuffer = new StringBuffer(n3 - n);
        while (n2 < n3) {
            stringBuffer.append(string.charAt(n2));
            if (string.charAt(++n2) != c) continue;
            ++n2;
        }
        return new String[]{string2, stringBuffer.toString()};
    }

    static boolean isInternalProperty(String string, String string2) {
        boolean bl = false;
        if ("http://purl.org/dc/elements/1.1/".equals(string)) {
            if ("dc:format".equals(string2) || "dc:language".equals(string2)) {
                bl = true;
            }
        } else if ("http://ns.adobe.com/xap/1.0/".equals(string)) {
            if ("xap:BaseURL".equals(string2) || "xap:CreatorTool".equals(string2) || "xap:Format".equals(string2) || "xap:Locale".equals(string2) || "xap:MetadataDate".equals(string2) || "xap:ModifyDate".equals(string2)) {
                bl = true;
            }
        } else if ("http://ns.adobe.com/pdf/1.3/".equals(string)) {
            if ("pdf:BaseURL".equals(string2) || "pdf:Creator".equals(string2) || "pdf:ModDate".equals(string2) || "pdf:PDFVersion".equals(string2) || "pdf:Producer".equals(string2)) {
                bl = true;
            }
        } else if ("http://ns.adobe.com/tiff/1.0/".equals(string)) {
            bl = true;
            if ("tiff:ImageDescription".equals(string2) || "tiff:Artist".equals(string2) || "tiff:Copyright".equals(string2)) {
                bl = false;
            }
        } else if ("http://ns.adobe.com/exif/1.0/".equals(string)) {
            bl = true;
            if ("exif:UserComment".equals(string2)) {
                bl = false;
            }
        } else if ("http://ns.adobe.com/exif/1.0/aux/".equals(string)) {
            bl = true;
        } else if ("http://ns.adobe.com/photoshop/1.0/".equals(string)) {
            if ("photoshop:ICCProfile".equals(string2)) {
                bl = true;
            }
        } else if ("http://ns.adobe.com/camera-raw-settings/1.0/".equals(string)) {
            if ("crs:Version".equals(string2) || "crs:RawFileName".equals(string2) || "crs:ToneCurveName".equals(string2)) {
                bl = true;
            }
        } else if ("http://ns.adobe.com/StockPhoto/1.0/".equals(string)) {
            bl = true;
        } else if ("http://ns.adobe.com/xap/1.0/mm/".equals(string)) {
            bl = true;
        } else if ("http://ns.adobe.com/xap/1.0/t/".equals(string)) {
            bl = true;
        } else if ("http://ns.adobe.com/xap/1.0/t/pg/".equals(string)) {
            bl = true;
        } else if ("http://ns.adobe.com/xap/1.0/g/".equals(string)) {
            bl = true;
        } else if ("http://ns.adobe.com/xap/1.0/g/img/".equals(string)) {
            bl = true;
        } else if ("http://ns.adobe.com/xap/1.0/sType/Font#".equals(string)) {
            bl = true;
        }
        return bl;
    }

    static boolean checkUUIDFormat(String string) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return false;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '-') continue;
            ++n;
            bl = bl && (n2 == 8 || n2 == 13 || n2 == 18 || n2 == 23);
        }
        return bl && 4 == n && 36 == n2;
    }

    public static boolean isXMLName(String string) {
        if (string.length() > 0 && !Utils.isNameStartChar(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Utils.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isXMLNameNS(String string) {
        if (!(string.length() <= 0 || Utils.isNameStartChar(string.charAt(0)) && string.charAt(0) != ':')) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Utils.isNameChar(string.charAt(i)) && string.charAt(i) != ':') continue;
            return false;
        }
        return true;
    }

    static boolean isControlChar(char c) {
        return (c <= '\u001f' || c == '\u007f') && c != '\t' && c != '\n' && c != '\r';
    }

    public static String escapeXML(String string, boolean bl, boolean bl2) {
        int n;
        boolean bl3 = false;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 60 && n != 62 && n != 38 && (!bl2 || n != 9 && n != 10 && n != 13) && (!bl || n != 34)) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 4 / 3);
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (!bl2 || c != '\t' && c != '\n' && c != '\r') {
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append(bl ? "&quot;" : "\"");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append("&#x");
            stringBuffer.append(Integer.toHexString(c).toUpperCase());
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    static String removeControlChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (!Utils.isControlChar(stringBuffer.charAt(i))) continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString();
    }

    private static boolean isNameStartChar(char c) {
        return c > '\u00ff' || xmlNameStartChars[c];
    }

    private static boolean isNameChar(char c) {
        return c > '\u00ff' || xmlNameChars[c];
    }

    private static void initCharTables() {
        xmlNameChars = new boolean[256];
        xmlNameStartChars = new boolean[256];
        for (int n = 0; n < xmlNameChars.length; n = (int)((char)(n + 1))) {
            Utils.xmlNameStartChars[n] = 97 <= n && n <= 122 || 65 <= n && n <= 90 || n == 58 || n == 95 || 192 <= n && n <= 214 || 216 <= n && n <= 246;
            Utils.xmlNameChars[n] = 97 <= n && n <= 122 || 65 <= n && n <= 90 || 48 <= n && n <= 57 || n == 58 || n == 95 || n == 45 || n == 46 || n == 183 || 192 <= n && n <= 214 || 216 <= n && n <= 246;
        }
    }

    static {
        Utils.initCharTables();
    }
}

