/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import marcoschmidt.ImageInfo;
import org.w3c.dom.Node;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;

public class FileFilters {
    public static final String MEDIA_FILE = "Media file";
    public static final String AUDIO_FILE = "Audio file";
    private static Set<String> classicTypes = new HashSet<String>();
    private static Set<String> imageIOTypes = new HashSet<String>();
    private static Map<String, FileType> otherTypes;
    private static final String FOLDER_KEY = "folder";
    private static final int STANDARD_SCALE_MODIFIER = 1;
    private static final int STANDARD_SUBSAMPLING = 1;

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine) throws IOException, ImageFormatException {
        FileFilters.saveJPEG(img, file, engine, null);
    }

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData) throws IOException, ImageFormatException {
        if (file.exists()) {
            file.delete();
        }
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("jpeg");
        while (it.hasNext()) {
            ImageWriter iw = it.next();
            ImageWriteParam param = iw.getDefaultWriteParam();
            if (engine.isProgressiveMode() && !param.canWriteProgressive() && it.hasNext()) continue;
            param.setCompressionMode(2);
            param.setCompressionQuality((float)engine.getQualityPercent() / 100.0f);
            if (engine.isProgressiveMode() && param.canWriteProgressive()) {
                param.setProgressiveMode(1);
            }
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            iw.setOutput(ios);
            if (metaData != null) {
                ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(img);
                IIOMetadata metaDefault = iw.getDefaultImageMetadata(type, param);
                Node sofDefault = FileFilters.lookupNode(metaDefault, "sof");
                FileFilters.replaceSOFMarker(metaData, sofDefault);
            }
            iw.write(null, new IIOImage(img, null, metaData), param);
            iw.dispose();
            ios.close();
            break;
        }
    }

    public static boolean isFileSupported(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileFilters.getExtensionOf(file);
        return classicTypes.contains(extension) || imageIOTypes.contains(extension);
    }

    public static boolean isMediaFile(File file) {
        boolean mediaFile = FileFilters.hasIcon(file);
        if (file.isDirectory()) {
            return false;
        }
        return mediaFile;
    }

    public static String getFileCategory(File f) {
        FileType type = (FileType)FileFilters.getOtherTypes().get(FileFilters.getExtensionOf(f));
        if (type != null) {
            return type.name;
        }
        return null;
    }

    public static boolean hasIcon(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (FileFilters.isFileSupported(file)) {
            return false;
        }
        String ext = FileFilters.getExtensionOf(file);
        return FileFilters.getOtherTypes().containsKey(ext);
    }

    public static File getIconFor(File f) {
        return FileFilters.getIconFor(f, null);
    }

    public static File getIconFor(File f, AlbumBean engine) {
        File iconFile;
        Config c = Config.getConfig();
        String ext = f.isDirectory() ? FOLDER_KEY : FileFilters.getExtensionOf(f);
        FileType ft = (FileType)FileFilters.getOtherTypes().get(ext);
        if (ft == null) {
            return null;
        }
        if (engine != null && (iconFile = new File(engine.srcResDir, ft.icon)).exists()) {
            return iconFile;
        }
        return new File(c.progDir, "res/" + ft.icon);
    }

    public static String getExtensionOf(File f) {
        if (f == null) {
            throw new RuntimeException("File can't be null!");
        }
        String name = f.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1).toLowerCase();
    }

    private static BufferedImage ensureBuffered(Image img, int iw, int ih) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    private static ImageInfo getImageInfo(File file) throws IOException {
        ImageInfo ii = new ImageInfo();
        FileInputStream fis = new FileInputStream(file);
        ii.setCollectComments(false);
        ii.setInput(fis);
        if (!ii.check()) {
            throw new IOException(Msg.get("engine.unsupportedFileFormatError") + file.getName());
        }
        fis.close();
        return ii;
    }

    public static BasicImageInfo getBasicImageInfo(File f) throws IOException {
        BasicImageInfo info = new BasicImageInfo();
        String ext = IO.extensionOf(f).toLowerCase();
        if (ext.equals("gif")) {
            ImageInfo ii = FileFilters.getImageInfo(f);
            info.width = ii.getWidth();
            info.height = ii.getHeight();
            info.formatName = ii.getFormatName();
        } else {
            FileImageInputStream iis = new FileImageInputStream(f);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            if (!it.hasNext()) {
                throw new IOException("Unsupported file format for " + f);
            }
            ImageReader reader = it.next();
            reader.setInput(iis, true, true);
            int minIndex = reader.getMinIndex();
            info.width = reader.getWidth(minIndex);
            info.height = reader.getHeight(minIndex);
            info.formatName = reader.getFormatName();
            reader.dispose();
            iis.close();
        }
        return info;
    }

    public static BufferedImage loadImage(File file, AlbumBean engine) throws IOException, ImageFormatException {
        if (!FileFilters.getExtensionOf(file).equals("thm") && !FileFilters.isFileSupported(file)) {
            file = FileFilters.getIconFor(file, engine);
        }
        if (engine.isClassicReaders() && classicTypes.contains(FileFilters.getExtensionOf(file))) {
            return FileFilters.classicLoad(file);
        }
        return FileFilters.loadImage(file, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage classicLoad(File file) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
            BufferedImage img = decoder.decodeAsBufferedImage();
            JPEGDecodeParam p = decoder.getJPEGDecodeParam();
            in.close();
            if (p.getEncodedColorID() != 3 && p.getEncodedColorID() != 2) {
                throw new ImageFormatException("Image must be stored in RGB color model");
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        catch (Exception ex) {
            ImageIcon tmpIcon = new ImageIcon(file.getAbsolutePath());
            Image tmpImg = tmpIcon.getImage();
            BufferedImage bufferedImage = FileFilters.ensureBuffered(tmpImg, tmpIcon.getIconWidth(), tmpIcon.getIconHeight());
            return bufferedImage;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static BufferedImage loadImage(File file) throws IOException {
        return FileFilters.loadImage(file, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadImage(File file, int subsampling) throws IOException {
        ImageReader reader = null;
        ImageInputStream stream = null;
        boolean loadFailed = false;
        try {
            BufferedImage bi;
            stream = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> it = ImageIO.getImageReaders(stream);
            while (it.hasNext() && !"com.sun.imageio.plugins.jpeg.JPEGImageReader".equals((reader = it.next()).getClass().getName())) {
            }
            reader.setInput(stream, true, true);
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceSubsampling(subsampling, subsampling, 0, 0);
            Iterator<ImageTypeSpecifier> i = reader.getImageTypes(0);
            while (i.hasNext()) {
                ImageTypeSpecifier type = i.next();
                if (!type.getColorModel().getColorSpace().isCS_sRGB()) continue;
                param.setDestinationType(type);
                break;
            }
            BufferedImage bufferedImage = bi = reader.read(0, param);
            return bufferedImage;
        }
        catch (IllegalArgumentException ex) {
            loadFailed = true;
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            if (stream != null) {
                stream.close();
            }
        }
        if (loadFailed) {
            return FileFilters.classicLoad(file);
        }
        return null;
    }

    public static int calculateSubsamplingByScale(File file, Dimension imageDim) throws IOException {
        return FileFilters.calculateSubsamplingByScale(file, imageDim, 1);
    }

    public static int calculateSubsamplingByScale(File file, Dimension imageDim, int scaleModifier) throws IOException {
        BasicImageInfo info = FileFilters.getBasicImageInfo(file);
        int scale = Math.min(info.width / imageDim.width, info.height / imageDim.height);
        if ((scale -= scaleModifier) < 1) {
            scale = 1;
        }
        return scale;
    }

    static Map getOtherTypes() {
        if (otherTypes != null) {
            return otherTypes;
        }
        otherTypes = new HashMap<String, FileType>();
        try {
            Element type;
            Config c = Config.getConfig();
            String content = IO.readTextFile(new File(c.progDir, "system/filetypes.xml"));
            String docrest = content = Elements.stripComments(content);
            Element root = Elements.getElementByName("filetypes", docrest, false);
            if (root != null) {
                otherTypes.put(FOLDER_KEY, new FileType("Folder", root.getAttribute("foldericon", "folder.gif")));
            }
            while ((type = Elements.getElementByName("type", docrest, false)) != null) {
                Element ext;
                FileType ft = new FileType(type.getAttribute("name"), type.getAttribute("icon"));
                String extrest = type.getContent();
                while ((ext = Elements.getElementByName("ext", extrest, false)) != null) {
                    otherTypes.put(ext.getContent(), ft);
                    extrest = ext.getPostElement();
                }
                docrest = type.getPostElement();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return otherTypes;
    }

    private static boolean replaceSOFMarker(IIOMetadata meta, Node sof) {
        String format = meta.getNativeMetadataFormatName();
        Node root = meta.getAsTree(format);
        Node markerSequence = FileFilters.lookupNode(root, "markerSequence");
        if (markerSequence == null) {
            return false;
        }
        Node sofOld = FileFilters.lookupNode(markerSequence, "sof");
        if (sofOld != null) {
            markerSequence.removeChild(sofOld);
        }
        markerSequence.appendChild(sof);
        try {
            meta.setFromTree(format, root);
        }
        catch (IIOInvalidTreeException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static Node lookupNode(IIOMetadata meta, String name) {
        String format = meta.getNativeMetadataFormatName();
        Node root = meta.getAsTree(format);
        return FileFilters.lookupNode(root, name);
    }

    private static Node lookupNode(Node n, String name) {
        if (n == null) {
            return null;
        }
        if (name.equals(n.getNodeName())) {
            return n;
        }
        Node res = FileFilters.lookupNode(n.getFirstChild(), name);
        if (res != null) {
            return res;
        }
        return FileFilters.lookupNode(n.getNextSibling(), name);
    }

    static {
        classicTypes.add("jpg");
        classicTypes.add("jpeg");
        classicTypes.add("jpe");
        classicTypes.add("gif");
        classicTypes.add("png");
        String[] types = ImageIO.getReaderFormatNames();
        for (int i = 0; i < types.length; ++i) {
            imageIOTypes.add(types[i]);
        }
    }

    public static class FileType {
        public String name;
        public String icon;

        public FileType(String name, String iconName) {
            this.name = name;
            this.icon = iconName;
        }

        public String toString() {
            return "{Name=" + this.name + " icon=" + this.icon + "}";
        }
    }

    public static class BasicImageInfo {
        public int width;
        public int height;
        public String formatName;
    }
}

