/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum.scaling;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import se.datadosen.jalbum.scaling.ImageScaler;

class MediumScaler
extends ImageScaler {
    MediumScaler() {
        throw new UnsupportedOperationException("Use BetterMediumScaler instead!");
    }

    public BufferedImage scale(Image image, int destinationWidth, int destinationHeight) {
        int currentWidth = image.getWidth(null);
        int currentHeight = image.getHeight(null);
        do {
            if ((currentWidth /= 2) < destinationWidth || (currentHeight /= 2) < destinationHeight) {
                currentWidth = destinationWidth;
                currentHeight = destinationHeight;
            }
            BufferedImage temp = new BufferedImage(currentWidth, currentHeight, 1);
            Graphics2D g = temp.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g.dispose();
            image.flush();
            image = temp;
        } while (currentWidth > destinationWidth || currentHeight > destinationHeight);
        return (BufferedImage)image;
    }
}

