/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;

class SplashScreen
extends Window {
    private ImageIcon icon;
    private Image background;

    public SplashScreen() {
        super(new Frame());
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, null);
        }
        g.drawImage(this.icon.getImage(), 0, 0, this);
        g.setColor(new Color(31, 120, 31));
        g.setFont(new Font("SansSerif", 1, 10));
        String versionText = "8.0.9";
        g.drawString(versionText, 140, 52);
    }

    private void init() throws Exception {
        this.setBackground(new Color(255, 255, 255, 0));
        this.icon = new ImageIcon(this.getClass().getResource("images/splash.png"));
        Dimension iconSize = new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
        this.setSize(iconSize);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        if (!"Mac OS X".equals(System.getProperty("os.name"))) {
            Robot rbt = new Robot();
            this.background = rbt.createScreenCapture(this.getBounds());
        }
    }
}

