/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.Msg;

public abstract class SlowOperation
extends Thread {
    private JLabel label;
    private Icon icon;
    private Icon altIcon;
    private boolean alive = true;
    private boolean aborted = false;
    private Object result;
    private Throwable throwable;
    protected JSmartDialog dialog;
    protected Action abortAction = new AbstractAction(Msg.getString("abort")){

        public void actionPerformed(ActionEvent e) {
            SlowOperation.this.aborted = true;
            SlowOperation.this.abort();
        }
    };

    public boolean launch(Dialog parent, JLabel messageLabel, String title) throws Throwable {
        return this.launch(parent, messageLabel, null, title);
    }

    public boolean launch(Dialog parent, JLabel messageLabel, Icon altIcon, final String title) throws Throwable {
        this.label = messageLabel;
        this.altIcon = altIcon;
        this.dialog = new JSmartDialog(parent, true){
            {
                super(x0, x1);
                this.setTitle(title);
                JComponent c = (JComponent)this.getContentPane();
                c.setLayout(new BorderLayout());
                c.setBorder(new EmptyBorder(20, 20, 14, 20));
                c.add((Component)SlowOperation.this.label, "Center");
                this.registerActions(SlowOperation.this.abortAction);
                SlowOperation.this.icon = SlowOperation.this.label.getIcon();
                if (SlowOperation.this.icon != null) {
                    if (SlowOperation.this.altIcon == null) {
                        BufferedImage bi = new BufferedImage(SlowOperation.this.icon.getIconWidth(), SlowOperation.this.icon.getIconHeight(), 2);
                        SlowOperation.this.altIcon = new ImageIcon(bi);
                    }
                    SlowOperation.this.startBlinker();
                }
            }
        };
        this.start();
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.throwable != null && !this.aborted) {
            throw this.throwable;
        }
        return !this.aborted;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public void run() {
        try {
            this.operation();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        this.alive = false;
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public abstract void operation() throws Throwable;

    public abstract void abort();

    private void startBlinker() {
        Thread blinkerThread = new Thread("Blinker thread"){

            public void run() {
                try {
                    while (SlowOperation.this.alive) {
                        3.sleep(500L);
                        SlowOperation.this.label.setIcon(SlowOperation.this.altIcon);
                        3.sleep(500L);
                        SlowOperation.this.label.setIcon(SlowOperation.this.icon);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        blinkerThread.start();
    }
}

