/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.datadosen.component.JRatingSlider;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;

public class JPropertyPanel
extends JPanel {
    private static final int LEN = 14;
    private JSmallTextField fileName = new JSmallTextField(14);
    private JSmallTextField title = new JSmallTextField(14);
    private JSmallTextField date = new JSmallTextField(14);
    private JSmallTextField time = new JSmallTextField(14);
    private JRatingSlider rating = new JRatingSlider(5);
    private AlbumObject ao;
    JEditPanel editPanel;
    Action previousImage = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JPropertyPanel.this.editPanel.previousImageAction.actionPerformed(e);
        }
    };
    Action nextImage = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JPropertyPanel.this.editPanel.nextImageAction.actionPerformed(e);
        }
    };

    public JPropertyPanel(JEditPanel editPanel) {
        this.editPanel = editPanel;
        this.init();
    }

    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        this.fileName.setFocusable(focusable);
        this.title.setFocusable(focusable);
        this.date.setFocusable(focusable);
        this.time.setFocusable(focusable);
    }

    public void setAlbumObject(AlbumObject ao) {
        this.ao = ao;
        if (ao == null) {
            return;
        }
        this.fileName.setText(ao.getName());
        if (ao instanceof AlbumObjectImpl) {
            File file = ((AlbumObjectImpl)ao).getFile();
            Date fileDate = new Date(file.lastModified());
            DateFormat datePart = DateFormat.getDateInstance(3);
            DateFormat timePart = DateFormat.getTimeInstance(3);
            this.date.setText(datePart.format(fileDate));
            this.time.setText(timePart.format(fileDate));
        }
        AlbumObjectProperties aoprop = ao.getProperties();
        this.title.setText((String)aoprop.get("title"));
        Integer r = (Integer)aoprop.get("rating");
        if (r != null) {
            this.rating.setValue(r);
        } else {
            this.rating.setValue(0);
        }
    }

    public void componentShown() {
        this.requestFocus();
    }

    private void init() {
        this.setBackground(SystemColor.text);
        this.setOpaque(true);
        this.setLayout(new RiverLayout(4, 0));
        this.add("br", JPropertyPanel.emptyArea(1));
        this.add("br", new JSmallLabel(Msg.get("edit.name")));
        this.add("tab hfill", this.fileName);
        this.add("br", new JSmallLabel(Msg.get("edit.titleLabel")));
        this.add("tab hfill", this.title);
        this.add("br", new JSmallLabel(Msg.get("edit.date")));
        this.add("tab hfill", this.date);
        this.add("br", new JSmallLabel(Msg.get("edit.time")));
        this.add("tab hfill", this.time);
        this.add("br", new JSmallLabel(Msg.get("edit.rating")));
        this.add("tab hfill", this.rating);
        this.add("br", JPropertyPanel.emptyArea(5));
        this.rating.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AlbumObjectProperties aop = JPropertyPanel.this.ao.getProperties();
                aop.put("rating", JPropertyPanel.this.rating.getValue());
                aop.save();
            }
        });
        FocusListener fl = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                JPropertyPanel.this.save();
            }
        };
        this.fileName.addFocusListener(fl);
        this.title.addFocusListener(fl);
        this.date.addFocusListener(fl);
        this.time.addFocusListener(fl);
    }

    void save() {
        if (this.ao == null) {
            return;
        }
        if (!this.fileName.getText().equals(this.ao.getName())) {
            this.ao.setName(this.fileName.getText());
        }
        if (this.ao instanceof AlbumObjectImpl) {
            AlbumObjectProperties props = this.ao.getProperties();
            if (!this.title.getText().equals(props.get("title"))) {
                props.put("title", this.title.getText());
                props.save();
            }
            File file = ((AlbumObjectImpl)this.ao).getFile();
            Date fileDate = new Date(file.lastModified());
            DateFormat datePart = DateFormat.getDateInstance(3);
            DateFormat timePart = DateFormat.getTimeInstance(3);
            if (!this.date.getText().equals(datePart.format(fileDate)) || !this.time.getText().equals(timePart.format(fileDate))) {
                DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3);
                try {
                    Date newDate = dateTimeFormat.parse(this.date.getText() + " " + this.time.getText());
                    file.setLastModified(newDate.getTime());
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
    }

    private static Component emptyArea(int size) {
        return Box.createRigidArea(new Dimension(size, size));
    }

    public class JSmallTextField
    extends JSmartTextField {
        private Border originalBorder;
        private Border emptyBorder;

        public JSmallTextField() {
            this.init();
        }

        public JSmallTextField(int length) {
            super(length);
            this.init();
        }

        private void init() {
            if (JAlbum.isMac()) {
                this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            }
            this.setOpaque(false);
            this.originalBorder = this.getBorder();
            Insets in = this.originalBorder.getBorderInsets(this);
            this.emptyBorder = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            this.setBorder(this.emptyBorder);
            this.registerKeyboardAction(null, KeyStroke.getKeyStroke(33, 0), 0);
            this.registerKeyboardAction(null, KeyStroke.getKeyStroke(34, 0), 0);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JSmallTextField.this.getFocusCycleRootAncestor().transferFocus();
                }
            });
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    JSmallTextField.this.setBorder(JSmallTextField.this.originalBorder);
                }

                public void focusLost(FocusEvent e) {
                    JSmallTextField.this.setBorder(JSmallTextField.this.emptyBorder);
                }
            });
        }
    }

    public static class JSmallLabel
    extends JLabel {
        public JSmallLabel(String text) {
            super(text);
            if (JAlbum.isMac()) {
                this.setFont(this.getFont().deriveFont(1, this.getFont().getSize2D() - 2.0f));
            }
            this.setOpaque(false);
        }
    }
}

