/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.datadosen.util.Colors;

public class JColorSelector
extends JPanel {
    protected String title;
    protected Color color = Color.black;
    Vector listeners;
    private final int Y_OFFSET = 1;

    public JColorSelector() {
        this("");
    }

    public JColorSelector(String title) {
        this.title = title;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHTMLColor() {
        return "#" + Integer.toHexString(this.color.getRGB()).substring(2);
    }

    public String toString() {
        return this.getHTMLColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String htmlColor) {
        this.setColor(Colors.getHTMLColor(htmlColor));
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
        this.fireActionOccured(new ActionEvent(this, 0, this.getHTMLColor()));
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(20, 16));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!JColorSelector.this.isEnabled()) {
                    return;
                }
                Color newColor = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(JColorSelector.this), JColorSelector.this.title, JColorSelector.this.color);
                if (newColor != null) {
                    JColorSelector.this.setColor(newColor);
                }
            }
        });
        this.setColor(this.color);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            Vector v = (Vector)this.listeners.clone();
            v.removeElement(l);
            this.listeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.listeners == null ? new Vector(2) : (Vector)this.listeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.listeners = v;
        }
    }

    protected void fireActionOccured(ActionEvent e) {
        if (this.listeners != null) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.color.brighter());
        g.fillRoundRect(0, 1, w - 1, h - 1 - 1, 5, 5);
        g.setColor(this.color);
        g.fillRoundRect(1, 2, w - 2, h - 1 - 2, 0, 0);
        g.setColor(this.color.darker());
        g.drawRoundRect(0, 1, w - 1, h - 1 - 1, 5, 5);
    }
}

