/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ImageIcon;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filters.BoxPanel;
import net.jalbum.filters.CroppingControl;
import se.datadosen.jalbum.ModifiesSize;
import se.datadosen.jalbum.Msg;

public class CroppingFilterPlugin
extends BoxPanel
implements ModifiesSize {
    private static final long serialVersionUID = -6690447553047905588L;
    CroppingControl croppingControl;

    public CroppingFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.cropping.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.cropping.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/crop.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.cropping.description");
        this.help = "";
        this.other = "";
        this.prescale = true;
        this.postscale = false;
        this.X1 = 0.1;
        this.X2 = 0.9;
        this.Y1 = 0.1;
        this.Y2 = 0.9;
        this.resizableBox.setInitial(false);
        this.resizableBox.update(this.X1, this.Y1, this.X2, this.Y2);
        this.resizableBox.adjustKeepRatio(true);
        this.croppingControl = new CroppingControl(this);
        this.boxControl = this.croppingControl;
        this.resizableObjectControl = this.croppingControl;
        this.croppingControl.update(this.X1, this.Y1, this.X2 - this.X1, this.Y2 - this.Y1);
    }

    public void setImage(BufferedImage bi) {
        super.setImage(bi);
        this.croppingControl.initiatePredefinedRatios();
        this.X1 = 0.1;
        this.X2 = 0.9;
        this.Y1 = 0.1;
        this.Y2 = 0.9;
        this.resizableBox.setInitial(false);
        this.resizableBox.update(this.X1, this.Y1, this.X2, this.Y2);
        this.resizableBox.adjustKeepRatio(true);
        this.renderPreview();
    }

    public BufferedImage renderImage(BufferedImage bi) {
        return bi.getSubimage((int)(this.X1 * (double)bi.getWidth()), (int)(this.Y1 * (double)bi.getHeight()), (int)((this.X2 - this.X1) * (double)bi.getWidth()), (int)((this.Y2 - this.Y1) * (double)bi.getHeight()));
    }

    public void renderPreview() {
        this.outputImage = FilterManager.cloneBufferedImage((BufferedImage)this.inputImage);
        this.paint(this.outputImage.getGraphics());
        this.filterManager.setGUIImage(this.outputImage);
    }

    public void paint(Graphics g) {
        g.setColor(new Color(255, 255, 255, 127));
        int intX1 = (int)(this.resizableBox.getOutX1() * (double)(this.width - 1));
        int intX2 = (int)(this.resizableBox.getOutX2() * (double)(this.width - 1));
        int intY1 = (int)(this.resizableBox.getOutY1() * (double)(this.height - 1));
        int intY2 = (int)(this.resizableBox.getOutY2() * (double)(this.height - 1));
        if (intX2 + 1 > 0 && intY1 > 0) {
            g.fillRect(0, 0, intX2 + 1, intY1);
        }
        if (this.resizableBox.getWidth() - 1 - intX2 > 0 && intY2 + 1 > 0) {
            g.fillRect(intX2 + 1, 0, this.resizableBox.getWidth() - 1 - intX2, intY2 + 1);
        }
        if (this.resizableBox.getWidth() - intX1 > 0 && this.resizableBox.getHeight() - 1 - intY2 > 0) {
            g.fillRect(intX1, intY2 + 1, this.resizableBox.getWidth() - intX1, this.resizableBox.getHeight() - 1 - intY2);
        }
        if (intX1 > 0 && this.resizableBox.getHeight() - intY1 > 0) {
            g.fillRect(0, intY1, intX1, this.resizableBox.getHeight() - intY1);
        }
        this.resizableBox.paintHandles(g);
    }

    public Dimension getModifiedSize(Dimension dimension, Map arg1) {
        return new Dimension((int)((this.X2 - this.X1) * dimension.getWidth()), (int)((this.Y2 - this.Y1) * dimension.getHeight()));
    }
}

