/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.BlurControl;
import se.datadosen.jalbum.Msg;

public class BlurFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = -2608721221010747854L;
    protected BlurControl blurControl;
    protected int strength = 1;
    protected int maxStrength = 5;

    public BlurFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.blur.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.blur.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/blur.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.blur.description");
        this.help = "";
        this.other = "";
        this.prescale = false;
        this.postscale = true;
        this.blurControl = new BlurControl(this);
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return bi;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        BufferedImage out = super.cloneBufferedImage(bi);
        int kernelSize = this.strength;
        int w = bi.getWidth();
        int h = bi.getHeight();
        int size = (kernelSize * 2 + 1) * (kernelSize * 2 + 1);
        float[] kernelcore = new float[size];
        float cellValue = 1.0f / (float)size;
        for (int i = 0; i <= size - 1; ++i) {
            kernelcore[i] = cellValue;
        }
        Kernel kernel = new Kernel(kernelSize * 2 + 1, kernelSize * 2 + 1, kernelcore);
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        out = op.filter(out, null);
        for (int x = 0; x < w; ++x) {
            int y;
            for (y = 0; y < kernelSize; ++y) {
                out.setRGB(x, y, this.blurPixel(x, y, w, h, bi));
            }
            for (y = h - 1 - (kernelSize - 1); y < h; ++y) {
                out.setRGB(x, y, this.blurPixel(x, y, w, h, bi));
            }
        }
        for (int y = kernelSize; y < h - kernelSize; ++y) {
            int x;
            for (x = 0; x < kernelSize; ++x) {
                out.setRGB(x, y, this.blurPixel(x, y, w, h, bi));
            }
            for (x = w - 1 - (kernelSize - 1); x < w; ++x) {
                out.setRGB(x, y, this.blurPixel(x, y, w, h, bi));
            }
        }
        return out;
    }

    private int blurPixel(int x, int y, int w, int h, BufferedImage bi) {
        int outX1 = x - this.strength;
        int outX2 = x + this.strength;
        int outY1 = y - this.strength;
        int outY2 = y + this.strength;
        if (outX1 < 0) {
            outX1 = 0;
        }
        if (outX2 > w - 1) {
            outX2 = w - 1;
        }
        if (outY1 < 0) {
            outY1 = 0;
        }
        if (outY2 > h - 1) {
            outY2 = h - 1;
        }
        int rgb = 0;
        int counter = (outX2 - outX1 + 1) * (outY2 - outY1 + 1);
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        for (int posY = outY1; posY <= outY2; ++posY) {
            for (int posX = outX1; posX <= outX2; ++posX) {
                rgb = bi.getRGB(posX, posY);
                alpha += (int)(((long)rgb & 0xFF000000L) >> 24);
                red += (rgb & 0xFF0000) >> 16;
                green += (rgb & 0xFF00) >> 8;
                blue += rgb & 0xFF;
            }
        }
        return ((alpha /= counter) & 0xFF) << 24 | ((red /= counter) & 0xFF) << 16 | ((green /= counter) & 0xFF) << 8 | (blue /= counter) & 0xFF;
    }

    public JPanel getControls() {
        return this.blurControl;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public void adjustStrength(int strength) {
        if (strength > this.maxStrength) {
            strength = this.maxStrength;
        } else if (strength < 0) {
            strength = 0;
        }
        this.strength = strength;
        this.renderImage();
    }

    public int getMaxStrength() {
        return this.maxStrength;
    }

    public void setMaxStrength(int maxStrength) {
        this.maxStrength = maxStrength;
    }
}

