/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.net;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jabref.net.Cookie;

public class CookieHandlerImpl
extends CookieHandler {
    private List<Cookie> cache = new LinkedList<Cookie>();

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        List<String> setCookieList = responseHeaders.get("Set-Cookie");
        if (setCookieList != null) {
            for (String item : setCookieList) {
                Cookie cookie = new Cookie(uri, item);
                Iterator<Cookie> i = this.cache.iterator();
                while (i.hasNext()) {
                    Cookie existingCookie = i.next();
                    if (!cookie.domain.equals(existingCookie.domain) || !cookie.getName().equals(existingCookie.getName())) continue;
                    i.remove();
                    break;
                }
                this.cache.add(cookie);
            }
        }
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        StringBuilder cookies = new StringBuilder();
        Iterator<Cookie> i = this.cache.iterator();
        while (i.hasNext()) {
            Cookie cookie = i.next();
            if (cookie.hasExpired()) {
                i.remove();
                continue;
            }
            if (!cookie.matches(uri)) continue;
            if (cookies.length() > 0) {
                cookies.append(", ");
            }
            cookies.append(cookie.toString());
        }
        HashMap<String, List<String>> cookieMap = new HashMap<String, List<String>>(requestHeaders);
        if (cookies.length() > 0) {
            List<String> list = Collections.singletonList(cookies.toString());
            cookieMap.put("Cookie", list);
        }
        return Collections.unmodifiableMap(cookieMap);
    }
}

