/*
 * Decompiled with CFR 0.152.
 */
package spl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.MediaType;
import org.sciplore.beans.Author;
import org.sciplore.beans.Document;
import org.sciplore.deserialize.creator.AuthorBeanCreator;
import org.sciplore.deserialize.creator.AuthorsBeanCreator;
import org.sciplore.deserialize.creator.DefaultStringCreator;
import org.sciplore.deserialize.creator.DocumentBeanCreator;
import org.sciplore.deserialize.creator.DocumentsBeanCreator;
import org.sciplore.deserialize.creator.TitleBeanCreator;
import org.sciplore.deserialize.creator.YearBeanCreator;
import org.sciplore.deserialize.reader.ObjectCreatorMapper;
import org.sciplore.deserialize.reader.XmlResourceReader;
import org.sciplore.formatter.Bean;
import org.sciplore.formatter.SimpleTypeElementBean;
import spl.Tools;

public class SplWebClient {
    private static Client CLIENT = Client.create();
    private static WebResource WEBRESOURCE;
    private static WebResource INTERNETRESOURCE;
    public static Document metadata;

    public static WebServiceStatus getMetaData(File file) {
        try {
            if (!SplWebClient.isWebServiceAvailable()) {
                if (SplWebClient.isInternetAvailable()) {
                    return WebServiceStatus.WEBSERVICE_DOWN;
                }
                return WebServiceStatus.NO_INTERNET;
            }
            if (SplWebClient.isWebServiceOutDated()) {
                return WebServiceStatus.OUTDATED;
            }
            if (!SplWebClient.isMetaDataServiceAvailable()) {
                return WebServiceStatus.UNAVAILABLE;
            }
            FileInputStream fin = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            fin.read(data);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field("file", data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart.field("source", "jabref", MediaType.TEXT_PLAIN_TYPE);
            formDataMultiPart.field("filename", file.getName(), MediaType.TEXT_PLAIN_TYPE);
            ClientResponse response = WEBRESOURCE.path("documents").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)formDataMultiPart);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity()) {
                String entity = response.getEntity(String.class);
                byte[] bytes = new byte[]{};
                try {
                    bytes = entity.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                if (is != null) {
                    ObjectCreatorMapper resourceMapper = new ObjectCreatorMapper();
                    DefaultStringCreator stringCreator = new DefaultStringCreator();
                    resourceMapper.addCreator("documents", new DocumentsBeanCreator());
                    resourceMapper.addCreator("authors", new AuthorsBeanCreator());
                    resourceMapper.addCreator("document", new DocumentBeanCreator());
                    resourceMapper.addCreator("title", new TitleBeanCreator());
                    resourceMapper.addCreator("year", new YearBeanCreator());
                    resourceMapper.addCreator("author", new AuthorBeanCreator());
                    resourceMapper.addCreator("name_first", stringCreator);
                    resourceMapper.addCreator("name_middle", stringCreator);
                    resourceMapper.addCreator("name_last", stringCreator);
                    resourceMapper.addCreator("name_last_prefix", stringCreator);
                    resourceMapper.addCreator("name_last_suffix", stringCreator);
                    XmlResourceReader reader = new XmlResourceReader(resourceMapper);
                    Document docs = (Document)reader.parse(is);
                    for (Bean author : docs.getAuthors().getCollection()) {
                        Author temp = (Author)author;
                        System.out.println(((SimpleTypeElementBean)temp.getName_Last()).getValue() + " " + temp.getRank());
                    }
                    metadata = docs;
                    return WebServiceStatus.OK;
                }
                return WebServiceStatus.NO_METADATA;
            }
            if (response.getClientResponseStatus() == ClientResponse.Status.SERVICE_UNAVAILABLE) {
                return WebServiceStatus.UNAVAILABLE;
            }
        }
        catch (Exception e) {
            System.out.println(Tools.getStackTraceAsString(e));
        }
        return WebServiceStatus.NO_METADATA;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWebServiceOutDated() {
        try {
            String entity;
            byte[] bytes;
            ByteArrayInputStream is;
            ClientResponse response = WEBRESOURCE.path("service/versioncheck/" + Tools.WEBSERVICE_APP_ID + "/current").get(ClientResponse.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity() && (is = new ByteArrayInputStream(bytes = (entity = response.getEntity(String.class)).getBytes())) == null) return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isMetaDataServiceAvailable() {
        try {
            String entity;
            ClientResponse response = WEBRESOURCE.path("service/metadata/available").get(ClientResponse.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity() && (entity = response.getEntity(String.class)) != null && entity.equalsIgnoreCase("false")) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isWebServiceAvailable() {
        try {
            ClientResponse response = WEBRESOURCE.path("service/metadata/available").get(ClientResponse.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isInternetAvailable() {
        try {
            ClientResponse response = INTERNETRESOURCE.get(ClientResponse.class);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        CLIENT.setConnectTimeout(1000);
        CLIENT.setReadTimeout(70000);
        WEBRESOURCE = CLIENT.resource("http://api.mr-dlib.org/");
        INTERNETRESOURCE = CLIENT.resource("http://www.google.com");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebServiceStatus {
        OK,
        NO_METADATA,
        UNAVAILABLE,
        OUTDATED,
        WEBSERVICE_DOWN,
        NO_INTERNET;

    }
}

