/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.misc.BitSet;
import org.antlr.misc.IntSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NFAToDFAConverter {
    public static boolean debug = false;
    public static boolean SINGLE_THREADED_NFA_CONVERSION = true;
    protected List work;
    protected NFAContext[] contextTrees;
    protected DFA dfa;

    public void convert() {
        this.dfa.conversionStartTime = System.currentTimeMillis();
        this.dfa.startState = this.computeStartState();
        while (this.work.size() > 0) {
            int k;
            DFAState d = (DFAState)this.work.get(0);
            if (this.dfa.nfa.grammar.getWatchNFAConversion()) {
                System.out.println("convert DFA state " + d.stateNumber + " (" + d.getNFAConfigurations().size() + " nfa states)");
            }
            if ((k = this.dfa.getUserMaxLookahead()) > 0 && k == d.getLookaheadDepth()) {
                this.resolveNonDeterminisms(d);
                if (d.isResolvedWithPredicates()) {
                    this.addPredicateTransitions(d);
                } else {
                    d.setAcceptState(true);
                }
            } else {
                this.findNewDFAStatesAndAddDFATransitions(d);
            }
            this.work.remove(0);
        }
    }

    protected DFAState computeStartState() {
        NFAState alt = this.dfa.decisionNFAStartState;
        DFAState startState = this.dfa.newState();
        int i = 0;
        int altNum = 1;
        while (alt != null) {
            NFAContext initialContext = this.contextTrees[i];
            if (i == 0 && this.dfa.getNFADecisionStartState().decisionStateType == 1) {
                int numAltsIncludingExitBranch;
                altNum = numAltsIncludingExitBranch = this.dfa.nfa.grammar.getNumberOfAltsForDecisionNFA(this.dfa.decisionNFAStartState);
                this.closure((NFAState)alt.transition((int)0).target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                altNum = 1;
            } else {
                this.closure((NFAState)alt.transition((int)0).target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                ++altNum;
            }
            ++i;
            if (alt.transition(1) == null) break;
            alt = (NFAState)alt.transition((int)1).target;
        }
        this.dfa.addState(startState);
        this.work.add(startState);
        return startState;
    }

    protected void findNewDFAStatesAndAddDFATransitions(DFAState d) {
        OrderedHashSet labels = d.getReachableLabels();
        Label EOTLabel = new Label(-2);
        boolean containsEOT = labels.contains(EOTLabel);
        if (!this.dfa.isGreedy() && containsEOT) {
            this.convertToEOTAcceptState(d);
            return;
        }
        int numberOfEdgesEmanating = 0;
        HashMap targetToLabelMap = new HashMap();
        int i = 0;
        while (!d.abortedDueToMultipleRecursiveAlts && i < labels.size()) {
            Label label = (Label)labels.get(i);
            DFAState t = this.reach(d, label);
            if (debug) {
                System.out.println("DFA state after reach " + d + '-' + label.toString(this.dfa.nfa.grammar) + "->" + t);
            }
            if (t != null) {
                if (t.getUniqueAlt() == -1) {
                    this.closure(t);
                }
                DFAState targetState = this.addDFAStateToWorkList(t);
                numberOfEdgesEmanating += NFAToDFAConverter.addTransition(d, label, targetState, targetToLabelMap);
                targetState.setLookaheadDepth(d.getLookaheadDepth() + 1);
                if (t.abortedDueToMultipleRecursiveAlts && !t.isResolvedWithPredicates()) {
                    t.dfa.probe.reportNonRegularDecision(t.dfa);
                }
            }
            ++i;
        }
        if (!d.isResolvedWithPredicates() && numberOfEdgesEmanating == 0) {
            this.dfa.probe.reportDanglingState(d);
            int minAlt = this.resolveByPickingMinAlt(d, null);
            this.convertToAcceptState(d, minAlt);
        }
        if (d.isResolvedWithPredicates()) {
            this.addPredicateTransitions(d);
        }
    }

    protected static int addTransition(DFAState d, Label label, DFAState targetState, Map targetToLabelMap) {
        int n = 0;
        if (DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES) {
            Integer tI = Utils.integer(targetState.stateNumber);
            Transition oldTransition = (Transition)targetToLabelMap.get(tI);
            if (oldTransition != null) {
                if (label.getAtom() == -2) {
                    oldTransition.label = new Label(-2);
                } else if (oldTransition.label.getAtom() != -2) {
                    oldTransition.label.add(label);
                }
            } else {
                n = 1;
                label = (Label)label.clone();
                int transitionIndex = d.addTransition(targetState, label);
                Transition trans = d.getTransition(transitionIndex);
                targetToLabelMap.put(tI, trans);
            }
        } else {
            n = 1;
            d.addTransition(targetState, label);
        }
        return n;
    }

    public void closure(DFAState d) {
        if (debug) {
            System.out.println("closure(" + d + ')');
        }
        HashSet configs = new HashSet();
        configs.addAll(d.getNFAConfigurations());
        Iterator iter = configs.iterator();
        while (!d.abortedDueToMultipleRecursiveAlts && iter.hasNext()) {
            NFAConfiguration c = (NFAConfiguration)iter.next();
            if (c.singleAtomTransitionEmanating) continue;
            this.closure(this.dfa.nfa.getState(c.state), c.alt, c.context, c.semanticContext, d, false);
        }
        d.closureBusy = null;
    }

    public void closure(NFAState p, int alt, NFAContext context, SemanticContext semanticContext, DFAState d, boolean collectPredicates) {
        if (debug) {
            System.out.println("closure at NFA state " + p.stateNumber + '|' + alt + " filling DFA state " + d.stateNumber + " with context " + context);
        }
        if (d.abortedDueToMultipleRecursiveAlts) {
            return;
        }
        NFAConfiguration proposedNFAConfiguration = new NFAConfiguration(p.stateNumber, alt, context, semanticContext);
        if (NFAToDFAConverter.closureIsBusy(d, proposedNFAConfiguration)) {
            if (debug) {
                System.out.println("avoid visiting exact closure computation NFA config: " + proposedNFAConfiguration);
                System.out.println("state is " + d.dfa.decisionNumber + '.' + d);
            }
            return;
        }
        d.closureBusy.add(proposedNFAConfiguration);
        d.addNFAConfiguration(p, proposedNFAConfiguration);
        Transition transition0 = p.transition(0);
        if (transition0 instanceof RuleClosureTransition) {
            int depth = context.recursionDepthEmanatingFromState(p.stateNumber);
            if (depth == 1 && d.dfa.getUserMaxLookahead() == 0) {
                d.dfa.recursiveAltSet.add(alt);
                if (d.dfa.recursiveAltSet.size() > 1) {
                    d.abortedDueToMultipleRecursiveAlts = true;
                    return;
                }
            }
            if (depth >= NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK) {
                d.dfa.probe.reportRecursiveOverflow(d, proposedNFAConfiguration);
                d.abortedDueToRecursionOverflow = true;
                return;
            }
            RuleClosureTransition ref = (RuleClosureTransition)transition0;
            NFAContext newContext = new NFAContext(context, p);
            NFAState ruleTarget = (NFAState)ref.target;
            this.closure(ruleTarget, alt, newContext, semanticContext, d, collectPredicates);
        } else if (p.isAcceptState() && context.parent != null) {
            NFAState whichStateInvokedRule = context.invokingState;
            RuleClosureTransition edgeToRule = (RuleClosureTransition)whichStateInvokedRule.transition(0);
            NFAState continueState = edgeToRule.getFollowState();
            NFAContext newContext = context.parent;
            this.closure(continueState, alt, newContext, semanticContext, d, collectPredicates);
        } else {
            if (transition0 != null && transition0.isEpsilon()) {
                this.closure((NFAState)transition0.target, alt, context, semanticContext, d, collectPredicates);
            } else if (transition0 != null && transition0.isSemanticPredicate()) {
                SemanticContext newSemanticContext = semanticContext;
                if (collectPredicates) {
                    SemanticContext labelContext = transition0.label.getSemanticContext();
                    int walkAlt = this.dfa.decisionNFAStartState.translateDisplayAltToWalkAlt(this.dfa, alt);
                    NFAState altLeftEdge = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(this.dfa.decisionNFAStartState, walkAlt);
                    if (!labelContext.isSyntacticPredicate() || p == altLeftEdge.transition((int)0).target) {
                        newSemanticContext = SemanticContext.and(semanticContext, labelContext);
                    }
                }
                this.closure((NFAState)transition0.target, alt, context, newSemanticContext, d, collectPredicates);
            }
            Transition transition1 = p.transition(1);
            if (transition1 != null && transition1.isEpsilon()) {
                this.closure((NFAState)transition1.target, alt, context, semanticContext, d, collectPredicates);
            }
        }
    }

    public static boolean closureIsBusy(DFAState d, NFAConfiguration proposedNFAConfiguration) {
        return d.closureBusy.contains(proposedNFAConfiguration);
    }

    public DFAState reach(DFAState d, Label label) {
        DFAState labelDFATarget = this.dfa.newState();
        int intLabel = label.getAtom();
        IntSet setLabel = label.getSet();
        Iterator iter = d.getNFAConfigurations().iterator();
        while (iter.hasNext()) {
            boolean matched;
            NFAState p;
            Transition edge;
            NFAConfiguration c = (NFAConfiguration)iter.next();
            if (c.resolved || c.resolveWithPredicate || (edge = (p = this.dfa.nfa.getState(c.state)).transition(0)) == null || !c.singleAtomTransitionEmanating) continue;
            Label edgeLabel = edge.label;
            if (c.context.parent != null && edgeLabel.isAtom() && edgeLabel.getAtom() == -2) continue;
            boolean bl = false;
            if (!label.isSet() && edgeLabel.getAtom() == intLabel || !edgeLabel.getSet().and(setLabel).isNil()) {
                bl = true;
            }
            if (!(matched = bl)) continue;
            labelDFATarget.addNFAConfiguration((NFAState)edge.target, c.alt, c.context, c.semanticContext);
        }
        if (labelDFATarget.getNFAConfigurations().size() == 0) {
            this.dfa.setState(labelDFATarget.stateNumber, null);
            labelDFATarget = null;
        }
        return labelDFATarget;
    }

    protected void convertToEOTAcceptState(DFAState d) {
        Label eot = new Label(-2);
        Iterator iter = d.getNFAConfigurations().iterator();
        while (iter.hasNext()) {
            NFAConfiguration c = (NFAConfiguration)iter.next();
            if (c.resolved || c.resolveWithPredicate) continue;
            NFAState p = this.dfa.nfa.getState(c.state);
            Transition edge = p.transition(0);
            Label edgeLabel = edge.label;
            if (!edgeLabel.equals(eot)) continue;
            d.setAcceptState(true);
            d.getNFAConfigurations().clear();
            d.addNFAConfiguration(p, c.alt, c.context, c.semanticContext);
            return;
        }
    }

    protected DFAState addDFAStateToWorkList(DFAState d) {
        DFAState existingState = this.dfa.addState(d);
        if (d != existingState) {
            this.dfa.setState(d.stateNumber, existingState);
            return existingState;
        }
        this.resolveNonDeterminisms(d);
        int alt = d.getUniquelyPredictedAlt();
        if (alt != -1) {
            d = this.convertToAcceptState(d, alt);
        } else {
            this.work.add(d);
        }
        return d;
    }

    protected DFAState convertToAcceptState(DFAState d, int alt) {
        if (DFAOptimizer.MERGE_STOP_STATES && d.getNonDeterministicAlts() == null && !d.abortedDueToRecursionOverflow && !d.abortedDueToMultipleRecursiveAlts) {
            DFAState acceptStateForAlt = this.dfa.getAcceptState(alt);
            if (acceptStateForAlt != null) {
                SemanticContext gatedPreds = d.getGatedPredicatesInNFAConfigurations();
                SemanticContext existingStateGatedPreds = acceptStateForAlt.getGatedPredicatesInNFAConfigurations();
                if (gatedPreds == null && existingStateGatedPreds == null || gatedPreds != null && existingStateGatedPreds != null && gatedPreds.equals(existingStateGatedPreds)) {
                    this.dfa.setState(d.stateNumber, acceptStateForAlt);
                    this.dfa.removeState(d);
                    d = acceptStateForAlt;
                    return d;
                }
            }
            d.setAcceptState(true);
            this.dfa.setAcceptState(alt, d);
            return d;
        }
        d.setAcceptState(true);
        this.dfa.setAcceptState(alt, d);
        return d;
    }

    public void resolveNonDeterminisms(DFAState d) {
        boolean resolved;
        Set allAlts;
        if (debug) {
            System.out.println("resolveNonDeterminisms " + d.toString());
        }
        boolean conflictingLexerRules = false;
        Set nondeterministicAlts = d.getNonDeterministicAlts();
        if (debug && nondeterministicAlts != null) {
            System.out.println("nondet alts=" + nondeterministicAlts);
        }
        Iterator itr = d.nfaConfigurations.iterator();
        NFAConfiguration anyConfig = (NFAConfiguration)itr.next();
        NFAState anyState = this.dfa.nfa.getState(anyConfig.state);
        if (anyState.isEOTTargetState() && (allAlts = d.getAltSet()) != null && allAlts.size() > 1) {
            nondeterministicAlts = allAlts;
            if (d.dfa.isTokensRuleDecision()) {
                this.dfa.probe.reportLexerRuleNondeterminism(d, allAlts);
                conflictingLexerRules = true;
            }
        }
        if (!d.abortedDueToRecursionOverflow && nondeterministicAlts == null) {
            return;
        }
        if (!d.abortedDueToRecursionOverflow && !conflictingLexerRules) {
            this.dfa.probe.reportNondeterminism(d, nondeterministicAlts);
        }
        if (resolved = this.tryToResolveWithSemanticPredicates(d, nondeterministicAlts)) {
            d.resolvedWithPredicates = true;
            this.dfa.probe.reportNondeterminismResolvedWithSemanticPredicate(d);
            return;
        }
        this.resolveByChoosingFirstAlt(d, nondeterministicAlts);
    }

    protected int resolveByChoosingFirstAlt(DFAState d, Set nondeterministicAlts) {
        int exitAlt;
        int winningAlt = 0;
        winningAlt = this.dfa.isGreedy() ? this.resolveByPickingMinAlt(d, nondeterministicAlts) : (nondeterministicAlts.contains(Utils.integer(exitAlt = this.dfa.getNumberOfAlts())) ? this.resolveByPickingExitAlt(d, nondeterministicAlts) : this.resolveByPickingMinAlt(d, nondeterministicAlts));
        return winningAlt;
    }

    protected int resolveByPickingMinAlt(DFAState d, Set nondeterministicAlts) {
        int min = Integer.MAX_VALUE;
        min = nondeterministicAlts != null ? NFAToDFAConverter.getMinAlt(nondeterministicAlts) : NFAToDFAConverter.getMinAlt(d);
        NFAToDFAConverter.turnOffOtherAlts(d, min, nondeterministicAlts);
        return min;
    }

    protected int resolveByPickingExitAlt(DFAState d, Set nondeterministicAlts) {
        int exitAlt = this.dfa.getNumberOfAlts();
        NFAToDFAConverter.turnOffOtherAlts(d, exitAlt, nondeterministicAlts);
        return exitAlt;
    }

    protected static void turnOffOtherAlts(DFAState d, int min, Set nondeterministicAlts) {
        Iterator iter = d.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            if (configuration.alt == min || nondeterministicAlts != null && !nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
            configuration.resolved = true;
        }
    }

    protected static int getMinAlt(DFAState d) {
        int min = Integer.MAX_VALUE;
        Iterator iter = d.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            if (configuration.alt >= min) continue;
            min = configuration.alt;
        }
        return min;
    }

    protected static int getMinAlt(Set nondeterministicAlts) {
        int min = Integer.MAX_VALUE;
        Iterator iter = nondeterministicAlts.iterator();
        while (iter.hasNext()) {
            Integer altI = (Integer)iter.next();
            int alt = altI;
            if (alt >= min) continue;
            min = alt;
        }
        return min;
    }

    protected boolean tryToResolveWithSemanticPredicates(DFAState d, Set nondeterministicAlts) {
        Map altToPredMap = this.getPredicatesPerNonDeterministicAlt(d, nondeterministicAlts);
        if (altToPredMap.size() == 0) {
            return false;
        }
        this.dfa.probe.reportAltPredicateContext(d, altToPredMap);
        if (nondeterministicAlts.size() - altToPredMap.size() > 1) {
            return false;
        }
        if (altToPredMap.size() == nondeterministicAlts.size() - 1) {
            SemanticContext unionOfPredicatesFromAllAlts;
            BitSet ndSet = BitSet.of(nondeterministicAlts);
            BitSet predSet = BitSet.of(altToPredMap);
            int nakedAlt = ndSet.subtract(predSet).getSingleElement();
            SemanticContext nakedAltPred = null;
            nakedAltPred = nakedAlt == NFAToDFAConverter.max(nondeterministicAlts) ? new SemanticContext.TruePredicate() : ((unionOfPredicatesFromAllAlts = NFAToDFAConverter.getUnionOfPredicates(altToPredMap)).isSyntacticPredicate() ? new SemanticContext.TruePredicate() : SemanticContext.not(unionOfPredicatesFromAllAlts));
            altToPredMap.put(Utils.integer(nakedAlt), nakedAltPred);
            Iterator iter = d.nfaConfigurations.iterator();
            while (iter.hasNext()) {
                NFAConfiguration configuration = (NFAConfiguration)iter.next();
                if (configuration.alt != nakedAlt) continue;
                configuration.semanticContext = nakedAltPred;
            }
        }
        if (altToPredMap.size() == nondeterministicAlts.size()) {
            if (d.abortedDueToRecursionOverflow) {
                d.dfa.probe.removeRecursiveOverflowState(d);
            }
            Iterator iter = d.nfaConfigurations.iterator();
            while (iter.hasNext()) {
                NFAConfiguration configuration = (NFAConfiguration)iter.next();
                SemanticContext semCtx = (SemanticContext)altToPredMap.get(Utils.integer(configuration.alt));
                if (semCtx != null) {
                    configuration.resolveWithPredicate = true;
                    configuration.semanticContext = semCtx;
                    altToPredMap.remove(Utils.integer(configuration.alt));
                    if (!semCtx.isSyntacticPredicate()) continue;
                    this.dfa.nfa.grammar.synPredUsedInDFA(this.dfa, semCtx);
                    continue;
                }
                if (!nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
                configuration.resolved = true;
            }
            return true;
        }
        return false;
    }

    protected Map getPredicatesPerNonDeterministicAlt(DFAState d, Set nondeterministicAlts) {
        HashMap<Integer, SemanticContext> altToPredicateContextMap = new HashMap<Integer, SemanticContext>();
        HashMap altToSetOfContextsMap = new HashMap();
        Iterator it = nondeterministicAlts.iterator();
        while (it.hasNext()) {
            Integer altI = (Integer)it.next();
            altToSetOfContextsMap.put(altI, new HashSet());
        }
        HashSet<Integer> altToIncompletePredicateContextSet = new HashSet<Integer>();
        Iterator iter = d.nfaConfigurations.iterator();
        while (iter.hasNext()) {
            NFAConfiguration configuration = (NFAConfiguration)iter.next();
            Integer altI = Utils.integer(configuration.alt);
            if (!nondeterministicAlts.contains(altI)) continue;
            if (configuration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
                Set predSet = (Set)altToSetOfContextsMap.get(altI);
                predSet.add(configuration.semanticContext);
                continue;
            }
            altToIncompletePredicateContextSet.add(altI);
        }
        ArrayList<Integer> incompletelyCoveredAlts = new ArrayList<Integer>();
        Iterator it2 = nondeterministicAlts.iterator();
        while (it2.hasNext()) {
            Integer altI = (Integer)it2.next();
            Set predSet = (Set)altToSetOfContextsMap.get(altI);
            if (altToIncompletePredicateContextSet.contains(altI)) {
                SemanticContext insufficientPred = (SemanticContext)altToPredicateContextMap.get(altI);
                if (predSet.size() <= 0) continue;
                incompletelyCoveredAlts.add(altI);
                continue;
            }
            SemanticContext combinedContext = null;
            Iterator itrSet = predSet.iterator();
            while (itrSet.hasNext()) {
                SemanticContext ctx = (SemanticContext)itrSet.next();
                combinedContext = SemanticContext.or(combinedContext, ctx);
            }
            altToPredicateContextMap.put(altI, combinedContext);
        }
        if (incompletelyCoveredAlts.size() > 0) {
            this.dfa.probe.reportIncompletelyCoveredAlts(d, incompletelyCoveredAlts);
        }
        return altToPredicateContextMap;
    }

    protected static SemanticContext getUnionOfPredicates(Map altToPredMap) {
        SemanticContext unionOfPredicatesFromAllAlts = null;
        Iterator iter = altToPredMap.values().iterator();
        while (iter.hasNext()) {
            SemanticContext semCtx = (SemanticContext)iter.next();
            unionOfPredicatesFromAllAlts = unionOfPredicatesFromAllAlts == null ? semCtx : SemanticContext.or(unionOfPredicatesFromAllAlts, semCtx);
        }
        return unionOfPredicatesFromAllAlts;
    }

    protected void addPredicateTransitions(DFAState d) {
        ArrayList<NFAConfiguration> configsWithPreds = new ArrayList<NFAConfiguration>();
        Iterator iter = d.getNFAConfigurations().iterator();
        while (iter.hasNext()) {
            NFAConfiguration c = (NFAConfiguration)iter.next();
            if (!c.resolveWithPredicate) continue;
            configsWithPreds.add(c);
        }
        Collections.sort(configsWithPreds, new Comparator(){

            public final int compare(Object a, Object b) {
                NFAConfiguration ca = (NFAConfiguration)a;
                NFAConfiguration cb = (NFAConfiguration)b;
                if (ca.alt < cb.alt) {
                    return -1;
                }
                if (ca.alt > cb.alt) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<NFAConfiguration> predConfigsSortedByAlt = configsWithPreds;
        int i = 0;
        while (i < predConfigsSortedByAlt.size()) {
            NFAConfiguration c = (NFAConfiguration)predConfigsSortedByAlt.get(i);
            DFAState predDFATarget = d.dfa.getAcceptState(c.alt);
            if (predDFATarget == null) {
                predDFATarget = this.dfa.newState();
                predDFATarget.addNFAConfiguration(this.dfa.nfa.getState(c.state), c.alt, c.context, c.semanticContext);
                predDFATarget.setAcceptState(true);
                DFAState existingState = this.dfa.addState(predDFATarget);
                if (predDFATarget != existingState) {
                    this.dfa.setState(predDFATarget.stateNumber, existingState);
                    predDFATarget = existingState;
                }
            }
            d.addTransition(predDFATarget, new Label(c.semanticContext));
            ++i;
        }
    }

    protected void initContextTrees(int numberOfAlts) {
        this.contextTrees = new NFAContext[numberOfAlts];
        int i = 0;
        while (i < this.contextTrees.length) {
            int alt = i + 1;
            this.contextTrees[i] = new NFAContext(null, null);
            ++i;
        }
    }

    public static int max(Set s) {
        if (s == null) {
            return Integer.MIN_VALUE;
        }
        int i = 0;
        int m = 0;
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Integer I = (Integer)it.next();
            if (++i == 1) {
                m = I;
                continue;
            }
            if (I <= m) continue;
            m = I;
        }
        return m;
    }

    private final /* synthetic */ void this() {
        this.work = new LinkedList();
    }

    public NFAToDFAConverter(DFA dfa) {
        this.this();
        this.dfa = dfa;
        NFAState nfaStartState = dfa.getNFADecisionStartState();
        int nAlts = dfa.nfa.grammar.getNumberOfAltsForDecisionNFA(nfaStartState);
        this.initContextTrees(nAlts);
    }
}

