/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.importer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.importer.DBImporter;

public class PostgreSQLImporter
extends DBImporter {
    private static PostgreSQLImporter instance = null;

    private PostgreSQLImporter() {
    }

    public static PostgreSQLImporter getInstance() {
        if (instance == null) {
            instance = new PostgreSQLImporter();
        }
        return instance;
    }

    protected ResultSet readColumnNames(Connection conn) throws SQLException {
        Statement statement = (Statement)SQLUtil.processQueryWithResults(conn, "SELECT column_name FROM information_schema.columns WHERE table_name ='entries';");
        ResultSet rs = statement.getResultSet();
        return rs;
    }

    protected Connection connectToDB(DBStrings dbstrings) throws Exception {
        String url = SQLUtil.createJDBCurl(dbstrings, true);
        String drv = "org.postgresql.Driver";
        Class.forName(drv).newInstance();
        Connection conn = DriverManager.getConnection(url, dbstrings.getUsername(), dbstrings.getPassword());
        return conn;
    }
}

