/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.exporter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.sf.jabref.Util;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.exporter.DBExporter;

public class MySQLExporter
extends DBExporter {
    private static MySQLExporter instance = null;

    private MySQLExporter() {
    }

    public static MySQLExporter getInstance() {
        if (instance == null) {
            instance = new MySQLExporter();
        }
        return instance;
    }

    public Connection connectToDB(DBStrings dbstrings) throws Exception {
        this.dbStrings = dbstrings;
        String url = SQLUtil.createJDBCurl(dbstrings, false);
        String drv = "com.mysql.jdbc.Driver";
        Class.forName(drv).newInstance();
        Connection conn = DriverManager.getConnection(url, dbstrings.getUsername(), dbstrings.getPassword());
        SQLUtil.processQuery(conn, "CREATE DATABASE IF NOT EXISTS `" + this.dbStrings.getDatabase() + "`");
        SQLUtil.processQuery(conn, "USE `" + this.dbStrings.getDatabase() + "`");
        return conn;
    }

    protected void createTables(Object out) throws SQLException {
        SQLUtil.processQuery(out, "CREATE TABLE IF NOT EXISTS jabref_database ( \ndatabase_id INT UNSIGNED NOT NULL AUTO_INCREMENT, \ndatabase_name VARCHAR(64) NOT NULL, \nmd5_path VARCHAR(32) NOT NULL, \nPRIMARY KEY (database_id)\n );");
        SQLUtil.processQuery(out, "CREATE TABLE IF NOT EXISTS entry_types ( \nentry_types_id    INT UNSIGNED  NOT NULL AUTO_INCREMENT, \nlabel\t\t\t TEXT, \n" + SQLUtil.fieldsAsCols(SQLUtil.getAllFields(), " VARCHAR(3) DEFAULT NULL") + ", \n" + "PRIMARY KEY (entry_types_id) \n" + ");");
        SQLUtil.processQuery(out, "CREATE TABLE IF NOT EXISTS entries ( \nentries_id      INTEGER         NOT NULL AUTO_INCREMENT, \njabref_eid      VARCHAR(" + Util.getMinimumIntegerDigits() + ")   DEFAULT NULL, \n" + "database_id INT UNSIGNED, \n" + "entry_types_id  INT UNSIGNED         DEFAULT NULL, \n" + "cite_key        VARCHAR(100)     DEFAULT NULL, \n" + SQLUtil.fieldsAsCols(SQLUtil.getAllFields(), " TEXT DEFAULT NULL") + ",\n" + "PRIMARY KEY (entries_id), \n" + "INDEX(entry_types_id), \n" + "FOREIGN KEY (entry_types_id) REFERENCES entry_types(entry_types_id), \n" + "FOREIGN KEY (database_id) REFERENCES jabref_database(database_id) \n);");
        SQLUtil.processQuery(out, "CREATE TABLE IF NOT EXISTS strings ( \nstrings_id      INTEGER         NOT NULL AUTO_INCREMENT, \nlabel      VARCHAR(100)  DEFAULT NULL, \ncontent    VARCHAR(200)  DEFAULT NULL, \ndatabase_id INT UNSIGNED, \nFOREIGN KEY (database_id) REFERENCES jabref_database(database_id), \nPRIMARY KEY (strings_id) \n);");
        SQLUtil.processQuery(out, "CREATE TABLE IF NOT EXISTS group_types ( \ngroup_types_id  INTEGER     NOT NULL AUTO_INCREMENT, \nlabel   VARCHAR(100)    DEFAULT NULL, \nPRIMARY KEY (group_types_id) \n);");
        SQLUtil.processQuery(out, "CREATE TABLE IF NOT EXISTS groups ( \ngroups_id       INTEGER         NOT NULL AUTO_INCREMENT, \ngroup_types_id  INTEGER         DEFAULT NULL, \nlabel           VARCHAR(100)    DEFAULT NULL, \ndatabase_id INT UNSIGNED, \nparent_id       INTEGER         DEFAULT NULL, \nsearch_field       VARCHAR(100)          DEFAULT NULL, \nsearch_expression  VARCHAR(200)          DEFAULT NULL, \ncase_sensitive  BOOL          DEFAULT NULL, \nreg_exp BOOL DEFAULT NULL, \nhierarchical_context INTEGER DEFAULT NULL, \nFOREIGN KEY (database_id) REFERENCES jabref_database(database_id), \nPRIMARY KEY (groups_id) \n);");
        SQLUtil.processQuery(out, "CREATE TABLE IF NOT EXISTS entry_group ( \nentries_id       INTEGER        NOT NULL AUTO_INCREMENT, \ngroups_id        INTEGER        DEFAULT NULL, \nINDEX(entries_id), \nINDEX(groups_id), \nFOREIGN KEY (entries_id) REFERENCES entries(entries_id) ON DELETE CASCADE, \nFOREIGN KEY (groups_id)  REFERENCES groups(groups_id), \nPRIMARY KEY (groups_id, entries_id) \n);");
    }
}

