/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.sql.DBConnectDialog;
import net.sf.jabref.sql.DBExporterAndImporterFactory;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;
import net.sf.jabref.sql.exporter.DBExporter;

public class DbConnectAction
extends BaseAction {
    private BasePanel panel;

    public DbConnectAction(BasePanel panel) {
        this.panel = panel;
    }

    public AbstractAction getAction() {
        return new DbImpAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() {
        DBStrings dbs = this.panel.metaData().getDBStrings();
        if (!dbs.isInitialized()) {
            dbs.initialize();
        }
        DBConnectDialog dbd = new DBConnectDialog(this.panel.frame(), dbs);
        Util.placeDialog(dbd, this.panel);
        dbd.setVisible(true);
        if (dbd.getConnectToDB()) {
            dbs = dbd.getDBStrings();
            try {
                this.panel.frame().output(Globals.lang("Establishing SQL connection..."));
                DBExporter exporter = new DBExporterAndImporterFactory().getExporter(dbs.getServerType());
                Connection conn = exporter.connectToDB(dbs);
                conn.close();
                dbs.isConfigValid(true);
                this.panel.frame().output(Globals.lang("SQL connection established."));
            }
            catch (Exception ex) {
                String errorMessage = SQLUtil.getExceptionMessage(ex);
                dbs.isConfigValid(false);
                String preamble = "Could not connect to SQL database for the following reason:";
                this.panel.frame().output(Globals.lang(preamble) + "  " + errorMessage);
                JOptionPane.showMessageDialog(this.panel.frame(), Globals.lang(preamble) + "\n" + errorMessage, Globals.lang("Connect to SQL database"), 0);
            }
            finally {
                this.panel.metaData().setDBStrings(dbs);
                dbd.dispose();
            }
        }
    }

    class DbImpAction
    extends AbstractAction {
        DbImpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DbConnectAction.this.action();
        }
    }
}

