/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import net.sf.jabref.sql.exporter.DBExporter;
import net.sf.jabref.sql.exporter.MySQLExporter;
import net.sf.jabref.sql.exporter.PostgreSQLExporter;
import net.sf.jabref.sql.importer.DBImporter;
import net.sf.jabref.sql.importer.MySQLImporter;
import net.sf.jabref.sql.importer.PostgreSQLImporter;

public class DBExporterAndImporterFactory {
    public DBExporter getExporter(DBType type) {
        DBExporter exporter = null;
        switch (type) {
            case MYSQL: {
                exporter = MySQLExporter.getInstance();
                break;
            }
            case POSTGRESQL: {
                exporter = PostgreSQLExporter.getInstance();
            }
        }
        return exporter;
    }

    public DBExporter getExporter(String type) {
        return this.getExporter(DBType.valueOf(type.toUpperCase()));
    }

    public DBImporter getImporter(DBType type) {
        DBImporter importer = null;
        switch (type) {
            case MYSQL: {
                importer = MySQLImporter.getInstance();
                break;
            }
            case POSTGRESQL: {
                importer = PostgreSQLImporter.getInstance();
            }
        }
        return importer;
    }

    public DBImporter getImporter(String type) {
        return this.getImporter(DBType.valueOf(type.toUpperCase()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBType {
        MYSQL("MYSQL"),
        POSTGRESQL("POSTGRESQL");

        private String dbType;

        private DBType(String dbType) {
            this.dbType = dbType;
        }

        public String getDBType() {
            return this.dbType;
        }
    }
}

