/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SixpackImporter
extends ImportFormat {
    final String SEPARATOR = new String(new char[]{'\u0000', '0'});

    @Override
    public String getFormatName() {
        return "Sixpack";
    }

    @Override
    public String getCLIId() {
        return "sixpack";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        for (int i = 0; (str = in.readLine()) != null && i < 50; ++i) {
            if (str.indexOf(this.SEPARATOR) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        HashMap<String, String> fI = new HashMap<String, String>();
        fI.put("id", "bibtexkey");
        fI.put("au", "author");
        fI.put("ti", "title");
        fI.put("jo", "journal");
        fI.put("vo", "volume");
        fI.put("nu", "number");
        fI.put("pa", "pages");
        fI.put("mo", "month");
        fI.put("yr", "year");
        fI.put("kw", "keywords");
        fI.put("ab", "abstract");
        fI.put("no", "note");
        fI.put("ed", "editor");
        fI.put("pu", "publisher");
        fI.put("se", "series");
        fI.put("ad", "address");
        fI.put("en", "edition");
        fI.put("ch", "chapter");
        fI.put("hp", "howpublished");
        fI.put("tb", "booktitle");
        fI.put("or", "organization");
        fI.put("sc", "school");
        fI.put("in", "institution");
        fI.put("ty", "type");
        fI.put("url", "url");
        fI.put("cr", "crossref");
        fI.put("fi", "file");
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        in.readLine();
        String ln = in.readLine();
        if (ln == null) {
            return null;
        }
        String[] fieldDef = ln.split(",");
        String s = null;
        BibtexEntry entry = null;
        while ((s = in.readLine()) != null) {
            try {
                String[] fields = (s = s.replaceAll("<par>", "")).split(this.SEPARATOR);
                if (fields.length < 2) continue;
                BibtexEntryType typ = BibtexEntryType.getType(fields[1].toLowerCase());
                if (typ == null) {
                    String type = "";
                    if (fields[1].equals("Masterthesis")) {
                        type = "mastersthesis";
                    }
                    if (fields[1].equals("PhD-Thesis")) {
                        type = "phdthesis";
                    }
                    if (fields[1].equals("miscellaneous")) {
                        type = "misc";
                    }
                    if (fields[1].equals("Conference")) {
                        type = "proceedings";
                    }
                    typ = BibtexEntryType.getType(type.toLowerCase());
                }
                entry = new BibtexEntry(Util.createNeutralId(), typ);
                for (int i = 0; i < Math.min(fieldDef.length, fields.length); ++i) {
                    String fld = (String)fI.get(fieldDef[i]);
                    if (fld == null) continue;
                    if (fld.equals("author") || fld.equals("editor")) {
                        ImportFormatReader.setIfNecessary(entry, fld, fields[i].replaceAll(" and ", ", ").replaceAll(", ", " and "));
                        continue;
                    }
                    if (fld.equals("pages")) {
                        ImportFormatReader.setIfNecessary(entry, fld, fields[i].replaceAll("-", "--"));
                        continue;
                    }
                    if (fld.equals("file")) {
                        String fieldName = "pdf";
                        if (fields[i].endsWith("ps") || fields[i].endsWith("ps.gz")) {
                            fieldName = "ps";
                        } else if (fields[i].endsWith("html")) {
                            fieldName = "url";
                        }
                        ImportFormatReader.setIfNecessary(entry, fieldName, fields[i]);
                        continue;
                    }
                    ImportFormatReader.setIfNecessary(entry, fld, fields[i]);
                }
                bibitems.add(entry);
            }
            catch (NullPointerException ex) {
                Globals.logger("Problem parsing Sixpack entry, ignoring entry.");
            }
        }
        return bibitems;
    }
}

