/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RisImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "RIS";
    }

    @Override
    public String getCLIId() {
        return "ris";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        Pattern pat1 = Pattern.compile("AU  - .*");
        Pattern pat2 = Pattern.compile("A1  - .*");
        Pattern pat3 = Pattern.compile("A2  - .*");
        while ((str = in.readLine()) != null) {
            if (!pat1.matcher(str).find() && !pat2.matcher(str).find() && !pat3.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        String str;
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        while ((str = in.readLine()) != null) {
            sb.append(str);
            sb.append("\n");
        }
        String[] entries = sb.toString().replaceAll("\u2013", "-").replaceAll("\u2014", "--").replaceAll("\u2015", "--").split("ER  -.*\\n");
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].trim().length() == 0) continue;
            String type = "";
            String author = "";
            String editor = "";
            String startPage = "";
            String endPage = "";
            String comment = "";
            HashMap<String, String> hm = new HashMap<String, String>();
            String[] fields = entries[i].split("\n");
            for (int j = 0; j < fields.length; ++j) {
                String doi;
                StringBuffer current = new StringBuffer(fields[j]);
                boolean done = false;
                while (!done && j < fields.length - 1) {
                    if (fields[j + 1].length() >= 6 && !fields[j + 1].substring(2, 6).equals("  - ")) {
                        if (current.length() > 0 && !Character.isWhitespace(current.charAt(current.length() - 1)) && !Character.isWhitespace(fields[j + 1].charAt(0))) {
                            current.append(' ');
                        }
                        current.append(fields[j + 1]);
                        ++j;
                        continue;
                    }
                    done = true;
                }
                String entry = current.toString();
                if (entry.length() < 6) continue;
                String lab = entry.substring(0, 2);
                String val = entry.substring(6).trim();
                if (lab.equals("TY")) {
                    type = val.equals("BOOK") ? "book" : (val.equals("JOUR") || val.equals("MGZN") ? "article" : (val.equals("THES") ? "phdthesis" : (val.equals("UNPB") ? "unpublished" : (val.equals("RPRT") ? "techreport" : (val.equals("CONF") ? "inproceedings" : (val.equals("CHAP") ? "incollection" : "other"))))));
                } else if (lab.equals("T1") || lab.equals("TI")) {
                    String oldVal = hm.get("title");
                    if (oldVal == null) {
                        hm.put("title", val);
                    } else if (oldVal.endsWith(":") || oldVal.endsWith(".") || oldVal.endsWith("?")) {
                        hm.put("title", oldVal + " " + val);
                    } else {
                        hm.put("title", oldVal + ": " + val);
                    }
                } else if (lab.equals("T2") || lab.equals("T3") || lab.equals("BT")) {
                    hm.put("booktitle", val);
                } else if (lab.equals("AU") || lab.equals("A1")) {
                    author = author.equals("") ? val : author + " and " + val;
                } else if (lab.equals("A2")) {
                    editor = editor.equals("") ? val : editor + " and " + val;
                } else if (lab.equals("JA") || lab.equals("JF") || lab.equals("JO")) {
                    if (type.equals("inproceedings")) {
                        hm.put("booktitle", val);
                    } else {
                        hm.put("journal", val);
                    }
                } else if (lab.equals("SP")) {
                    startPage = val;
                } else if (lab.equals("PB")) {
                    if (type.equals("phdthesis")) {
                        hm.put("school", val);
                    } else {
                        hm.put("publisher", val);
                    }
                } else if (lab.equals("AD") || lab.equals("CY")) {
                    hm.put("address", val);
                } else if (lab.equals("EP")) {
                    endPage = val;
                } else if (lab.equals("SN")) {
                    hm.put("issn", val);
                } else if (lab.equals("VL")) {
                    hm.put("volume", val);
                } else if (lab.equals("IS")) {
                    hm.put("number", val);
                } else if (lab.equals("N2") || lab.equals("AB")) {
                    String oldAb = hm.get("abstract");
                    if (oldAb == null) {
                        hm.put("abstract", val);
                    } else {
                        hm.put("abstract", oldAb + "\n" + val);
                    }
                } else if (lab.equals("UR")) {
                    hm.put("url", val);
                } else if ((lab.equals("Y1") || lab.equals("PY")) && val.length() >= 4) {
                    String[] parts = val.split("/");
                    hm.put("year", parts[0]);
                    if (parts.length > 1 && parts[1].length() > 0) {
                        try {
                            int month = Integer.parseInt(parts[1]);
                            if (month > 0 && month <= 12) {
                                hm.put("month", "#" + Globals.MONTHS[month - 1] + "#");
                            }
                        }
                        catch (NumberFormatException ex) {}
                    }
                } else if (lab.equals("KW")) {
                    if (!hm.containsKey("keywords")) {
                        hm.put("keywords", val);
                    } else {
                        String kw = hm.get("keywords");
                        hm.put("keywords", kw + ", " + val);
                    }
                } else if (lab.equals("U1") || lab.equals("U2") || lab.equals("N1")) {
                    if (comment.length() > 0) {
                        comment = comment + "\n";
                    }
                    comment = comment + val;
                } else if (lab.equals("ID")) {
                    hm.put("refid", val);
                } else if (lab.equals("M3") && (doi = val).startsWith("doi:")) {
                    doi = doi.replaceAll("(?i)doi:", "").trim();
                    hm.put("doi", doi);
                }
                if (author.length() > 0) {
                    author = AuthorList.fixAuthor_lastNameFirst(author);
                    hm.put("author", author);
                }
                if (editor.length() > 0) {
                    editor = AuthorList.fixAuthor_lastNameFirst(editor);
                    hm.put("editor", editor);
                }
                if (comment.length() > 0) {
                    hm.put("comment", comment);
                }
                hm.put("pages", startPage + "--" + endPage);
            }
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(type));
            ArrayList toRemove = new ArrayList();
            for (Object key : hm.keySet()) {
                String content = (String)hm.get(key);
                if (content != null && content.trim().length() != 0) continue;
                toRemove.add(key);
            }
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                hm.remove(iterator.next());
            }
            b.setField(hm);
            bibitems.add(b);
        }
        return bibitems;
    }
}

