/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepecNepImporter
extends ImportFormat {
    private static Logger logger = Logger.getLogger(RepecNepImporter.class.getName());
    private static final Collection<String> recognizedFields = Arrays.asList("Keywords", "JEL", "Date", "URL", "By");
    private int line = 0;
    private String lastLine = "";
    private String preLine = "";
    private BufferedReader in = null;
    private boolean inOverviewSection = false;

    @Override
    public String getFormatName() {
        return "REPEC New Economic Papers (NEP)";
    }

    @Override
    public String getCLIId() {
        return "repecnep";
    }

    @Override
    public String getExtensions() {
        return ".txt";
    }

    @Override
    public String getDescription() {
        return "Imports a New Economics Papers-Message (see http://nep.repec.org)\nfrom the REPEC-NEP Service (see http://www.repec.org).\nTo import papers either save a NEP message as a text file and then import or\ncopy&paste the papers you want to import and make sure, one of the first lines\ncontains the line \"nep.repec.org\".";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        String startOfMessage = "";
        String line = in.readLine();
        for (int i = 0; i < 25 && line != null; ++i) {
            startOfMessage = startOfMessage + line;
            line = in.readLine();
        }
        return startOfMessage.indexOf("NEP: New Economics Papers") >= 0 || startOfMessage.indexOf("nep.repec.org") >= 0;
    }

    private boolean startsWithKeyword(Collection<String> keywords) {
        boolean result;
        boolean bl = result = this.lastLine.indexOf(58) > 0;
        if (result) {
            String possibleKeyword = this.lastLine.substring(0, this.lastLine.indexOf(58));
            result = keywords.contains(possibleKeyword);
        }
        return result;
    }

    private void readLine() throws IOException {
        ++this.line;
        this.preLine = this.lastLine;
        this.lastLine = this.in.readLine();
    }

    private String readMultipleLines() throws IOException {
        String result = this.lastLine.trim();
        this.readLine();
        while (!(this.lastLine == null || this.lastLine.trim().equals("") || this.startsWithKeyword(recognizedFields) || this.isStartOfWorkingPaper())) {
            result = result + (this.lastLine.length() == 0 ? this.lastLine.trim() : " " + this.lastLine.trim());
            this.readLine();
        }
        return result;
    }

    private void parseTitleString(BibtexEntry be) throws IOException {
        this.lastLine = this.lastLine.substring(this.lastLine.indexOf(46) + 1, this.lastLine.length());
        be.setField("title", this.readMultipleLines());
    }

    private void parseAuthors(BibtexEntry be) throws IOException {
        String authors = "";
        String institutions = "";
        while (this.lastLine != null && !this.lastLine.equals("") && !this.startsWithKeyword(recognizedFields)) {
            String author = null;
            String institution = null;
            boolean institutionDone = false;
            if (this.lastLine.indexOf(40) >= 0) {
                author = this.lastLine.substring(0, this.lastLine.indexOf(40)).trim();
                institutionDone = this.lastLine.indexOf(41) > 0;
                institution = this.lastLine.substring(this.lastLine.indexOf(40) + 1, institutionDone && this.lastLine.indexOf(41) > this.lastLine.indexOf(40) + 1 ? this.lastLine.indexOf(41) : this.lastLine.length()).trim();
            } else {
                author = this.lastLine.substring(0, this.lastLine.length()).trim();
                institutionDone = true;
            }
            this.readLine();
            while (!institutionDone && this.lastLine != null) {
                institutionDone = this.lastLine.indexOf(41) > 0;
                institution = institution + this.lastLine.substring(0, institutionDone ? this.lastLine.indexOf(41) : this.lastLine.length()).trim();
                this.readLine();
            }
            if (author != null) {
                authors = authors + (!authors.equals("") ? " and " + author : "" + author);
            }
            if (institution == null) continue;
            institutions = institutions + (!institutions.equals("") ? " and " + institution : "" + institution);
        }
        if (!authors.equals("")) {
            be.setField("author", authors);
        }
        if (!institutions.equals("")) {
            be.setField("institution", institutions);
        }
    }

    private void parseAbstract(BibtexEntry be) throws IOException {
        String theabstract = this.readMultipleLines();
        if (!theabstract.equals("")) {
            be.setField("abstract", theabstract);
        }
    }

    private void parseAdditionalFields(BibtexEntry be, boolean multilineUrlFieldAllowed) throws IOException {
        if (this.lastLine != null && this.lastLine.trim().equals("")) {
            this.readLine();
        }
        while (this.lastLine != null && !this.isStartOfWorkingPaper() && (this.startsWithKeyword(recognizedFields) || this.lastLine.equals(""))) {
            int i;
            String content;
            String keyword = this.lastLine.equals("") ? "" : this.lastLine.substring(0, this.lastLine.indexOf(58)).trim();
            String string = this.lastLine = this.lastLine.equals("") ? "" : this.lastLine.substring(this.lastLine.indexOf(58) + 1, this.lastLine.length()).trim();
            if (keyword.equals("Keywords")) {
                content = this.readMultipleLines();
                String[] keywords = content.split("[,;]");
                String keywordStr = "";
                for (i = 0; i < keywords.length; ++i) {
                    keywordStr = keywordStr + " '" + keywords[i].trim() + "'";
                }
                be.setField("keywords", keywordStr.trim());
                continue;
            }
            if (keyword.equals("JEL")) {
                be.setField("jel", this.readMultipleLines());
                continue;
            }
            if (keyword.startsWith("Date")) {
                Date date = null;
                String content2 = this.readMultipleLines();
                String[] recognizedDateFormats = new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"};
                for (i = 0; i < recognizedDateFormats.length && date == null; ++i) {
                    try {
                        date = new SimpleDateFormat(recognizedDateFormats[i]).parse(content2);
                        continue;
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(date != null ? date : new Date());
                be.setField("year", "" + cal.get(1));
                if (date == null || recognizedDateFormats[i - 1].indexOf("MM") < 0) continue;
                be.setField("month", "" + cal.get(2));
                continue;
            }
            if (keyword.startsWith("URL")) {
                content = null;
                if (multilineUrlFieldAllowed) {
                    content = this.readMultipleLines();
                } else {
                    content = this.lastLine;
                    this.readLine();
                }
                be.setField("url", content);
                continue;
            }
            if (keyword.startsWith("By")) {
                this.parseAuthors(be);
                continue;
            }
            this.readLine();
        }
    }

    private boolean isStartOfWorkingPaper() {
        return this.lastLine.matches("\\d+\\.\\s.*") && !this.inOverviewSection && this.preLine.trim().equals("");
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        String paperNoStr = null;
        this.line = 0;
        try {
            this.in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
            this.readLine();
            while (this.lastLine != null) {
                if (this.lastLine.startsWith("-----------------------------")) {
                    this.inOverviewSection = this.preLine.startsWith("In this issue we have");
                }
                if (this.isStartOfWorkingPaper()) {
                    BibtexEntry be = new BibtexEntry(Util.createNeutralId());
                    be.setType(BibtexEntryType.getType("techreport"));
                    paperNoStr = this.lastLine.substring(0, this.lastLine.indexOf(46));
                    this.parseTitleString(be);
                    if (this.startsWithKeyword(recognizedFields)) {
                        this.parseAdditionalFields(be, false);
                    } else {
                        this.readLine();
                        this.parseAuthors(be);
                        this.readLine();
                    }
                    if (!this.startsWithKeyword(recognizedFields)) {
                        this.parseAbstract(be);
                    }
                    this.parseAdditionalFields(be, true);
                    bibitems.add(be);
                    paperNoStr = null;
                    continue;
                }
                this.preLine = this.lastLine;
                this.readLine();
            }
        }
        catch (Exception e2) {
            IOException e2;
            String message = "Error in REPEC-NEP import on line " + this.line;
            if (paperNoStr != null) {
                message = message + ", paper no. " + paperNoStr + ": ";
            }
            message = message + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            if (!(e2 instanceof IOException)) {
                e2.printStackTrace();
                e2 = new IOException(message);
            }
            throw (IOException)e2;
        }
        return bibitems;
    }
}

