/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEEEXploreFetcher
implements EntryFetcher {
    ImportInspector dialog = null;
    OutputPrinter status;
    final HTMLConverter htmlConverter = new HTMLConverter();
    private JCheckBox absCheckBox = new JCheckBox(Globals.lang("Include abstracts"), false);
    private JRadioButton htmlButton = new JRadioButton(Globals.lang("HTML parser"));
    private JRadioButton bibButton = new JRadioButton(Globals.lang("BibTeX importer"));
    private static final int MAX_FETCH = 100;
    private int perPage = 100;
    private int hits = 0;
    private int unparseable = 0;
    private int parsed = 0;
    private int piv = 0;
    private boolean shouldContinue = false;
    private boolean includeAbstract = false;
    private boolean importBibtex = false;
    private String terms;
    private final String startUrl = "http://ieeexplore.ieee.org/search/freesearchresult.jsp?queryText=";
    private final String endUrl = "&rowsPerPage=" + Integer.toString(this.perPage) + "&pageNumber=";
    private String searchUrl;
    private final String importUrl = "http://ieeexplore.ieee.org/xpls/downloadCitations";
    private final Pattern hitsPattern = Pattern.compile("([0-9,]+) Results");
    private final Pattern idPattern = Pattern.compile("<input name='' title='.*' type='checkbox'value=''\\s*id='([0-9]+)'/>");
    private final Pattern typePattern = Pattern.compile("<span class=\"type\">\\s*(.+)");
    private HashMap<String, String> fieldPatterns = new HashMap();
    private final Pattern absPattern = Pattern.compile("<p>\\s*(.+)");
    Pattern stdEntryPattern = Pattern.compile(".*<strong>(.+)</strong><br>\\s+(.+)");
    Pattern publicationPattern = Pattern.compile("(.*), \\d*\\.*\\s?(.*)");
    Pattern proceedingPattern = Pattern.compile("(.*?)\\.?\\s?Proceedings\\s?(.*)");
    Pattern abstractLinkPattern = Pattern.compile("<a href='(.+)'>\\s*<span class=\"more\">View full.*</span> </a>");
    String abrvPattern = ".*[^,] '?\\d+\\)?";
    Pattern ieeeArticleNumberPattern = Pattern.compile("<a href=\".*arnumber=(\\d+).*\">");

    public IEEEXploreFetcher() {
        this.fieldPatterns.put("title", "<a\\s*href=[^<]+>\\s*(.+)\\s*</a>");
        this.fieldPatterns.put("author", "</h3>\\s+(.+)<br />");
        this.fieldPatterns.put("volume", "Volume:\\s*(\\d+)");
        this.fieldPatterns.put("number", "Issue:\\s*(\\d+)");
        this.fieldPatterns.put("year", "Publication Year:\\s*(\\d{4})");
        this.fieldPatterns.put("pages", "Page\\(s\\):\\s*(\\d+)\\s*-\\s*(\\d*)");
        this.fieldPatterns.put("doi", "Digital Object Identifier:\\s*<a href=.*>(.+)</a>");
    }

    @Override
    public JPanel getOptionsPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        this.htmlButton.setSelected(true);
        this.htmlButton.setEnabled(false);
        this.bibButton.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.htmlButton);
        group.add(this.bibButton);
        pan.add((Component)this.absCheckBox, "North");
        pan.add((Component)this.htmlButton, "Center");
        pan.add((Component)this.bibButton, "East");
        return pan;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        this.dialog = dialog;
        this.status = status;
        this.terms = query;
        this.piv = 0;
        this.shouldContinue = true;
        this.parsed = 0;
        this.unparseable = 0;
        int pageNumber = 1;
        this.searchUrl = this.makeUrl(pageNumber);
        try {
            URL url = new URL(this.searchUrl);
            String page = this.getResults(url);
            if (page.indexOf("You have entered an invalid search") >= 0) {
                status.showMessage(Globals.lang("You have entered an invalid search '%0'.", this.terms), Globals.lang("Search IEEEXplore"), 1);
                return false;
            }
            if (page.indexOf("Bad request") >= 0) {
                status.showMessage(Globals.lang("Bad Request '%0'.", this.terms), Globals.lang("Search IEEEXplore"), 1);
                return false;
            }
            if (page.indexOf("No results were found.") >= 0) {
                status.showMessage(Globals.lang("No entries found for the search string '%0'", this.terms), Globals.lang("Search IEEEXplore"), 1);
                return false;
            }
            this.hits = this.getNumberOfHits(page, "display-status", this.hitsPattern);
            this.includeAbstract = this.absCheckBox.isSelected();
            this.importBibtex = this.bibButton.isSelected();
            if (this.hits > 100) {
                status.showMessage(Globals.lang("%0 entries found. To reduce server load, only %1 will be downloaded.", new String[]{String.valueOf(this.hits), String.valueOf(100)}), Globals.lang("Search IEEEXplore"), 1);
                this.hits = 100;
            }
            this.parse(dialog, page, 0, 1);
            for (int firstEntry = this.perPage; this.shouldContinue && firstEntry < this.hits; firstEntry += this.perPage) {
                this.searchUrl = this.makeUrl(++pageNumber);
                page = this.getResults(new URL(this.searchUrl));
                if (!this.shouldContinue) break;
                this.parse(dialog, page, 0, firstEntry + 1);
            }
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            status.showMessage(Globals.lang("Connection to IEEEXplore failed"), Globals.lang("Search IEEEXplore"), 0);
        }
        catch (IOException e) {
            status.showMessage(Globals.lang(e.getMessage()), Globals.lang("Search IEEEXplore"), 0);
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String getTitle() {
        return "IEEEXplore";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return "IEEEXploreHelp.html";
    }

    @Override
    public String getKeyName() {
        return "IEEEXplore";
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    private String makeUrl(int startIndex) {
        StringBuffer sb = new StringBuffer("http://ieeexplore.ieee.org/search/freesearchresult.jsp?queryText=");
        sb.append(this.terms.replaceAll(" ", "+"));
        sb.append(this.endUrl);
        sb.append(String.valueOf(startIndex));
        return sb.toString();
    }

    private void parse(ImportInspector dialog, String text, int startIndex, int firstEntryNumber) {
        this.piv = startIndex;
        int entryNumber = firstEntryNumber;
        if (this.importBibtex) {
            String id;
            ArrayList<String> idSelected = new ArrayList<String>();
            while ((id = this.parseNextEntryId(text, this.piv)) != null && this.shouldContinue) {
                idSelected.add(id);
                ++entryNumber;
            }
            try {
                BibtexDatabase dbase = this.parseBibtexDatabase(idSelected, this.includeAbstract);
                Collection<BibtexEntry> items = dbase.getEntries();
                for (BibtexEntry entry : items) {
                    dialog.addEntry(this.cleanup(entry));
                    dialog.setProgress(this.parsed + this.unparseable, this.hits);
                    ++this.parsed;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            BibtexEntry entry;
            while ((entry = this.parseNextEntry(text, this.piv)) != null && this.shouldContinue) {
                if (entry.getField("title") != null) {
                    dialog.addEntry(entry);
                    dialog.setProgress(this.parsed + this.unparseable, this.hits);
                    ++this.parsed;
                }
                ++entryNumber;
            }
        }
    }

    private BibtexDatabase parseBibtexDatabase(List<String> id, boolean abs) throws IOException {
        int bytesRead;
        URLConnection conn;
        if (id.isEmpty()) {
            return null;
        }
        try {
            URL url = new URL("http://ieeexplore.ieee.org/xpls/downloadCitations");
            conn = url.openConnection();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Referer", this.searchUrl);
        PrintWriter out = new PrintWriter(conn.getOutputStream());
        String recordIds = "";
        Iterator<String> iter = id.iterator();
        while (iter.hasNext()) {
            recordIds = recordIds + iter.next() + " ";
        }
        recordIds = recordIds.trim();
        String citation = abs ? "citation-abstract" : "citation-only";
        String content = "recordIds=" + recordIds.replaceAll(" ", "%20") + "&fromPageName=&citations-format=" + citation + "&download-format=download-bibtex";
        System.out.println(content);
        out.write(content);
        out.flush();
        out.close();
        BufferedReader bufr = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[256];
        while ((bytesRead = bufr.read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append(buffer[i]);
            }
        }
        System.out.println(sb.toString());
        ParserResult results = new BibtexParser(bufr).parse();
        bufr.close();
        return results.getDatabase();
    }

    private BibtexEntry cleanup(BibtexEntry entry) {
        String[] pageNumbers;
        String field;
        String pages;
        String month;
        if (entry == null) {
            return null;
        }
        String author = entry.getField("author");
        if (author != null) {
            author = author.replaceAll("\\.", ". ");
            author = author.replaceAll("  ", " ");
            author = author.replaceAll("\\. -", ".-");
            author = author.replaceAll("; ", " and ");
            author = author.replaceAll("[,;]$", "");
            entry.setField("author", author);
        }
        if ((month = entry.getField("month")) != null && month.length() > 0) {
            month = month.replaceAll("\\.", "");
            month = month.toLowerCase();
            Pattern monthPattern = Pattern.compile("(\\d*+)\\s*([a-z]*+)-*(\\d*+)\\s*([a-z]*+)");
            Matcher mm = monthPattern.matcher(month);
            String date = month;
            if (mm.find()) {
                if (mm.group(3).length() == 0) {
                    if (mm.group(2).length() > 0) {
                        date = "#" + mm.group(2).substring(0, 3) + "#";
                        if (mm.group(1).length() > 0) {
                            date = date + " " + mm.group(1) + ",";
                        }
                    } else {
                        date = mm.group(1) + ",";
                    }
                } else {
                    date = mm.group(2).length() == 0 ? (mm.group(4).length() > 0 ? "#" + mm.group(4).substring(0, 3) + "# " + mm.group(1) + "--" + mm.group(3) + "," : date + ",") : "#" + mm.group(2).substring(0, 3) + "# " + mm.group(1) + "--#" + mm.group(4).substring(0, 3) + "# " + mm.group(3) + ",";
                }
            }
            entry.setField("month", date);
        }
        if ((pages = entry.getField(field = "pages")) != null && (pageNumbers = pages.split("-")).length == 2) {
            if (pageNumbers[0].equals(pageNumbers[1])) {
                entry.setField(field, pageNumbers[0]);
            } else {
                entry.setField(field, pages.replaceAll("-", "--"));
            }
        }
        BibtexEntryType type = entry.getType();
        String sourceField = "";
        if (type.getName() == "Article") {
            sourceField = "journal";
            entry.clearField("booktitle");
        } else if (type.getName() == "Inproceedings") {
            sourceField = "booktitle";
        }
        String fullName = entry.getField(sourceField);
        if (fullName != null) {
            if (type.getName() == "Article") {
                int ind = fullName.indexOf(": Accepted for future publication");
                if (ind > 0) {
                    fullName = fullName.substring(0, ind);
                    entry.setField("year", "to be published");
                    entry.clearField("month");
                    entry.clearField("pages");
                    entry.clearField("number");
                }
                String[] parts = fullName.split("[\\[\\]]");
                fullName = parts[0];
                if (parts.length == 3) {
                    fullName = fullName + parts[2];
                }
                if (entry.getField("note") == "Early Access") {
                    entry.setField("year", "to be published");
                    entry.clearField("month");
                    entry.clearField("pages");
                    entry.clearField("number");
                }
            } else {
                fullName = fullName.replace("Conference Proceedings", "Proceedings").replace("Proceedings of", "Proceedings").replace("Proceedings.", "Proceedings");
                fullName = fullName.replaceAll("International", "Int.");
                fullName = fullName.replaceAll("Symposium", "Symp.");
                fullName = fullName.replaceAll("Conference", "Conf.");
                fullName = fullName.replaceAll(" on", " ").replace("  ", " ");
            }
            Matcher m1 = this.publicationPattern.matcher(fullName);
            if (m1.find()) {
                String prefix = m1.group(2).trim();
                String postfix = m1.group(1).trim();
                String abrv = "";
                String[] parts = prefix.split("\\. ", 2);
                if (parts.length == 2) {
                    if (parts[0].matches(this.abrvPattern)) {
                        prefix = parts[1];
                        abrv = parts[0];
                    } else {
                        prefix = parts[0];
                        abrv = parts[1];
                    }
                }
                if (!prefix.matches(this.abrvPattern)) {
                    fullName = prefix + " " + postfix + " " + abrv;
                    fullName = fullName.trim();
                } else {
                    fullName = postfix + " " + prefix;
                }
            }
            if (type.getName() == "Article") {
                String id;
                fullName = fullName.replace(" - ", "-");
                fullName = fullName.trim();
                if (Globals.prefs.getBoolean("useIEEEAbrv") && (id = Globals.journalAbbrev.getAbbreviatedName(fullName, false)) != null) {
                    fullName = id;
                }
            }
            if (type.getName() == "Inproceedings") {
                Matcher m2 = this.proceedingPattern.matcher(fullName);
                if (m2.find()) {
                    String prefix = m2.group(2);
                    String postfix = m2.group(1).replaceAll("\\.$", "");
                    if (!prefix.matches(this.abrvPattern)) {
                        String abrv = "";
                        String[] parts = postfix.split("\\. ", 2);
                        if (parts.length == 2) {
                            if (parts[0].matches(this.abrvPattern)) {
                                postfix = parts[1];
                                abrv = parts[0];
                            } else {
                                postfix = parts[0];
                                abrv = parts[1];
                            }
                        }
                        fullName = prefix.trim() + " " + postfix.trim() + " " + abrv;
                    } else {
                        fullName = postfix.trim() + " " + prefix.trim();
                    }
                }
                fullName = fullName.trim();
                fullName = fullName.replaceAll("^[tT]he ", "").replaceAll("^\\d{4} ", "").replaceAll("[,.]$", "");
                String year = entry.getField("year");
                if (!((fullName = fullName.replaceAll(", " + year + "\\.?", "")).contains("Abstract") || fullName.contains("Summaries") || fullName.contains("Conference Record"))) {
                    fullName = "Proc. " + fullName;
                }
            }
            entry.setField(sourceField, fullName);
        }
        return entry;
    }

    private String parseNextEntryId(String allText, int startIndex) {
        int index = allText.indexOf("<div class=\"select", startIndex);
        int endIndex = allText.indexOf("</div>", index);
        if (index >= 0 && endIndex > 0) {
            String text = allText.substring(index, endIndex);
            this.piv = endIndex += 6;
            Matcher idMatcher = this.idPattern.matcher(text);
            if (idMatcher.find()) {
                return idMatcher.group(1);
            }
        }
        return null;
    }

    private BibtexEntry parseNextEntry(String allText, int startIndex) {
        BibtexEntry entry = null;
        int index = allText.indexOf("<div class=\"detail", this.piv);
        int endIndex = allText.indexOf("</div>", index);
        if (index >= 0 && endIndex > 0) {
            this.piv = endIndex += 6;
            String text = allText.substring(index, endIndex);
            BibtexEntryType type = null;
            String sourceField = null;
            String typeName = "";
            Matcher typeMatcher = this.typePattern.matcher(text);
            if (typeMatcher.find()) {
                typeName = typeMatcher.group(1);
                if (typeName.equalsIgnoreCase("IEEE Journals &amp; Magazines") || typeName.equalsIgnoreCase("IEEE Early Access Articles") || typeName.equalsIgnoreCase("IET Journals &amp; Magazines") || typeName.equalsIgnoreCase("AIP Journals &amp; Magazines") || typeName.equalsIgnoreCase("AVS Journals &amp; Magazines") || typeName.equalsIgnoreCase("IBM Journals &amp; Magazines")) {
                    type = BibtexEntryType.getType("article");
                    sourceField = "journal";
                } else if (typeName.equalsIgnoreCase("IEEE Conference Publications") || typeName.equalsIgnoreCase("IET Conference Publications")) {
                    type = BibtexEntryType.getType("inproceedings");
                    sourceField = "booktitle";
                } else if (typeName.equalsIgnoreCase("IEEE Standards")) {
                    type = BibtexEntryType.getType("standard");
                    sourceField = "number";
                } else if (typeName.equalsIgnoreCase("IEEE eLearning Library Courses")) {
                    type = BibtexEntryType.getType("Electronic");
                    sourceField = "note";
                } else if (typeName.equalsIgnoreCase("Wiley-IEEE Press eBook Chapters")) {
                    type = BibtexEntryType.getType("inCollection");
                    sourceField = "booktitle";
                }
            }
            if (type == null) {
                type = BibtexEntryType.getType("misc");
                sourceField = "note";
                System.err.println("Type detection failed. Use MISC instead.");
                ++this.unparseable;
                System.err.println(text);
            }
            entry = new BibtexEntry(Util.createNeutralId(), type);
            if (typeName.equalsIgnoreCase("IEEE Standards")) {
                entry.setField("organization", "IEEE");
            }
            if (typeName.equalsIgnoreCase("Wiley-IEEE Press eBook Chapters")) {
                entry.setField("publisher", "Wiley-IEEE Press");
            }
            if (typeName.equalsIgnoreCase("IEEE Early Access Articles")) {
                entry.setField("note", "Early Access");
            }
            Set<String> fields = this.fieldPatterns.keySet();
            for (String field : fields) {
                Matcher fieldMatcher = Pattern.compile(this.fieldPatterns.get(field)).matcher(text);
                if (!fieldMatcher.find()) continue;
                entry.setField(field, this.htmlConverter.format(fieldMatcher.group(1)));
                if (field.equals("title") && fieldMatcher.find()) {
                    String sec_title = this.htmlConverter.format(fieldMatcher.group(1));
                    if (entry.getType() == BibtexEntryType.getStandardType("standard")) {
                        sec_title = sec_title.replaceAll("IEEE Std ", "");
                    }
                    entry.setField(sourceField, sec_title);
                }
                if (!field.equals("pages") || fieldMatcher.groupCount() != 2) continue;
                entry.setField(field, fieldMatcher.group(1) + "-" + fieldMatcher.group(2));
            }
            if (entry.getType() == BibtexEntryType.getStandardType("inproceedings") && entry.getField("author").equals("")) {
                entry.setType(BibtexEntryType.getStandardType("proceedings"));
            }
            if (this.includeAbstract && (index = allText.indexOf("<div class=\"abstract", this.piv)) >= 0) {
                this.piv = endIndex = allText.indexOf("</div>", index) + 6;
                text = allText.substring(index, endIndex);
                Matcher absMatcher = this.absPattern.matcher(text);
                if (absMatcher.find()) {
                    entry.setField("abstract", absMatcher.group(1));
                }
            }
        }
        if (entry == null) {
            return null;
        }
        return this.cleanup(entry);
    }

    private int getNumberOfHits(String page, String marker, Pattern pattern) throws IOException {
        int ind = page.indexOf(marker);
        if (ind < 0) {
            System.out.println(page);
            throw new IOException(Globals.lang("Could not parse number of hits"));
        }
        String substring = page.substring(ind, page.length());
        Matcher m = pattern.matcher(substring);
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        throw new IOException(Globals.lang("Could not parse number of hits"));
    }

    public String getResults(URL source) throws IOException {
        int bytesRead;
        InputStream in = source.openStream();
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = in.read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }

    public String getResultsFromFile(File f) throws IOException {
        int bytesRead;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }
}

