/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibsonomyScraper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleScholarFetcher
implements EntryFetcher {
    protected static int MAX_PAGES_TO_LOAD = 8;
    static final String QUERY_MARKER = "___QUERY___";
    static final String URL_START = "http://scholar.google.com";
    static final String SEARCH_URL = "http://scholar.google.com/scholar?q=___QUERY___&amp;hl=en&amp;btnG=Search";
    static final Pattern CITE_LINK_PATTERN = Pattern.compile("<div class=gs_r><h3 class=\"gs_rt\"><a href=\"([^\"]*)\">");
    static final Pattern NEXT_PAGE_PATTERN = Pattern.compile("<a href=\"([^\"]*)\"><span class=\"SPRITE_nav_next\"> </span><br><span style=\".*\">Next</span></a>");
    protected boolean stopFetching = false;

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        this.stopFetching = false;
        try {
            List<String> citations = this.getCitations(query);
            int entriesAdded = 0;
            inspector.setProgress(2, citations.size() + 2);
            int i = 0;
            for (String citation : citations) {
                if (this.stopFetching) break;
                BibtexEntry entry = BibsonomyScraper.getEntry(citation);
                inspector.setProgress(++i + 2, citations.size() + 2);
                if (entry == null) continue;
                inspector.addEntry(entry);
                ++entriesAdded;
            }
            if (entriesAdded < citations.size()) {
                JOptionPane.showMessageDialog(null, Globals.lang("%0 entries were found, but only %1 of these could be resolved.", String.valueOf(citations.size()), String.valueOf(entriesAdded)), Globals.lang("Incomplete search results"), 2);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "Google Scholar";
    }

    @Override
    public String getKeyName() {
        return "Google Scholar";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return "CiteSeerHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
    }

    protected List<String> getCitations(String query) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String urlQuery = SEARCH_URL.replace(QUERY_MARKER, URLEncoder.encode(query, "UTF-8"));
            String nextPage = null;
            for (int count = 1; (nextPage = this.getCitationsFromUrl(urlQuery, ids)) != null && count < MAX_PAGES_TO_LOAD; ++count) {
                urlQuery = nextPage;
                if (!this.stopFetching) continue;
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCitationsFromUrl(String urlQuery, List<String> ids) throws IOException {
        URL url = new URL(urlQuery);
        URLDownload ud = new URLDownload(url);
        ud.download();
        String cont = ud.getStringContent();
        Matcher m = CITE_LINK_PATTERN.matcher(cont);
        while (m.find()) {
            ids.add(m.group(1));
        }
        m = NEXT_PAGE_PATTERN.matcher(cont);
        if (m.find()) {
            System.out.println("NEXT: http://scholar.google.com" + m.group(1).replaceAll("&amp;", "&"));
            return URL_START + m.group(1).replaceAll("&amp;", "&");
        }
        return null;
    }
}

