/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.EntryFetcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralFetcher
extends SidePaneComponent
implements ActionListener {
    JTextField tf = new JTextField();
    JPanel pan = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JButton go = new JButton(Globals.lang("Fetch"));
    JButton helpBut = new JButton(GUIGlobals.getImage("helpSmall"));
    JButton reset = new JButton(Globals.lang("Reset"));
    JComboBox fetcherChoice;
    CardLayout optionsCards = new CardLayout();
    JPanel optionsPanel = new JPanel(this.optionsCards);
    JPanel optPanel = new JPanel(new BorderLayout());
    HelpAction help;
    SidePaneManager sidePaneManager;
    Action action;
    JabRefFrame frame;
    EntryFetcher activeFetcher;
    EntryFetcher[] fetcherArray;

    public GeneralFetcher(SidePaneManager p0, JabRefFrame frame, List<EntryFetcher> fetchers) {
        super(p0, GUIGlobals.getIconUrl("www"), Globals.lang("Web search"));
        this.sidePaneManager = p0;
        this.frame = frame;
        this.fetcherArray = fetchers.toArray(new EntryFetcher[fetchers.size()]);
        String[] choices = new String[fetchers.size()];
        for (int i = 0; i < fetchers.size(); ++i) {
            choices[i] = fetchers.get(i).getTitle();
        }
        this.fetcherChoice = new JComboBox<String>(choices);
        int defaultFetcher = Globals.prefs.getInt("selectedFetcherIndex");
        if (defaultFetcher >= this.fetcherArray.length) {
            defaultFetcher = 0;
        }
        this.activeFetcher = this.fetcherArray[defaultFetcher];
        this.fetcherChoice.setSelectedIndex(defaultFetcher);
        if (this.activeFetcher.getOptionsPanel() != null) {
            this.optPanel.add((Component)this.activeFetcher.getOptionsPanel(), "Center");
        }
        this.helpBut.setEnabled(this.activeFetcher.getHelpPage() != null);
        this.fetcherChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralFetcher.this.activeFetcher = GeneralFetcher.this.fetcherArray[GeneralFetcher.this.fetcherChoice.getSelectedIndex()];
                Globals.prefs.putInt("selectedFetcherIndex", GeneralFetcher.this.fetcherChoice.getSelectedIndex());
                if (GeneralFetcher.this.activeFetcher.getHelpPage() != null) {
                    GeneralFetcher.this.help.setHelpFile(GeneralFetcher.this.activeFetcher.getHelpPage());
                    GeneralFetcher.this.helpBut.setEnabled(true);
                } else {
                    GeneralFetcher.this.helpBut.setEnabled(false);
                }
                GeneralFetcher.this.optionsCards.show(GeneralFetcher.this.optionsPanel, String.valueOf(GeneralFetcher.this.fetcherChoice.getSelectedIndex()));
                GeneralFetcher.this.optPanel.removeAll();
                if (GeneralFetcher.this.activeFetcher.getOptionsPanel() != null) {
                    GeneralFetcher.this.optPanel.add((Component)GeneralFetcher.this.activeFetcher.getOptionsPanel(), "Center");
                }
                GeneralFetcher.this.revalidate();
            }
        });
        this.action = new FetcherAction();
        this.help = new HelpAction(Globals.helpDiag, this.activeFetcher.getHelpPage(), "Help");
        this.helpBut.addActionListener(this.help);
        this.helpBut.setMargin(new Insets(0, 0, 0, 0));
        this.tf.setPreferredSize(new Dimension(1, this.tf.getPreferredSize().height));
        this.tf.setName("tf");
        this.reset.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                GeneralFetcher.this.tf.setText("");
                new FocusRequester(GeneralFetcher.this.tf);
            }
        });
        JPanel main = new JPanel();
        main.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.weighty = 1.0;
        this.con.insets = new Insets(1, 0, 1, 0);
        this.con.fill = 1;
        this.gbl.setConstraints(this.fetcherChoice, this.con);
        main.add(this.fetcherChoice);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(this.tf, this.con);
        main.add(this.tf);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.go, this.con);
        main.add(this.go);
        this.reset.setName("reset");
        this.gbl.setConstraints(this.reset, this.con);
        main.add(this.reset);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.helpBut, this.con);
        main.add(this.helpBut);
        if (this.pan != null) {
            this.gbl.setConstraints(this.optPanel, this.con);
            main.add(this.optPanel);
        }
        main.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)main, "Center");
        this.go.addActionListener(this);
        this.tf.addActionListener(this);
    }

    public void setHelpResourceOwner(Class c) {
        this.help.setResourceOwner(c);
    }

    public JTextField getTextField() {
        return this.tf;
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.tf.getText().trim().length() == 0) {
            return;
        }
        final ImportInspectionDialog dialog = new ImportInspectionDialog(this.frame, this.frame.basePanel(), BibtexFields.DEFAULT_INSPECTION_FIELDS, this.activeFetcher.getTitle(), false);
        dialog.addCallBack(this.activeFetcher);
        Util.placeDialog(dialog, this.frame);
        dialog.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                if (GeneralFetcher.this.activeFetcher.processQuery(GeneralFetcher.this.tf.getText().trim(), dialog, GeneralFetcher.this.frame)) {
                    dialog.entryListComplete();
                } else {
                    dialog.dispose();
                }
            }
        }).start();
    }

    @Override
    public void componentClosing() {
        super.componentClosing();
        Globals.prefs.putBoolean("webSearchVisible", Boolean.FALSE);
    }

    @Override
    public void componentOpening() {
        super.componentOpening();
        Globals.prefs.putBoolean("webSearchVisible", Boolean.TRUE);
    }

    class FetcherAction
    extends AbstractAction {
        public FetcherAction() {
            super(Globals.lang("Web search"), GUIGlobals.getImage("www"));
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Fetch Medline"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!GeneralFetcher.this.sidePaneManager.hasComponent(GeneralFetcher.this.getTitle())) {
                GeneralFetcher.this.sidePaneManager.register(GeneralFetcher.this.getTitle(), GeneralFetcher.this);
            }
            if (GeneralFetcher.this.frame.getTabbedPane().getTabCount() > 0) {
                GeneralFetcher.this.sidePaneManager.toggle(GeneralFetcher.this.getTitle());
                if (GeneralFetcher.this.sidePaneManager.isComponentVisible(GeneralFetcher.this.getTitle())) {
                    new FocusRequester(GeneralFetcher.this.getTextField());
                }
            }
        }
    }
}

