/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.DBLPParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBLPHelper {
    private final DBLPQueryCleaner cleaner = new DBLPQueryCleaner();

    public String cleanDBLPQuery(String query) {
        return this.cleaner.cleanQuery(query);
    }

    public List<BibtexEntry> getBibTexFromPage(String page) throws DBLPParseException {
        ArrayList<BibtexEntry> bibtexList = new ArrayList<BibtexEntry>();
        String startPattern = "<pre>";
        String endPattern = "</pre>";
        String tmpStr = page;
        int startIdx = tmpStr.indexOf("<pre>");
        int endIdx = tmpStr.indexOf("</pre>");
        String entry1 = tmpStr.substring(startIdx + "<pre>".length(), endIdx);
        entry1 = this.cleanEntry(entry1);
        bibtexList.add(BibtexParser.singleFromString(entry1));
        tmpStr = tmpStr.substring(endIdx + "</pre>".length(), tmpStr.length());
        startIdx = tmpStr.indexOf("<pre>");
        if (startIdx != -1) {
            endIdx = tmpStr.indexOf("</pre>");
            String entry2 = tmpStr.substring(startIdx + "<pre>".length(), endIdx);
            entry2 = this.cleanEntry(entry2);
            bibtexList.add(BibtexParser.singleFromString(entry2));
        }
        return bibtexList;
    }

    private String cleanEntry(String bibEntry) {
        String retStr = bibEntry.replaceFirst("<a href=\".*\">DBLP</a>", "DBLP");
        return retStr;
    }

    class DBLPQueryCleaner {
        DBLPQueryCleaner() {
        }

        public String cleanQuery(String query) {
            String cleaned = query;
            cleaned = cleaned.replaceAll("-", " ");
            cleaned = cleaned.replaceAll(" ", "%20");
            cleaned = cleaned.replaceAll(":", "");
            cleaned = cleaned.toLowerCase();
            return cleaned;
        }
    }
}

