/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.util.NameListNormalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiteSeerXFetcher
implements EntryFetcher {
    protected static int MAX_PAGES_TO_LOAD = 8;
    static final String QUERY_MARKER = "___QUERY___";
    static final String URL_START = "http://citeseer.ist.psu.edu";
    static final String SEARCH_URL = "http://citeseer.ist.psu.edu/search?q=___QUERY___&submit=Search&sort=rlv&t=doc";
    static final Pattern CITE_LINK_PATTERN = Pattern.compile("<a class=\"remove doc_details\" href=\"(.*)\">");
    protected boolean stopFetching = false;
    static final String basePattern = "<meta name=\"___QUERY___\" content=\"(.*)\" />";
    static final Pattern titlePattern = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_title"));
    static final Pattern authorPattern = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_authors"));
    static final Pattern yearPattern = Pattern.compile("<meta name=\"___QUERY___\" content=\"(.*)\" />".replace("___QUERY___", "citation_year"));
    static final Pattern abstractPattern = Pattern.compile("<h3>Abstract</h3>\\s*<p>(.*)</p>");

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        this.stopFetching = false;
        try {
            List<String> citations = this.getCitations(query);
            for (String citation : citations) {
                if (this.stopFetching) break;
                BibtexEntry entry = this.getSingleCitation(citation);
                if (entry == null) continue;
                inspector.addEntry(entry);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "CiteSeerX";
    }

    @Override
    public String getKeyName() {
        return "CiteSeerX";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return "CiteSeerHelp.html";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
    }

    protected List<String> getCitations(String query) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String urlQuery = SEARCH_URL.replace(QUERY_MARKER, URLEncoder.encode(query, "UTF-8"));
            String nextPage = null;
            for (int count = 1; (nextPage = this.getCitationsFromUrl(urlQuery, ids)) != null && count < MAX_PAGES_TO_LOAD; ++count) {
                urlQuery = nextPage;
                if (!this.stopFetching) continue;
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCitationsFromUrl(String urlQuery, List<String> ids) throws IOException {
        URL url = new URL(urlQuery);
        URLDownload ud = new URLDownload(url);
        ud.download();
        String cont = ud.getStringContent();
        Matcher m = CITE_LINK_PATTERN.matcher(cont);
        while (m.find()) {
            ids.add(URL_START + m.group(1));
        }
        return null;
    }

    protected BibtexEntry getSingleCitation(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLDownload ud = new URLDownload(url);
        ud.setEncoding("UTF8");
        ud.download();
        String cont = ud.getStringContent();
        Matcher m = titlePattern.matcher(cont);
        if (m.find()) {
            BibtexEntry entry = new BibtexEntry(Util.createNeutralId());
            entry.setField("title", m.group(1));
            m = authorPattern.matcher(cont);
            if (m.find()) {
                String authors = m.group(1);
                entry.setField("author", NameListNormalizer.normalizeAuthorList(authors));
            }
            if ((m = yearPattern.matcher(cont)).find()) {
                entry.setField("year", m.group(1));
            }
            if ((m = abstractPattern.matcher(cont)).find()) {
                entry.setField("abstract", m.group(1));
            }
            return entry;
        }
        return null;
    }
}

