/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexString;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.UnknownEntryType;
import net.sf.jabref.Util;
import net.sf.jabref.imports.FieldContentParser;
import net.sf.jabref.imports.ParserResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BibtexParser {
    private PushbackReader _in;
    private BibtexDatabase _db;
    private HashMap<String, String> _meta;
    private HashMap<String, BibtexEntryType> entryTypes;
    private boolean _eof = false;
    private int line = 1;
    private FieldContentParser fieldContentParser = new FieldContentParser();
    private ParserResult _pr;
    private static final Integer LOOKAHEAD = 64;

    public BibtexParser(Reader in) {
        if (in == null) {
            throw new NullPointerException();
        }
        if (Globals.prefs == null) {
            Globals.prefs = JabRefPreferences.getInstance();
        }
        this._in = new PushbackReader(in, LOOKAHEAD);
    }

    public static ParserResult parse(Reader in) throws IOException {
        BibtexParser parser = new BibtexParser(in);
        return parser.parse();
    }

    public static Collection<BibtexEntry> fromString(String bibtexString) {
        StringReader reader = new StringReader(bibtexString);
        BibtexParser parser = new BibtexParser(reader);
        try {
            return parser.parse().getDatabase().getEntries();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BibtexEntry singleFromString(String bibtexString) {
        Collection<BibtexEntry> c = BibtexParser.fromString(bibtexString);
        if (c == null) {
            return null;
        }
        return c.iterator().next();
    }

    public static boolean isRecognizedFormat(Reader inOrig) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(inOrig);
        Pattern pat1 = Pattern.compile("@[a-zA-Z]*\\s*\\{");
        while ((str = in.readLine()) != null) {
            if (pat1.matcher(str).find()) {
                return true;
            }
            if (!str.startsWith("This file was created with JabRef")) continue;
            return true;
        }
        return false;
    }

    private void skipWhitespace() throws IOException {
        int c;
        do {
            if ((c = this.read()) != -1 && c != 65535) continue;
            this._eof = true;
            return;
        } while (Character.isWhitespace((char)c));
        this.unread(c);
    }

    private String skipAndRecordWhitespace(int j) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        if (j != 32) {
            sb.append((char)j);
        }
        while (true) {
            if ((c = this.read()) == -1 || c == 65535) {
                this._eof = true;
                return sb.toString();
            }
            if (!Character.isWhitespace((char)c)) break;
            if (c == 32) continue;
            sb.append((char)c);
        }
        this.unread(c);
        return sb.toString();
    }

    public ParserResult parse() throws IOException {
        if (this._pr != null) {
            return this._pr;
        }
        this._db = new BibtexDatabase();
        this._meta = new HashMap();
        this.entryTypes = new HashMap();
        this._pr = new ParserResult(this._db, this._meta, this.entryTypes);
        String versionNum = this.readJabRefVersionNumber();
        if (versionNum != null) {
            this._pr.setJabrefVersion(versionNum);
            this.setMajorMinorVersions();
        }
        this.skipWhitespace();
        try {
            boolean found;
            while (!this._eof && (found = this.consumeUncritically('@'))) {
                boolean isEntry;
                this.skipWhitespace();
                String entryType = this.parseTextToken();
                BibtexEntryType tp = BibtexEntryType.getType(entryType);
                boolean bl = isEntry = tp != null;
                if (!isEntry) {
                    if (entryType.toLowerCase().equals("preamble")) {
                        this._db.setPreamble(this.parsePreamble());
                    } else if (entryType.toLowerCase().equals("string")) {
                        BibtexString bs = this.parseString();
                        try {
                            this._db.addString(bs);
                        }
                        catch (KeyCollisionException ex) {
                            this._pr.addWarning(Globals.lang("Duplicate string name") + ": " + bs.getName());
                        }
                    } else if (entryType.toLowerCase().equals("comment")) {
                        String rest;
                        int pos;
                        StringBuffer commentBuf = this.parseBracketedTextExactly();
                        String comment = commentBuf.toString().replaceAll("[\\x0d\\x0a]", "");
                        if ((comment.substring(0, Math.min(comment.length(), GUIGlobals.META_FLAG.length())).equals(GUIGlobals.META_FLAG) || comment.substring(0, Math.min(comment.length(), GUIGlobals.META_FLAG_OLD.length())).equals(GUIGlobals.META_FLAG_OLD)) && (pos = (rest = comment.substring(0, GUIGlobals.META_FLAG.length()).equals(GUIGlobals.META_FLAG) ? comment.substring(GUIGlobals.META_FLAG.length()) : comment.substring(GUIGlobals.META_FLAG_OLD.length())).indexOf(58)) > 0) {
                            this._meta.put(rest.substring(0, pos), rest.substring(pos + 1));
                        }
                        if (comment.substring(0, Math.min(comment.length(), GUIGlobals.ENTRYTYPE_FLAG.length())).equals(GUIGlobals.ENTRYTYPE_FLAG)) {
                            CustomEntryType typ = CustomEntryType.parseEntryType(comment);
                            this.entryTypes.put(typ.getName().toLowerCase(), typ);
                        }
                    } else {
                        tp = new UnknownEntryType(entryType.toLowerCase());
                        isEntry = true;
                    }
                }
                if (isEntry) {
                    try {
                        BibtexEntry be = this.parseEntry(tp);
                        boolean duplicateKey = this._db.insertEntry(be);
                        if (duplicateKey) {
                            this._pr.addDuplicateKey(be.getCiteKey());
                        } else if (be.getCiteKey() == null || be.getCiteKey().equals("")) {
                            this._pr.addWarning(Globals.lang("empty BibTeX key") + ": " + be.getAuthorTitleYear(40) + " (" + Globals.lang("grouping may not work for this entry") + ")");
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        this._pr.addWarning(Globals.lang("Error occured when parsing entry") + ": '" + ex.getMessage() + "'. " + Globals.lang("Skipped entry."));
                    }
                }
                this.skipWhitespace();
            }
            this.checkEntryTypes(this._pr);
            return this._pr;
        }
        catch (KeyCollisionException kce) {
            throw new IOException("Duplicate ID in bibtex file: " + kce.toString());
        }
    }

    private int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }

    private int read() throws IOException {
        int c = this._in.read();
        if (c == 10) {
            ++this.line;
        }
        return c;
    }

    private void unread(int c) throws IOException {
        if (c == 10) {
            --this.line;
        }
        this._in.unread(c);
    }

    public BibtexString parseString() throws IOException {
        this.skipWhitespace();
        this.consume('{', '(');
        this.skipWhitespace();
        String name = this.parseTextToken();
        this.skipWhitespace();
        this.consume('=');
        String content = this.parseFieldContent(name);
        this.consume('}', ')');
        String id = Util.createNeutralId();
        return new BibtexString(id, name, content);
    }

    public String parsePreamble() throws IOException {
        return this.parseBracketedText().toString();
    }

    public BibtexEntry parseEntry(BibtexEntryType tp) throws IOException {
        String id = Util.createNeutralId();
        BibtexEntry result = new BibtexEntry(id, tp);
        this.skipWhitespace();
        this.consume('{', '(');
        int c = this.peek();
        if (c != 10 && c != 13) {
            this.skipWhitespace();
        }
        String key = null;
        boolean doAgain = true;
        while (doAgain) {
            doAgain = false;
            try {
                if (key != null) {
                    key = key + this.parseKey();
                    continue;
                }
                key = this.parseKey();
            }
            catch (NoLabelException ex) {
                c = (char)this.peek();
                if (Character.isWhitespace(c) || c == 123 || c == 34) {
                    String fieldName = ex.getMessage().trim().toLowerCase();
                    String cont = this.parseFieldContent(fieldName);
                    result.setField(fieldName, cont);
                    continue;
                }
                key = key != null ? key + ex.getMessage() + "=" : ex.getMessage() + "=";
                doAgain = true;
            }
        }
        if (key != null && key.equals("")) {
            key = null;
        }
        result.setField("bibtexkey", key);
        this.skipWhitespace();
        while ((c = this.peek()) != 125 && c != 41) {
            if (c == 44) {
                this.consume(',');
            }
            this.skipWhitespace();
            c = this.peek();
            if (c == 125 || c == 41) break;
            this.parseField(result);
        }
        this.consume('}', ')');
        return result;
    }

    private void parseField(BibtexEntry entry) throws IOException {
        String key = this.parseTextToken().toLowerCase();
        this.skipWhitespace();
        this.consume('=');
        String content = this.parseFieldContent(key);
        if (Globals.prefs.putBracesAroundCapitals(key)) {
            content = Util.removeBracesAroundCapitals(content);
        }
        if (content.length() > 0) {
            if (entry.getField(key) == null) {
                entry.setField(key, content);
            } else if (key.equals("author") || key.equals("editor")) {
                entry.setField(key, entry.getField(key) + " and " + content);
            }
        }
    }

    private String parseFieldContent(String key) throws IOException {
        this.skipWhitespace();
        StringBuffer value = new StringBuffer();
        int c = 46;
        while ((c = this.peek()) != 44 && c != 125 && c != 41) {
            StringBuffer text;
            if (this._eof) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (c == 34) {
                text = this.parseQuotedFieldExactly();
                value.append(this.fieldContentParser.format(text));
            } else if (c == 123) {
                text = this.parseBracketedTextExactly();
                value.append(this.fieldContentParser.format(text, key));
            } else if (Character.isDigit((char)c)) {
                String numString = this.parseTextToken();
                value.append(numString);
            } else if (c == 35) {
                this.consume('#');
            } else {
                String textToken = this.parseTextToken();
                if (textToken.length() == 0) {
                    throw new IOException("Error in line " + this.line + " or above: " + "Empty text token.\nThis could be caused " + "by a missing comma between two fields.");
                }
                value.append("#").append(textToken).append("#");
            }
            this.skipWhitespace();
        }
        if (Globals.prefs.getBoolean("autoDoubleBraces")) {
            while (value.length() > 1 && value.charAt(0) == '{' && value.charAt(value.length() - 1) == '}') {
                value.deleteCharAt(value.length() - 1);
                value.deleteCharAt(0);
            }
            while (this.hasNegativeBraceCount(value.toString())) {
                value.insert(0, '{');
                value.append('}');
            }
        }
        return value.toString();
    }

    private boolean hasNegativeBraceCount(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '{') {
                ++count;
            } else if (s.charAt(i) == '}') {
                --count;
            }
            if (count >= 0) continue;
            return true;
        }
        return false;
    }

    private String parseTextToken() throws IOException {
        int c;
        StringBuffer token = new StringBuffer(20);
        while (true) {
            if ((c = this.read()) == -1) {
                this._eof = true;
                return token.toString();
            }
            if (!Character.isLetterOrDigit((char)c) && c != 58 && c != 45 && c != 95 && c != 42 && c != 43 && c != 46 && c != 47 && c != 39) break;
            token.append((char)c);
        }
        this.unread(c);
        return token.toString();
    }

    private String fixKey() throws IOException {
        char currentChar;
        StringBuilder key = new StringBuilder();
        int lookahead_used = 0;
        do {
            currentChar = (char)this.read();
            key.append(currentChar);
        } while (currentChar != ',' && currentChar != '\n' && currentChar != '=' && ++lookahead_used < LOOKAHEAD);
        this.unread(currentChar);
        key.deleteCharAt(key.length() - 1);
        switch (currentChar) {
            case '=': {
                key = key.reverse();
                boolean matchedAlpha = false;
                for (int i = 0; i < key.length(); ++i) {
                    currentChar = key.charAt(i);
                    if (!matchedAlpha && currentChar == ' ') continue;
                    matchedAlpha = true;
                    this.unread(currentChar);
                    if (currentChar != ' ' && currentChar != '\n') continue;
                    StringBuilder newKey = new StringBuilder();
                    for (int j = i; j < key.length(); ++j) {
                        currentChar = key.charAt(j);
                        if (Character.isWhitespace(currentChar)) continue;
                        newKey.append(currentChar);
                    }
                    this._pr.addWarning(Globals.lang("Line %0: Found corrupted BibTeX-key.", String.valueOf(this.line)));
                    key = newKey.reverse();
                }
                break;
            }
            case ',': {
                this._pr.addWarning(Globals.lang("Line %0: Found corrupted BibTeX-key (contains whitespaces).", String.valueOf(this.line)));
            }
            case '\n': {
                this._pr.addWarning(Globals.lang("Line %0: Found corrupted BibTeX-key (comma missing).", String.valueOf(this.line)));
                break;
            }
            default: {
                this.unreadBuffer(key);
                return "";
            }
        }
        return this.removeWhitespaces(key).toString();
    }

    private StringBuilder removeWhitespaces(StringBuilder sb) {
        StringBuilder newSb = new StringBuilder();
        for (int i = 0; i < sb.length(); ++i) {
            char current = sb.charAt(i);
            if (Character.isWhitespace(current)) continue;
            newSb.append(current);
        }
        return newSb;
    }

    private void unreadBuffer(StringBuilder sb) throws IOException {
        for (int i = sb.length() - 1; i >= 0; --i) {
            this.unread(sb.charAt(i));
        }
    }

    private String parseKey() throws IOException, NoLabelException {
        int c;
        StringBuffer token = new StringBuffer(20);
        while (true) {
            if ((c = this.read()) == -1) {
                this._eof = true;
                return token.toString();
            }
            if (Character.isWhitespace((char)c) || !Character.isLetterOrDigit((char)c) && (c == 35 || c == 123 || c == 125 || c == 65533 || c == 126 || c == 65533 || c == 44 || c == 61)) break;
            token.append((char)c);
        }
        if (Character.isWhitespace((char)c)) {
            return token.toString() + this.fixKey();
        }
        if (c == 44) {
            this.unread(c);
            return token.toString();
        }
        if (c == 61) {
            return token.toString();
        }
        throw new IOException("Error in line " + this.line + ":" + "Character '" + (char)c + "' is not " + "allowed in bibtex keys.");
    }

    private StringBuffer parseBracketedText() throws IOException {
        StringBuffer value = new StringBuffer();
        this.consume('{');
        int brackets = 0;
        while (this.peek() != 125 || brackets != 0) {
            int j = this.read();
            if (j == -1 || j == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (j == 123) {
                ++brackets;
            } else if (j == 125) {
                --brackets;
            }
            if (Character.isWhitespace((char)j)) {
                String whs = this.skipAndRecordWhitespace(j);
                if (!whs.equals("") && !whs.equals("\n\t")) {
                    whs = whs.replaceAll("\t", "");
                    value.append(whs);
                    continue;
                }
                value.append(' ');
                continue;
            }
            value.append((char)j);
        }
        this.consume('}');
        return value;
    }

    private StringBuffer parseBracketedTextExactly() throws IOException {
        StringBuffer value = new StringBuffer();
        this.consume('{');
        int brackets = 0;
        while (this.peek() != 125 || brackets != 0) {
            int j = this.read();
            if (j == -1 || j == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (j == 123) {
                ++brackets;
            } else if (j == 125) {
                --brackets;
            }
            value.append((char)j);
        }
        this.consume('}');
        return value;
    }

    private StringBuffer parseQuotedFieldExactly() throws IOException {
        StringBuffer value = new StringBuffer();
        this.consume('\"');
        int brackets = 0;
        while (this.peek() != 34 || brackets != 0) {
            int j = this.read();
            if (j == -1 || j == 65535) {
                throw new RuntimeException("Error in line " + this.line + ": EOF in mid-string");
            }
            if (j == 123) {
                ++brackets;
            } else if (j == 125) {
                --brackets;
            }
            value.append((char)j);
        }
        this.consume('\"');
        return value;
    }

    private void consume(char expected) throws IOException {
        int c = this.read();
        if (c != expected) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + expected + " but received " + (char)c);
        }
    }

    private boolean consumeUncritically(char expected) throws IOException {
        int c;
        while ((c = this.read()) != expected && c != -1 && c != 65535) {
        }
        if (c == -1 || c == 65535) {
            this._eof = true;
        }
        return c == expected;
    }

    private void consume(char expected1, char expected2) throws IOException {
        int c = this.read();
        if (c != expected1 && c != expected2) {
            throw new RuntimeException("Error in line " + this.line + ": Expected " + expected1 + " or " + expected2 + " but received " + c);
        }
    }

    public void checkEntryTypes(ParserResult _pr) {
        for (BibtexEntry be : this._db.getEntries()) {
            if (!(be.getType() instanceof UnknownEntryType)) continue;
            BibtexEntryType o = this.entryTypes.get(be.getType().getName().toLowerCase());
            if (o != null) {
                BibtexEntryType type = o;
                be.setType(type);
                continue;
            }
            _pr.addWarning(Globals.lang("unknown entry type") + ": " + be.getType().getName() + ". " + Globals.lang("Type set to 'other'") + ".");
            be.setType(BibtexEntryType.OTHER);
        }
    }

    private String readJabRefVersionNumber() throws IOException {
        StringBuffer headerText = new StringBuffer();
        boolean keepon = true;
        int piv = 0;
        while (keepon) {
            int c = this.peek();
            headerText.append((char)c);
            if (piv == 0 && (Character.isWhitespace((char)c) || c == 37)) {
                this.read();
            } else if (c == "This file was created with JabRef".charAt(piv)) {
                ++piv;
                this.read();
            } else {
                keepon = false;
                return null;
            }
            if (piv != "This file was created with JabRef".length()) continue;
            keepon = false;
            StringBuilder sb = new StringBuilder();
            while ((c = this.read()) != 10 && c != -1) {
                sb.append((char)c);
            }
            String versionNum = sb.toString().trim();
            if (Pattern.compile("[1-9]+\\.[1-9A-Za-z ]+\\.").matcher(versionNum).matches()) {
                return versionNum.substring(0, versionNum.length() - 1);
            }
            if (!Pattern.compile("[1-9]+\\.[1-9]\\.[1-9A-Za-z ]+\\.").matcher(versionNum).matches()) continue;
            return versionNum.substring(0, versionNum.length() - 1);
        }
        return null;
    }

    private void setMajorMinorVersions() {
        String v = this._pr.getJabrefVersion();
        Pattern p = Pattern.compile("([0-9]+)\\.([0-9]+).*");
        Pattern p2 = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+).*");
        Matcher m = p.matcher(v);
        Matcher m2 = p2.matcher(v);
        if (m.matches() && m.groupCount() >= 2) {
            this._pr.setJabrefMajorVersion(Integer.parseInt(m.group(1)));
            this._pr.setJabrefMinorVersion(Integer.parseInt(m.group(2)));
        }
        if (m2.matches() && m2.groupCount() >= 3) {
            this._pr.setJabrefMinor2Version(Integer.parseInt(m2.group(3)));
        }
    }

    private class NoLabelException
    extends Exception {
        public NoLabelException(String hasRead) {
            super(hasRead);
        }
    }
}

