/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRuleSet;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileListTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainTableFormat
implements TableFormat<BibtexEntry> {
    public static final String COL_DEFINITION_FIELD_SEPARATOR = "/";
    public static final String[] PDF = new String[]{"pdf", "ps"};
    public static final String[] URL_ = new String[]{"url", "doi"};
    public static final String[] CITESEER = new String[]{"citeseerurl"};
    public static final String[] ARXIV = new String[]{"eprint"};
    public static final String[] FILE = new String[]{"file"};
    BasePanel panel;
    private String[][] columns;
    public int padleft = -1;
    private HashMap<Integer, String[]> iconCols = new HashMap();
    int[][] nameCols = null;
    boolean namesAsIs;
    boolean abbr_names;
    boolean namesNatbib;
    boolean namesFf;
    boolean namesLf;
    boolean namesLastOnly;
    boolean showShort;

    public MainTableFormat(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public int getColumnCount() {
        return this.padleft + this.columns.length;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return GUIGlobals.NUMBER_COL;
        }
        if (this.getIconTypeForColumn(col) != null) {
            return "";
        }
        String[] fld = this.columns[col - this.padleft];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fld.length; ++i) {
            String disName;
            if (i > 0) {
                sb.append('/');
            }
            if ((disName = BibtexFields.getFieldDisplayName(fld[i])) != null) {
                sb.append(disName);
                continue;
            }
            sb.append(Util.nCase(fld[i]));
        }
        return sb.toString();
    }

    public String[] getIconTypeForColumn(int col) {
        String[] o = this.iconCols.get(new Integer(col));
        if (o != null) {
            return o;
        }
        return null;
    }

    public int getColumnIndex(String colName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i][0].equalsIgnoreCase(colName)) continue;
            return i + this.padleft;
        }
        return -1;
    }

    @Override
    public Object getColumnValue(BibtexEntry be, int col) {
        Object o = null;
        String[] iconType = this.getIconTypeForColumn(col);
        if (col == 0) {
            o = "#";
        } else if (iconType != null) {
            int hasField = -1;
            for (int i = iconType.length - 1; i >= 0; --i) {
                if (!this.hasField(be, iconType[i])) continue;
                hasField = i;
            }
            if (hasField < 0) {
                return null;
            }
            o = iconType[hasField].equals("file") ? FileListTableModel.getFirstLabel(be.getField("file")) : GUIGlobals.getTableIcon(iconType[hasField]);
        } else {
            int i;
            String[] fld = this.columns[col - this.padleft];
            int j = 0;
            for (i = 0; i < fld.length; ++i) {
                o = fld[i].equals(GUIGlobals.TYPE_HEADER) ? be.getType().getName() : be.getField(fld[i]);
                if (o == null) continue;
                j = i;
                break;
            }
            for (i = 0; i < this.nameCols.length; ++i) {
                if (col - this.padleft != this.nameCols[i][0] || this.nameCols[i][1] != j) continue;
                return this.formatName(o);
            }
        }
        return o;
    }

    public Object formatName(Object o) {
        if (o == null) {
            return null;
        }
        if (this.namesAsIs) {
            return o;
        }
        if (this.namesNatbib) {
            o = AuthorList.fixAuthor_Natbib((String)o);
        } else if (this.namesLastOnly) {
            o = AuthorList.fixAuthor_lastNameOnlyCommas((String)o, false);
        } else if (this.namesFf) {
            o = AuthorList.fixAuthor_firstNameFirstCommas((String)o, this.abbr_names, false);
        } else if (this.namesLf) {
            o = AuthorList.fixAuthor_lastNameFirstCommas((String)o, this.abbr_names, false);
        }
        return o;
    }

    public boolean hasField(BibtexEntry be, String field) {
        return be != null && be.getField(field) != null;
    }

    public void updateTableFormat() {
        int i;
        String[] colSettings = Globals.prefs.getStringArray("columnNames");
        this.columns = new String[colSettings.length][];
        for (int i2 = 0; i2 < colSettings.length; ++i2) {
            String[] fields = colSettings[i2].split(COL_DEFINITION_FIELD_SEPARATOR);
            this.columns[i2] = new String[fields.length];
            for (int j = 0; j < fields.length; ++j) {
                this.columns[i2][j] = fields[j];
            }
        }
        this.showShort = Globals.prefs.getBoolean("showShort");
        this.namesNatbib = Globals.prefs.getBoolean("namesNatbib");
        this.namesLastOnly = Globals.prefs.getBoolean("namesLastOnly");
        this.namesAsIs = Globals.prefs.getBoolean("namesAsIs");
        this.abbr_names = Globals.prefs.getBoolean("abbrAuthorNames");
        this.namesFf = Globals.prefs.getBoolean("namesFf");
        this.namesLf = !this.namesAsIs && !this.namesFf && !this.namesNatbib && !this.namesLastOnly;
        this.iconCols.clear();
        int coln = 1;
        if (Globals.prefs.getBoolean("fileColumn")) {
            this.iconCols.put(coln++, FILE);
        }
        if (Globals.prefs.getBoolean("pdfColumn")) {
            this.iconCols.put(coln++, PDF);
        }
        if (Globals.prefs.getBoolean("urlColumn")) {
            this.iconCols.put(coln++, URL_);
        }
        if (Globals.prefs.getBoolean("arxivColumn")) {
            this.iconCols.put(coln++, ARXIV);
        }
        this.padleft = 1 + this.iconCols.size();
        Vector<int[]> tmp = new Vector<int[]>(2, 1);
        for (i = 0; i < this.columns.length; ++i) {
            for (int j = 0; j < this.columns[i].length; ++j) {
                if (!this.columns[i][j].equals("author") && !this.columns[i][j].equals("editor")) continue;
                tmp.add(new int[]{i, j});
            }
        }
        this.nameCols = new int[tmp.size()][];
        for (i = 0; i < this.nameCols.length; ++i) {
            this.nameCols[i] = (int[])tmp.elementAt(i);
        }
    }

    public boolean isIconColumn(int col) {
        return this.getIconTypeForColumn(col) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SearchMatcher
    implements Matcher<BibtexEntry> {
        private SearchRuleSet ruleSet;
        private Hashtable<String, String> searchOptions;

        public SearchMatcher(SearchRuleSet ruleSet, Hashtable<String, String> searchOptions) {
            this.ruleSet = ruleSet;
            this.searchOptions = searchOptions;
        }

        @Override
        public boolean matches(BibtexEntry entry) {
            int result = this.ruleSet.applyRule(this.searchOptions, entry);
            return result > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NoSearchMatcher
    implements Matcher<BibtexEntry> {
        NoSearchMatcher() {
        }

        @Override
        public boolean matches(BibtexEntry object) {
            return true;
        }
    }
}

