/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.groups.EntryTableTransferHandler;
import net.sf.jabref.gui.FirstColumnComparator;
import net.sf.jabref.gui.IconComparator;
import net.sf.jabref.gui.IsMarkedComparator;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.gui.PersistenceTableColumnListener;
import net.sf.jabref.gui.PreventDraggingJTableHeader;
import net.sf.jabref.search.HitOrMissComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainTable
extends JTable {
    private MainTableFormat tableFormat;
    private BasePanel panel;
    private SortedList<BibtexEntry> sortedForMarking;
    private SortedList<BibtexEntry> sortedForTable;
    private SortedList<BibtexEntry> sortedForSearch;
    private SortedList<BibtexEntry> sortedForGrouping;
    private boolean tableColorCodes;
    private boolean showingFloatSearch = false;
    private boolean showingFloatGrouping = false;
    private EventSelectionModel<BibtexEntry> selectionModel;
    private TableComparatorChooser<BibtexEntry> comparatorChooser;
    private JScrollPane pane;
    private Comparator<BibtexEntry> searchComparator;
    private Comparator<BibtexEntry> groupComparator;
    private Comparator<BibtexEntry> markingComparator = new IsMarkedComparator();
    private Matcher<BibtexEntry> searchMatcher;
    private Matcher<BibtexEntry> groupMatcher;
    private final PersistenceTableColumnListener tableColumnListener;
    public static final int REQUIRED = 1;
    public static final int OPTIONAL = 2;
    public static final int REQ_STRING = 1;
    public static final int REQ_NUMBER = 2;
    public static final int OPT_STRING = 3;
    public static final int OTHER = 3;
    public static final int BOOLEAN = 4;
    public static final int ICON_COL = 8;
    private static GeneralRenderer defRenderer;
    private static GeneralRenderer reqRenderer;
    private static GeneralRenderer optRenderer;
    private static GeneralRenderer grayedOutRenderer;
    private static GeneralRenderer veryGrayedOutRenderer;
    private static GeneralRenderer[] markedRenderers;
    private static IncompleteRenderer incRenderer;
    private static CompleteRenderer compRenderer;
    private static CompleteRenderer grayedOutNumberRenderer;
    private static CompleteRenderer veryGrayedOutNumberRenderer;
    private static CompleteRenderer[] markedNumberRenderers;

    public MainTable(MainTableFormat tableFormat, EventList<BibtexEntry> list, JabRefFrame frame, BasePanel panel) {
        this.addFocusListener(Globals.focusListener);
        this.setAutoResizeMode(Globals.prefs.getInt("autoResizeMode"));
        this.tableFormat = tableFormat;
        this.panel = panel;
        this.sortedForTable = new SortedList<BibtexEntry>(list, null);
        this.sortedForMarking = new SortedList<BibtexEntry>(this.sortedForTable, null);
        this.sortedForSearch = new SortedList<BibtexEntry>(this.sortedForMarking, null);
        this.sortedForGrouping = new SortedList<BibtexEntry>(this.sortedForSearch, null);
        this.searchMatcher = null;
        this.groupMatcher = null;
        this.searchComparator = null;
        this.groupComparator = null;
        EventTableModel<BibtexEntry> tableModel = new EventTableModel<BibtexEntry>(this.sortedForGrouping, tableFormat);
        this.setModel(tableModel);
        this.tableColorCodes = Globals.prefs.getBoolean("tableColorCodesOn");
        this.selectionModel = new EventSelectionModel<BibtexEntry>(this.sortedForGrouping);
        this.setSelectionModel(this.selectionModel);
        this.pane = new JScrollPane(this);
        this.pane.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
        this.setGridColor(Globals.prefs.getColor("gridColor"));
        this.setTableHeader(new PreventDraggingJTableHeader(this.getColumnModel()));
        this.comparatorChooser = new MyTableComparatorChooser(this, this.sortedForTable, TableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.tableColumnListener = new PersistenceTableColumnListener(this);
        this.getSelected();
        this.setDragEnabled(true);
        EntryTableTransferHandler xfer = new EntryTableTransferHandler(this, frame, panel);
        this.setTransferHandler(xfer);
        this.pane.setTransferHandler(xfer);
        this.setupComparatorChooser();
        this.refreshSorting();
        this.setWidths();
    }

    public void refreshSorting() {
        this.sortedForMarking.getReadWriteLock().writeLock().lock();
        if (Globals.prefs.getBoolean("floatMarkedEntries")) {
            this.sortedForMarking.setComparator(this.markingComparator);
        } else {
            this.sortedForMarking.setComparator(null);
        }
        this.sortedForMarking.getReadWriteLock().writeLock().unlock();
        this.sortedForSearch.getReadWriteLock().writeLock().lock();
        this.sortedForSearch.setComparator(this.searchComparator);
        this.sortedForSearch.getReadWriteLock().writeLock().unlock();
        this.sortedForGrouping.getReadWriteLock().writeLock().lock();
        this.sortedForGrouping.setComparator(this.groupComparator);
        this.sortedForGrouping.getReadWriteLock().writeLock().unlock();
    }

    public void showFloatSearch(Matcher<BibtexEntry> m) {
        this.showingFloatSearch = true;
        this.searchMatcher = m;
        this.searchComparator = new HitOrMissComparator(m);
        this.refreshSorting();
        this.scrollTo(0);
    }

    public void stopShowingFloatSearch() {
        this.showingFloatSearch = false;
        this.searchMatcher = null;
        this.searchComparator = null;
        this.refreshSorting();
    }

    public void showFloatGrouping(Matcher<BibtexEntry> m) {
        this.showingFloatGrouping = true;
        this.groupMatcher = m;
        this.groupComparator = new HitOrMissComparator(m);
        this.refreshSorting();
    }

    public boolean isShowingFloatSearch() {
        return this.showingFloatSearch;
    }

    public void stopShowingFloatGrouping() {
        this.showingFloatGrouping = false;
        this.groupMatcher = null;
        this.groupComparator = null;
        this.refreshSorting();
    }

    public EventList<BibtexEntry> getTableRows() {
        return this.sortedForGrouping;
    }

    public void addSelectionListener(ListEventListener<BibtexEntry> listener) {
        this.getSelected().addListEventListener(listener);
    }

    public JScrollPane getPane() {
        return this.pane;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int marking;
        int score = -3;
        TableCellRenderer renderer = defRenderer;
        int status = this.getCellStatus(row, column);
        if (!this.showingFloatSearch || this.matches(row, this.searchMatcher)) {
            ++score;
        }
        if (!this.showingFloatGrouping || this.matches(row, this.groupMatcher)) {
            score += 2;
        }
        if (score < -1) {
            if (column == 0) {
                veryGrayedOutNumberRenderer.setNumber(row);
                renderer = veryGrayedOutNumberRenderer;
            } else {
                renderer = veryGrayedOutRenderer;
            }
        } else if (score == -1) {
            if (column == 0) {
                grayedOutNumberRenderer.setNumber(row);
                renderer = grayedOutNumberRenderer;
            } else {
                renderer = grayedOutRenderer;
            }
        } else if (column == 0) {
            if (!this.isComplete(row)) {
                incRenderer.setNumber(row);
                renderer = incRenderer;
            } else {
                compRenderer.setNumber(row);
                marking = this.isMarked(row);
                if (marking > 0) {
                    marking = Math.min(marking, Util.MARK_COLOR_LEVELS);
                    renderer = markedNumberRenderers[marking - 1];
                    markedNumberRenderers[marking - 1].setNumber(row);
                } else {
                    renderer = compRenderer;
                }
            }
        } else if (this.tableColorCodes) {
            if (status == 1) {
                renderer = reqRenderer;
            } else if (status == 2) {
                renderer = optRenderer;
            } else if (status == 4) {
                renderer = this.getDefaultRenderer(Boolean.class);
            }
        }
        marking = this.isMarked(row);
        if (column != 0 && marking > 0) {
            marking = Math.min(marking, Util.MARK_COLOR_LEVELS);
            renderer = markedRenderers[marking - 1];
        }
        return renderer;
    }

    public void setWidths() {
        int i;
        int ncWidth = Globals.prefs.getInt("numberColWidth");
        String[] widths = Globals.prefs.getStringArray("columnWidths");
        TableColumnModel cm = this.getColumnModel();
        cm.getColumn(0).setPreferredWidth(ncWidth);
        for (i = 1; i < this.tableFormat.padleft; ++i) {
            cm.getColumn(i).setPreferredWidth(GUIGlobals.WIDTH_ICON_COL);
            cm.getColumn(i).setMinWidth(GUIGlobals.WIDTH_ICON_COL);
            cm.getColumn(i).setMaxWidth(GUIGlobals.WIDTH_ICON_COL);
        }
        for (i = this.tableFormat.padleft; i < this.getModel().getColumnCount(); ++i) {
            try {
                cm.getColumn(i).setPreferredWidth(Integer.parseInt(widths[i - this.tableFormat.padleft]));
                continue;
            }
            catch (Throwable ex) {
                Globals.logger("Exception while setting column widths. Choosing default.");
                cm.getColumn(i).setPreferredWidth(GUIGlobals.DEFAULT_FIELD_LENGTH);
            }
        }
    }

    public BibtexEntry getEntryAt(int row) {
        return (BibtexEntry)this.sortedForGrouping.get(row);
    }

    public BibtexEntry[] getSelectedEntries() {
        BibtexEntry[] BE_ARRAY = new BibtexEntry[]{};
        return this.getSelected().toArray(BE_ARRAY);
    }

    public List<Boolean> getCurrentSortOrder() {
        ArrayList<Boolean> order = new ArrayList<Boolean>();
        List<Integer> sortCols = this.comparatorChooser.getSortingColumns();
        for (int i : sortCols) {
            order.add(this.comparatorChooser.isColumnReverse(i));
        }
        return order;
    }

    public List<String> getCurrentSortFields() {
        List<Integer> sortCols = this.comparatorChooser.getSortingColumns();
        ArrayList<String> fields = new ArrayList<String>();
        for (int i : sortCols) {
            fields.add(this.tableFormat.getColumnName(i).toLowerCase());
        }
        return fields;
    }

    private void setupComparatorChooser() {
        int i;
        List<Comparator> comparators = this.comparatorChooser.getComparatorsForColumn(0);
        comparators.clear();
        comparators.add(new FirstColumnComparator(this.panel.database()));
        for (i = 1; i < this.tableFormat.padleft; ++i) {
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            String[] iconField = this.tableFormat.getIconTypeForColumn(i);
            comparators.add(new IconComparator(iconField));
        }
        for (i = this.tableFormat.padleft; i < this.tableFormat.getColumnCount(); ++i) {
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            comparators.add(new FieldComparator(this.tableFormat.getColumnName(i).toLowerCase()));
        }
        String[] sortFields = new String[]{Globals.prefs.get("priSort"), Globals.prefs.get("secSort"), Globals.prefs.get("terSort")};
        boolean[] sortDirections = new boolean[]{Globals.prefs.getBoolean("priDescending"), Globals.prefs.getBoolean("secDescending"), Globals.prefs.getBoolean("terDescending")};
        this.sortedForTable.getReadWriteLock().writeLock().lock();
        for (int i2 = 0; i2 < sortFields.length; ++i2) {
            int index = this.tableFormat.getColumnIndex(sortFields[i2]);
            if (index < 0) continue;
            this.comparatorChooser.appendComparator(index, 0, sortDirections[i2]);
        }
        this.sortedForTable.getReadWriteLock().writeLock().unlock();
        this.comparatorChooser.addSortActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<String> fields = MainTable.this.getCurrentSortFields();
                List<Boolean> order = MainTable.this.getCurrentSortOrder();
                int count = Math.min(fields.size(), order.size());
                if (count >= 1) {
                    Globals.prefs.put("priSort", fields.get(0));
                    Globals.prefs.putBoolean("priDescending", order.get(0));
                }
                if (count >= 2) {
                    Globals.prefs.put("secSort", fields.get(1));
                    Globals.prefs.putBoolean("secDescending", order.get(1));
                } else {
                    Globals.prefs.put("secSort", "");
                    Globals.prefs.putBoolean("secDescending", false);
                }
                if (count >= 3) {
                    Globals.prefs.put("terSort", fields.get(2));
                    Globals.prefs.putBoolean("terDescending", order.get(2));
                } else {
                    Globals.prefs.put("terSort", "");
                    Globals.prefs.putBoolean("terDescending", false);
                }
            }
        });
    }

    public int getCellStatus(int row, int col) {
        try {
            BibtexEntry be = (BibtexEntry)this.sortedForGrouping.get(row);
            BibtexEntryType type = be.getType();
            String columnName = this.getColumnName(col).toLowerCase();
            if (columnName.equals("bibtexkey") || type.isRequired(columnName)) {
                return 1;
            }
            if (type.isOptional(columnName)) {
                return 2;
            }
            return 3;
        }
        catch (NullPointerException ex) {
            return 3;
        }
    }

    public EventList<BibtexEntry> getSelected() {
        return this.selectionModel.getSelected();
    }

    public int findEntry(BibtexEntry entry) {
        return this.sortedForGrouping.indexOf(entry);
    }

    public String[] getIconTypeForColumn(int column) {
        return this.tableFormat.getIconTypeForColumn(column);
    }

    private boolean matches(int row, Matcher<BibtexEntry> m) {
        return m.matches((BibtexEntry)this.sortedForGrouping.get(row));
    }

    private boolean isComplete(int row) {
        try {
            BibtexEntry be = (BibtexEntry)this.sortedForGrouping.get(row);
            return be.hasAllRequiredFields(this.panel.database());
        }
        catch (NullPointerException ex) {
            return true;
        }
    }

    private int isMarked(int row) {
        try {
            BibtexEntry be = (BibtexEntry)this.sortedForGrouping.get(row);
            return Util.isMarked(be);
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public void scrollTo(int y) {
        JScrollBar scb = this.pane.getVerticalScrollBar();
        scb.setValue(y * scb.getUnitIncrement(1));
    }

    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
        this.setRowHeight(4 + GUIGlobals.CURRENTFONT.getSize());
    }

    public void ensureVisible(int row) {
        JScrollBar vert = this.pane.getVerticalScrollBar();
        int y = row * this.getRowHeight();
        if (y < vert.getValue() || y > vert.getValue() + vert.getVisibleAmount()) {
            this.scrollToCenter(row, 1);
        }
    }

    public void scrollToCenter(int rowIndex, int vColIndex) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(rowIndex, vColIndex, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
        this.revalidate();
        this.repaint();
    }

    public static void updateRenderers() {
        defRenderer = new GeneralRenderer(Globals.prefs.getColor("tableBackground"), Globals.prefs.getColor("tableText"));
        Color sel = defRenderer.getTableCellRendererComponent(new JTable(), "", true, false, 0, 0).getBackground();
        reqRenderer = new GeneralRenderer(Globals.prefs.getColor("tableReqFieldBackground"), Globals.prefs.getColor("tableText"));
        optRenderer = new GeneralRenderer(Globals.prefs.getColor("tableOptFieldBackground"), Globals.prefs.getColor("tableText"));
        incRenderer = new IncompleteRenderer();
        compRenderer = new CompleteRenderer(Globals.prefs.getColor("tableBackground"));
        grayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("grayedOutBackground"));
        veryGrayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("veryGrayedOutBackground"));
        grayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("grayedOutBackground"), Globals.prefs.getColor("grayedOutText"), MainTable.mixColors(Globals.prefs.getColor("grayedOutBackground"), sel));
        veryGrayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("veryGrayedOutBackground"), Globals.prefs.getColor("veryGrayedOutText"), MainTable.mixColors(Globals.prefs.getColor("veryGrayedOutBackground"), sel));
        markedRenderers = new GeneralRenderer[Util.MARK_COLOR_LEVELS];
        markedNumberRenderers = new CompleteRenderer[Util.MARK_COLOR_LEVELS];
        for (int i = 0; i < Util.MARK_COLOR_LEVELS; ++i) {
            Color c = Globals.prefs.getColor("markedEntryBackground" + i);
            MainTable.markedRenderers[i] = new GeneralRenderer(c, Globals.prefs.getColor("tableText"), MainTable.mixColors(Globals.prefs.getColor("markedEntryBackground" + i), sel));
            MainTable.markedNumberRenderers[i] = new CompleteRenderer(c);
        }
    }

    private static Color mixColors(Color one, Color two) {
        return new Color((one.getRed() + two.getRed()) / 2, (one.getGreen() + two.getGreen()) / 2, (one.getBlue() + two.getBlue()) / 2);
    }

    @Override
    public void setUI(TableUI newUI) {
        super.setUI(newUI);
        TransferHandler handler = this.getTransferHandler();
        this.setTransferHandler(null);
        this.setTransferHandler(handler);
    }

    public Comparator<BibtexEntry> getComparatorForColumn(int index) {
        List<Comparator> l = this.comparatorChooser.getComparatorsForColumn(index);
        return l.size() == 0 ? null : l.get(0);
    }

    public int getSortingColumn(int number) {
        List<Integer> l = this.comparatorChooser.getSortingColumns();
        if (l.size() <= number) {
            return -1;
        }
        return l.get(number);
    }

    public PersistenceTableColumnListener getTableColumnListener() {
        return this.tableColumnListener;
    }

    public SortedList<BibtexEntry> getSortedForTable() {
        return this.sortedForTable;
    }

    static {
        MainTable.updateRenderers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableComparatorChooser
    extends TableComparatorChooser<BibtexEntry> {
        public MyTableComparatorChooser(JTable table, SortedList<BibtexEntry> list, Object sortingStrategy) {
            super(table, list, sortingStrategy);
            this.addSortActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainTable.this.refreshSorting();
                }
            });
        }
    }

    static class CompleteRenderer
    extends GeneralRenderer {
        public CompleteRenderer(Color color) {
            super(color);
        }

        protected void setNumber(int number) {
            super.setValue(String.valueOf(number + 1));
        }

        protected void setValue(Object value) {
        }
    }

    static class IncompleteRenderer
    extends GeneralRenderer {
        public IncompleteRenderer() {
            super(Globals.prefs.getColor("incompleteEntryBackground"));
            super.setToolTipText(Globals.lang("This entry is incomplete"));
        }

        protected void setNumber(int number) {
            super.setValue(String.valueOf(number + 1));
        }

        protected void setValue(Object value) {
        }
    }
}

