/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.ErrorMessageDisplay;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SearchRuleSet;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AddToGroupAction;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.AndOrSearchRuleSet;
import net.sf.jabref.groups.AutoGroupDialog;
import net.sf.jabref.groups.GroupDialog;
import net.sf.jabref.groups.GroupMatcher;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.GroupsTree;
import net.sf.jabref.groups.RemoveFromGroupAction;
import net.sf.jabref.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.groups.UndoableModifyGroup;
import net.sf.jabref.groups.UndoableModifySubtree;
import net.sf.jabref.undo.NamedCompound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSelector
extends SidePaneComponent
implements TreeSelectionListener,
ActionListener,
ErrorMessageDisplay {
    JButton newButton = new JButton(GUIGlobals.getImage("new"));
    JButton helpButton = new JButton(GUIGlobals.getImage("help"));
    JButton refresh = new JButton(GUIGlobals.getImage("refresh"));
    JButton autoGroup = new JButton(GUIGlobals.getImage("autoGroup"));
    JButton openset = new JButton(Globals.lang("Settings"));
    Color bgColor = Color.white;
    GroupsTree groupsTree;
    DefaultTreeModel groupsTreeModel;
    GroupTreeNode groupsRoot;
    JScrollPane sp;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JabRefFrame frame;
    String searchField;
    JPopupMenu groupsContextMenu = new JPopupMenu();
    JPopupMenu settings = new JPopupMenu();
    private JRadioButtonMenuItem hideNonHits;
    private JRadioButtonMenuItem grayOut;
    JRadioButtonMenuItem andCb = new JRadioButtonMenuItem(Globals.lang("Intersection"), true);
    JRadioButtonMenuItem orCb = new JRadioButtonMenuItem(Globals.lang("Union"), false);
    JRadioButtonMenuItem floatCb = new JRadioButtonMenuItem(Globals.lang("Float"), true);
    JRadioButtonMenuItem highlCb = new JRadioButtonMenuItem(Globals.lang("Highlight"), false);
    JCheckBoxMenuItem invCb = new JCheckBoxMenuItem(Globals.lang("Inverted"), false);
    JCheckBoxMenuItem select = new JCheckBoxMenuItem(Globals.lang("Select matches"), false);
    JCheckBoxMenuItem showOverlappingGroups = new JCheckBoxMenuItem(Globals.lang("Highlight overlapping groups"));
    JCheckBoxMenuItem autoAssignGroup = new JCheckBoxMenuItem(Globals.lang("Automatically assign new entry to selected groups"));
    ButtonGroup bgr = new ButtonGroup();
    ButtonGroup visMode = new ButtonGroup();
    ButtonGroup nonHits = new ButtonGroup();
    JButton expand = new JButton(GUIGlobals.getImage("down"));
    JButton reduce = new JButton(GUIGlobals.getImage("up"));
    JCheckBoxMenuItem editModeCb = new JCheckBoxMenuItem(Globals.lang("Edit Group Membership"), false);
    Border editModeBorder = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.RED), "Edit mode", 3, 2, Font.getFont("Default"), Color.RED);
    boolean editModeIndicator;
    SidePaneManager manager;
    final AbstractAction editGroupAction = new EditGroupAction();
    final NodeAction editGroupPopupAction = new EditGroupAction();
    final NodeAction addGroupPopupAction = new AddGroupAction();
    final NodeAction addSubgroupPopupAction = new AddSubgroupAction();
    final NodeAction removeGroupAndSubgroupsPopupAction = new RemoveGroupAndSubgroupsAction();
    final NodeAction removeSubgroupsPopupAction = new RemoveSubgroupsAction();
    final NodeAction removeGroupKeepSubgroupsPopupAction = new RemoveGroupKeepSubgroupsAction();
    final NodeAction moveNodeUpPopupAction = new MoveNodeUpAction();
    final NodeAction moveNodeDownPopupAction = new MoveNodeDownAction();
    final NodeAction moveNodeLeftPopupAction = new MoveNodeLeftAction();
    final NodeAction moveNodeRightPopupAction = new MoveNodeRightAction();
    final NodeAction moveNodeUpAction = new MoveNodeUpAction();
    final NodeAction moveNodeDownAction = new MoveNodeDownAction();
    final NodeAction moveNodeLeftAction = new MoveNodeLeftAction();
    final NodeAction moveNodeRightAction = new MoveNodeRightAction();
    final NodeAction expandSubtreePopupAction = new ExpandSubtreeAction();
    final NodeAction collapseSubtreePopupAction = new CollapseSubtreeAction();
    final NodeAction sortDirectSubgroupsPopupAction = new SortDirectSubgroupsAction();
    final NodeAction sortAllSubgroupsPopupAction = new SortAllSubgroupsAction();
    final AddToGroupAction addToGroup = new AddToGroupAction(false);
    final AddToGroupAction moveToGroup = new AddToGroupAction(true);
    final RemoveFromGroupAction removeFromGroup = new RemoveFromGroupAction();
    public final AbstractAction clearHighlightAction = new AbstractAction(Globals.lang("Clear highlight")){

        public void actionPerformed(ActionEvent ae) {
            GroupSelector.this.groupsTree.setHighlight3Cells(null);
        }
    };
    JMenu moveSubmenu = new JMenu(Globals.lang("Move"));
    JMenu sortSubmenu = new JMenu(Globals.lang("Sort alphabetically"));

    public GroupSelector(JabRefFrame frame, SidePaneManager manager) {
        super(manager, GUIGlobals.getIconUrl("toggleGroups"), Globals.lang("Groups"));
        this.groupsRoot = new GroupTreeNode(new AllEntriesGroup());
        this.manager = manager;
        this.frame = frame;
        this.hideNonHits = new JRadioButtonMenuItem(Globals.lang("Hide non-hits"), !Globals.prefs.getBoolean("grayOutNonHits"));
        this.grayOut = new JRadioButtonMenuItem(Globals.lang("Gray out non-hits"), Globals.prefs.getBoolean("grayOutNonHits"));
        this.nonHits.add(this.hideNonHits);
        this.nonHits.add(this.grayOut);
        this.floatCb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("groupFloatSelections", GroupSelector.this.floatCb.isSelected());
            }
        });
        this.andCb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("groupIntersectSelections", GroupSelector.this.andCb.isSelected());
            }
        });
        this.invCb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("groupInvertSelections", GroupSelector.this.invCb.isSelected());
            }
        });
        this.showOverlappingGroups.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("groupShowOverlapping", GroupSelector.this.showOverlappingGroups.isSelected());
                if (!GroupSelector.this.showOverlappingGroups.isSelected()) {
                    GroupSelector.this.groupsTree.setHighlight2Cells(null);
                }
            }
        });
        this.select.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("groupSelectMatches", GroupSelector.this.select.isSelected());
            }
        });
        this.grayOut.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("grayOutNonHits", GroupSelector.this.grayOut.isSelected());
            }
        });
        if (Globals.prefs.getBoolean("groupFloatSelections")) {
            this.floatCb.setSelected(true);
            this.highlCb.setSelected(false);
        } else {
            this.highlCb.setSelected(true);
            this.floatCb.setSelected(false);
        }
        if (Globals.prefs.getBoolean("groupIntersectSelections")) {
            this.andCb.setSelected(true);
            this.orCb.setSelected(false);
        } else {
            this.orCb.setSelected(true);
            this.andCb.setSelected(false);
        }
        this.autoAssignGroup.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("autoAssignGroup", GroupSelector.this.autoAssignGroup.isSelected());
            }
        });
        this.invCb.setSelected(Globals.prefs.getBoolean("groupInvertSelections"));
        this.showOverlappingGroups.setSelected(Globals.prefs.getBoolean("groupShowOverlapping"));
        this.select.setSelected(Globals.prefs.getBoolean("groupSelectMatches"));
        this.editModeIndicator = Globals.prefs.getBoolean("groupEditGroupMembershipMode");
        this.editModeCb.setSelected(this.editModeIndicator);
        this.autoAssignGroup.setSelected(Globals.prefs.getBoolean("autoAssignGroup"));
        this.openset.setMargin(new Insets(0, 0, 0, 0));
        this.settings.add(this.andCb);
        this.settings.add(this.orCb);
        this.settings.addSeparator();
        this.settings.add(this.invCb);
        this.settings.addSeparator();
        this.settings.add(this.select);
        this.settings.addSeparator();
        this.settings.add(this.editModeCb);
        this.settings.addSeparator();
        this.settings.add(this.grayOut);
        this.settings.add(this.hideNonHits);
        this.settings.addSeparator();
        this.settings.add(this.showOverlappingGroups);
        this.settings.addSeparator();
        this.settings.add(this.autoAssignGroup);
        this.openset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!GroupSelector.this.settings.isVisible()) {
                    JButton src = (JButton)e.getSource();
                    GroupSelector.this.autoAssignGroup.setSelected(Globals.prefs.getBoolean("autoAssignGroup"));
                    GroupSelector.this.settings.show(src, 0, GroupSelector.this.openset.getHeight());
                }
            }
        });
        this.expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = Globals.prefs.getInt("groupsVisibleRows") + 1;
                GroupSelector.this.groupsTree.setVisibleRowCount(i);
                GroupSelector.this.groupsTree.revalidate();
                GroupSelector.this.groupsTree.repaint();
                GroupSelector.this.revalidate();
                GroupSelector.this.repaint();
                Globals.prefs.putInt("groupsVisibleRows", i);
                Globals.logger(Double.toString(GroupSelector.this.getHeight()));
                Globals.logger(Double.toString(GroupSelector.this.getPreferredSize().getHeight()));
            }
        });
        this.reduce.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = Globals.prefs.getInt("groupsVisibleRows") - 1;
                if (i < 1) {
                    i = 1;
                }
                GroupSelector.this.groupsTree.setVisibleRowCount(i);
                GroupSelector.this.groupsTree.revalidate();
                GroupSelector.this.groupsTree.repaint();
                GroupSelector.this.revalidate();
                GroupSelector.this.repaint();
                Globals.prefs.putInt("groupsVisibleRows", i);
            }
        });
        this.editModeCb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GroupSelector.this.editModeIndicator = GroupSelector.this.editModeCb.getState();
                GroupSelector.this.updateBorder(GroupSelector.this.editModeIndicator);
                Globals.prefs.putBoolean("groupEditGroupMembershipMode", GroupSelector.this.editModeIndicator);
            }
        });
        int butSize = this.newButton.getIcon().getIconHeight() + 5;
        Dimension butDim = new Dimension(butSize, butSize);
        this.newButton.setPreferredSize(butDim);
        this.newButton.setMinimumSize(butDim);
        this.refresh.setPreferredSize(butDim);
        this.refresh.setMinimumSize(butDim);
        this.helpButton.setPreferredSize(butDim);
        this.helpButton.setMinimumSize(butDim);
        this.autoGroup.setPreferredSize(butDim);
        this.autoGroup.setMinimumSize(butDim);
        this.openset.setPreferredSize(butDim);
        this.openset.setMinimumSize(butDim);
        this.expand.setPreferredSize(butDim);
        this.expand.setMinimumSize(butDim);
        this.reduce.setPreferredSize(butDim);
        this.reduce.setMinimumSize(butDim);
        Insets butIns = new Insets(0, 0, 0, 0);
        this.helpButton.setMargin(butIns);
        this.reduce.setMargin(butIns);
        this.expand.setMargin(butIns);
        this.openset.setMargin(butIns);
        this.newButton.addActionListener(this);
        this.refresh.addActionListener(this);
        this.andCb.addActionListener(this);
        this.orCb.addActionListener(this);
        this.invCb.addActionListener(this);
        this.showOverlappingGroups.addActionListener(this);
        this.autoGroup.addActionListener(this);
        this.floatCb.addActionListener(this);
        this.highlCb.addActionListener(this);
        this.select.addActionListener(this);
        this.hideNonHits.addActionListener(this);
        this.grayOut.addActionListener(this);
        this.newButton.setToolTipText(Globals.lang("New group"));
        this.refresh.setToolTipText(Globals.lang("Refresh view"));
        this.andCb.setToolTipText(Globals.lang("Display only entries belonging to all selected groups."));
        this.orCb.setToolTipText(Globals.lang("Display all entries belonging to one or more of the selected groups."));
        this.autoGroup.setToolTipText(Globals.lang("Automatically create groups for database."));
        this.invCb.setToolTipText(Globals.lang("Show entries *not* in group selection"));
        this.showOverlappingGroups.setToolTipText("Highlight groups that contain entries contained in any currently selected group");
        this.floatCb.setToolTipText(Globals.lang("Move entries in group selection to the top"));
        this.highlCb.setToolTipText(Globals.lang("Gray out entries not in group selection"));
        this.select.setToolTipText(Globals.lang("Select entries in group selection"));
        this.expand.setToolTipText(Globals.lang("Show one more row"));
        this.reduce.setToolTipText(Globals.lang("Show one less rows"));
        this.editModeCb.setToolTipText(Globals.lang("Click group to toggle membership of selected entries"));
        this.bgr.add(this.andCb);
        this.bgr.add(this.orCb);
        this.visMode.add(this.floatCb);
        this.visMode.add(this.highlCb);
        JPanel main = new JPanel();
        main.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.newButton, this.con);
        main.add(this.newButton);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.refresh, this.con);
        main.add(this.refresh);
        this.con.gridx = 2;
        this.gbl.setConstraints(this.autoGroup, this.con);
        main.add(this.autoGroup);
        this.con.gridx = 3;
        this.con.gridwidth = 0;
        HelpAction helpAction = new HelpAction(frame.helpDiag, GUIGlobals.groupsHelp, "Help on groups");
        this.helpButton.addActionListener(helpAction);
        this.helpButton.setToolTipText(Globals.lang("Help on groups"));
        this.gbl.setConstraints(this.helpButton, this.con);
        main.add(this.helpButton);
        this.groupsTree = new GroupsTree(this);
        this.groupsTree.addTreeSelectionListener(this);
        this.groupsTreeModel = new DefaultTreeModel(this.groupsRoot);
        this.groupsTree.setModel(this.groupsTreeModel);
        this.sp = new JScrollPane(this.groupsTree, 20, 30);
        this.revalidateGroups();
        this.con.gridwidth = 0;
        this.con.weighty = 1.0;
        this.con.gridx = 0;
        this.con.gridwidth = 4;
        this.con.gridy = 1;
        this.gbl.setConstraints(this.sp, this.con);
        main.add(this.sp);
        JPanel pan = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        this.con.weighty = 0.0;
        this.gbl.setConstraints(pan, this.con);
        pan.setLayout(gb);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.weightx = 1.0;
        this.con.gridwidth = 4;
        this.con.fill = 2;
        gb.setConstraints(this.openset, this.con);
        pan.add(this.openset);
        this.con.gridwidth = 1;
        this.con.gridx = 4;
        this.con.gridy = 0;
        gb.setConstraints(this.expand, this.con);
        pan.add(this.expand);
        this.con.gridx = 5;
        gb.setConstraints(this.reduce, this.con);
        pan.add(this.reduce);
        this.con.gridwidth = 6;
        this.con.gridy = 1;
        this.con.gridx = 0;
        this.con.fill = 2;
        this.con.gridy = 2;
        this.con.gridx = 0;
        this.con.gridwidth = 4;
        this.gbl.setConstraints(pan, this.con);
        main.add(pan);
        main.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)main, "Center");
        this.updateBorder(this.editModeIndicator);
        this.definePopup();
        this.moveNodeUpAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 2));
        this.moveNodeDownAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 2));
        this.moveNodeLeftAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 2));
        this.moveNodeRightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 2));
    }

    private void definePopup() {
        this.groupsContextMenu.add(this.editGroupPopupAction);
        this.groupsContextMenu.add(this.addGroupPopupAction);
        this.groupsContextMenu.add(this.addSubgroupPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.removeGroupAndSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeGroupKeepSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeSubgroupsPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.expandSubtreePopupAction);
        this.groupsContextMenu.add(this.collapseSubtreePopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.moveSubmenu);
        this.sortSubmenu.add(this.sortDirectSubgroupsPopupAction);
        this.sortSubmenu.add(this.sortAllSubgroupsPopupAction);
        this.groupsContextMenu.add(this.sortSubmenu);
        this.moveSubmenu.add(this.moveNodeUpPopupAction);
        this.moveSubmenu.add(this.moveNodeDownPopupAction);
        this.moveSubmenu.add(this.moveNodeLeftPopupAction);
        this.moveSubmenu.add(this.moveNodeRightPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.addToGroup);
        this.groupsContextMenu.add(this.moveToGroup);
        this.groupsContextMenu.add(this.removeFromGroup);
        this.groupsTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GroupSelector.this.showPopup(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GroupSelector.this.showPopup(e);
                }
            }

            public void mouseClicked(MouseEvent e) {
                TreePath path = GroupSelector.this.groupsTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                if (path == null) {
                    return;
                }
                GroupTreeNode node = (GroupTreeNode)path.getLastPathComponent();
                if (node.isRoot()) {
                    return;
                }
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    GroupSelector.this.editGroupAction.actionPerformed(null);
                } else if (e.getClickCount() == 1 && e.getButton() == 1) {
                    GroupSelector.this.annotationEvent(node);
                }
            }
        });
        this.groupsContextMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }
        });
    }

    private void showPopup(MouseEvent e) {
        TreePath path = this.groupsTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        this.addGroupPopupAction.setEnabled(true);
        this.addSubgroupPopupAction.setEnabled(path != null);
        this.editGroupPopupAction.setEnabled(path != null);
        this.removeGroupAndSubgroupsPopupAction.setEnabled(path != null);
        this.removeGroupKeepSubgroupsPopupAction.setEnabled(path != null);
        this.moveSubmenu.setEnabled(path != null);
        this.expandSubtreePopupAction.setEnabled(path != null);
        this.collapseSubtreePopupAction.setEnabled(path != null);
        this.removeSubgroupsPopupAction.setEnabled(path != null);
        this.sortSubmenu.setEnabled(path != null);
        this.addToGroup.setEnabled(false);
        this.moveToGroup.setEnabled(false);
        this.removeFromGroup.setEnabled(false);
        if (path != null) {
            GroupTreeNode node = (GroupTreeNode)path.getLastPathComponent();
            this.editGroupPopupAction.setNode(node);
            this.addSubgroupPopupAction.setNode(node);
            this.removeGroupAndSubgroupsPopupAction.setNode(node);
            this.removeSubgroupsPopupAction.setNode(node);
            this.removeGroupKeepSubgroupsPopupAction.setNode(node);
            this.expandSubtreePopupAction.setNode(node);
            this.collapseSubtreePopupAction.setNode(node);
            this.sortDirectSubgroupsPopupAction.setNode(node);
            this.sortAllSubgroupsPopupAction.setNode(node);
            this.groupsTree.setHighlightBorderCell(node);
            AbstractGroup group = node.getGroup();
            if (group instanceof AllEntriesGroup) {
                this.editGroupPopupAction.setEnabled(false);
                this.addGroupPopupAction.setEnabled(false);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(false);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(false);
            } else {
                this.editGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setNode(node);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(true);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(true);
            }
            this.expandSubtreePopupAction.setEnabled(this.groupsTree.isCollapsed(path) || this.groupsTree.hasCollapsedDescendant(path));
            this.collapseSubtreePopupAction.setEnabled(this.groupsTree.isExpanded(path) || this.groupsTree.hasExpandedDescendant(path));
            this.sortSubmenu.setEnabled(!node.isLeaf());
            this.removeSubgroupsPopupAction.setEnabled(!node.isLeaf());
            this.moveNodeUpPopupAction.setEnabled(node.canMoveUp());
            this.moveNodeDownPopupAction.setEnabled(node.canMoveDown());
            this.moveNodeLeftPopupAction.setEnabled(node.canMoveLeft());
            this.moveNodeRightPopupAction.setEnabled(node.canMoveRight());
            this.moveSubmenu.setEnabled(this.moveNodeUpPopupAction.isEnabled() || this.moveNodeDownPopupAction.isEnabled() || this.moveNodeLeftPopupAction.isEnabled() || this.moveNodeRightPopupAction.isEnabled());
            this.moveNodeUpPopupAction.setNode(node);
            this.moveNodeDownPopupAction.setNode(node);
            this.moveNodeLeftPopupAction.setNode(node);
            this.moveNodeRightPopupAction.setNode(node);
            BibtexEntry[] selection = this.frame.basePanel().getSelectedEntries();
            if (selection.length > 0) {
                if (node.getGroup().supportsAdd() && !node.getGroup().containsAll(selection)) {
                    this.addToGroup.setNode(node);
                    this.addToGroup.setBasePanel(this.panel);
                    this.addToGroup.setEnabled(true);
                    this.moveToGroup.setNode(node);
                    this.moveToGroup.setBasePanel(this.panel);
                    this.moveToGroup.setEnabled(true);
                }
                if (node.getGroup().supportsRemove() && node.getGroup().containsAny(selection)) {
                    this.removeFromGroup.setNode(node);
                    this.removeFromGroup.setBasePanel(this.panel);
                    this.removeFromGroup.setEnabled(true);
                }
            }
        } else {
            this.editGroupPopupAction.setNode(null);
            this.addGroupPopupAction.setNode(null);
            this.addSubgroupPopupAction.setNode(null);
            this.removeGroupAndSubgroupsPopupAction.setNode(null);
            this.removeSubgroupsPopupAction.setNode(null);
            this.removeGroupKeepSubgroupsPopupAction.setNode(null);
            this.moveNodeUpPopupAction.setNode(null);
            this.moveNodeDownPopupAction.setNode(null);
            this.moveNodeLeftPopupAction.setNode(null);
            this.moveNodeRightPopupAction.setNode(null);
            this.expandSubtreePopupAction.setNode(null);
            this.collapseSubtreePopupAction.setNode(null);
            this.sortDirectSubgroupsPopupAction.setNode(null);
            this.sortAllSubgroupsPopupAction.setNode(null);
        }
        this.groupsContextMenu.show(this.groupsTree, e.getPoint().x, e.getPoint().y);
    }

    private void updateBorder(boolean editMode) {
        if (editMode) {
            this.groupsTree.setBorder(this.editModeBorder);
            this.setTitle("<html><font color='red'>Groups Edit mode</font></html>");
        } else {
            this.groupsTree.setBorder(null);
            this.setTitle(Globals.lang("Groups"));
        }
        this.groupsTree.revalidate();
        this.groupsTree.repaint();
    }

    private void updateGroupContent(GroupTreeNode node) {
        BibtexEntry[] entries = this.panel.getSelectedEntries();
        AbstractGroup group = node.getGroup();
        AbstractUndoableEdit undoRemove = null;
        AbstractUndoableEdit undoAdd = null;
        ArrayList<BibtexEntry> toRemove = new ArrayList<BibtexEntry>(entries.length);
        ArrayList<BibtexEntry> toAdd = new ArrayList<BibtexEntry>(entries.length);
        for (BibtexEntry entry : entries) {
            if (group.contains(entry)) {
                Globals.logger("remove " + entry.toString());
                toRemove.add(entry);
                continue;
            }
            Globals.logger("add " + entry.toString());
            toAdd.add(entry);
        }
        if (!toRemove.isEmpty()) {
            undoRemove = node.removeFromGroup(toRemove.toArray(new BibtexEntry[0]));
        }
        if (!toAdd.isEmpty()) {
            undoAdd = node.addToGroup(toAdd.toArray(new BibtexEntry[0]));
        }
        if (undoRemove != null) {
            if (undoAdd != null) {
                undoRemove.addEdit(undoAdd);
            }
            this.panel.undoManager.addEdit(undoRemove);
        } else if (undoAdd != null) {
            this.panel.undoManager.addEdit(undoAdd);
        }
    }

    public void updateGroupContentIfEnabled(boolean deletion) {
        if (this.groupsTree == null || this.groupsTree.getSelectionCount() == 0) {
            return;
        }
        if (!this.editModeIndicator) {
            return;
        }
        GroupTreeNode curNode = (GroupTreeNode)this.groupsTree.getSelectionPaths()[0].getLastPathComponent();
        this.updateGroupContent(curNode);
    }

    private void annotationEvent(GroupTreeNode node) {
        Globals.logger("annotationEvent");
        Globals.logger(node.toString());
        if (this.editModeIndicator) {
            this.updateGroupContent(node);
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
            this.updateSelections();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.panel == null) {
            return;
        }
        TreePath[] selection = this.groupsTree.getSelectionPaths();
        if (selection == null || selection.length == 0 || selection.length == 1 && ((GroupTreeNode)selection[0].getLastPathComponent()).getGroup() instanceof AllEntriesGroup) {
            this.panel.stopShowingGroup();
            this.panel.mainTable.stopShowingFloatGrouping();
            if (this.showOverlappingGroups.isSelected()) {
                this.groupsTree.setHighlight2Cells(null);
            }
            this.frame.output(Globals.lang("Displaying no groups") + ".");
            return;
        }
        if (!this.editModeIndicator) {
            this.updateSelections();
        }
    }

    private void updateSelections() {
        AndOrSearchRuleSet searchRules = new AndOrSearchRuleSet(this.andCb.isSelected(), this.invCb.isSelected());
        TreePath[] selection = this.groupsTree.getSelectionPaths();
        for (int i = 0; i < selection.length; ++i) {
            searchRules.addRule(((GroupTreeNode)selection[i].getLastPathComponent()).getSearchRule());
        }
        Hashtable<String, String> searchOptions = new Hashtable<String, String>();
        searchOptions.put("option", "dummy");
        GroupingWorker worker = new GroupingWorker(searchRules, searchOptions);
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    public void revalidateGroups(TreePath[] selectionPaths, Enumeration<TreePath> expandedNodes) {
        this.revalidateGroups(selectionPaths, expandedNodes, null);
    }

    public void revalidateGroups(TreePath[] selectionPaths, Enumeration<TreePath> expandedNodes, GroupTreeNode node) {
        this.groupsTreeModel.reload();
        this.groupsTree.clearSelection();
        if (selectionPaths != null) {
            this.groupsTree.setSelectionPaths(selectionPaths);
        }
        if (expandedNodes != null) {
            while (expandedNodes.hasMoreElements()) {
                this.groupsTree.expandPath(expandedNodes.nextElement());
            }
        }
        this.groupsTree.revalidate();
        if (node != null) {
            this.groupsTree.scrollPathToVisible(new TreePath(node.getPath()));
        }
    }

    public void revalidateGroups() {
        this.revalidateGroups(null);
    }

    public void revalidateGroups(GroupTreeNode node) {
        this.revalidateGroups(this.groupsTree.getSelectionPaths(), this.getExpandedPaths(), node);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refresh) {
            this.valueChanged(null);
        } else if (e.getSource() == this.newButton) {
            GroupDialog gd = new GroupDialog(this.frame, this.panel, null);
            gd.setVisible(true);
            if (gd.okPressed()) {
                AbstractGroup newGroup = gd.getResultingGroup();
                GroupTreeNode newNode = new GroupTreeNode(newGroup);
                this.groupsRoot.add(newNode);
                this.revalidateGroups();
                UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(this, this.groupsRoot, newNode, 0);
                this.panel.undoManager.addEdit(undo);
                this.panel.markBaseChanged();
                this.frame.output(Globals.lang("Created_group_\"%0\".", newGroup.getName()));
            }
        } else if (e.getSource() == this.autoGroup) {
            AutoGroupDialog gd = new AutoGroupDialog(this.frame, this.panel, this, this.groupsRoot, Globals.prefs.get("groupsDefaultField"), " .,", ",");
            gd.setVisible(true);
        } else if (e.getSource() instanceof JCheckBox) {
            this.valueChanged(null);
        } else if (e.getSource() instanceof JCheckBoxMenuItem) {
            this.valueChanged(null);
        } else if (e.getSource() instanceof JRadioButtonMenuItem) {
            this.valueChanged(null);
        }
    }

    @Override
    public void componentOpening() {
        this.valueChanged(null);
    }

    @Override
    public void componentClosing() {
        if (this.panel != null) {
            this.panel.stopShowingGroup();
            this.panel.mainTable.stopShowingFloatGrouping();
        }
        this.frame.groupToggle.setSelected(false);
    }

    public void setGroups(GroupTreeNode groupsRoot) {
        this.groupsTreeModel = new DefaultTreeModel(groupsRoot);
        this.groupsTree.setModel(this.groupsTreeModel);
        this.groupsRoot = groupsRoot;
        if (Globals.prefs.getBoolean("groupExpandTree")) {
            this.groupsTree.expandSubtree(groupsRoot);
        }
    }

    public void addGroups(GroupTreeNode newGroups, CompoundEdit ce) {
        if (newGroups.getGroup() instanceof AllEntriesGroup) {
            return;
        }
        this.groupsRoot.add(newGroups);
        UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(this, this.groupsRoot, newGroups, 0);
        ce.addEdit(undo);
    }

    public TreePath getSelectionPath() {
        return this.groupsTree.getSelectionPath();
    }

    public boolean moveNodeUp(GroupTreeNode node, boolean checkSingleSelection) {
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit undo = null;
        if (!node.canMoveUp() || (undo = node.moveUp(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" up.", node.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(undo, node);
        return true;
    }

    public boolean moveNodeDown(GroupTreeNode node, boolean checkSingleSelection) {
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit undo = null;
        if (!node.canMoveDown() || (undo = node.moveDown(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" down.", node.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(undo, node);
        return true;
    }

    public boolean moveNodeLeft(GroupTreeNode node, boolean checkSingleSelection) {
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit undo = null;
        if (!node.canMoveLeft() || (undo = node.moveLeft(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" left.", node.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(undo, node);
        return true;
    }

    public boolean moveNodeRight(GroupTreeNode node, boolean checkSingleSelection) {
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit undo = null;
        if (!node.canMoveRight() || (undo = node.moveRight(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" right.", node.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(undo, node);
        return true;
    }

    public void concludeMoveGroup(AbstractUndoableEdit undo, GroupTreeNode node) {
        this.panel.undoManager.addEdit(undo);
        this.panel.markBaseChanged();
        this.frame.output(Globals.lang("Moved group \"%0\".", node.getGroup().getName()));
    }

    public void concludeAssignment(AbstractUndoableEdit undo, GroupTreeNode node, int assignedEntries) {
        if (undo == null) {
            this.frame.output(Globals.lang("The group \"%0\" already contains the selection.", new String[]{node.getGroup().getName()}));
            return;
        }
        this.panel.undoManager.addEdit(undo);
        this.panel.markBaseChanged();
        this.panel.updateEntryEditorIfShowing();
        String groupName = node.getGroup().getName();
        if (assignedEntries == 1) {
            this.frame.output(Globals.lang("Assigned 1 entry to group \"%0\".", groupName));
        } else {
            this.frame.output(Globals.lang("Assigned %0 entries to group \"%1\".", String.valueOf(assignedEntries), groupName));
        }
    }

    public GroupTreeNode getGroupTreeRoot() {
        return this.groupsRoot;
    }

    public Enumeration<TreePath> getExpandedPaths() {
        return this.groupsTree.getExpandedDescendants(new TreePath(this.groupsRoot.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveBasePanel(BasePanel panel) {
        super.setActiveBasePanel(panel);
        if (panel == null) {
            this.frame.sidePaneManager.hide("groups");
            return;
        }
        MetaData metaData = panel.metaData();
        if (metaData.getGroups() != null) {
            this.setGroups(metaData.getGroups());
        } else {
            GroupTreeNode newGroupsRoot = new GroupTreeNode(new AllEntriesGroup());
            metaData.setGroups(newGroupsRoot);
            this.setGroups(newGroupsRoot);
        }
        if (Globals.prefs.getBoolean("groupAutoShow") && !this.groupsRoot.isLeaf()) {
            this.frame.sidePaneManager.show("groups");
            this.frame.groupToggle.setSelected(true);
        } else if (Globals.prefs.getBoolean("groupAutoHide") && this.groupsRoot.isLeaf()) {
            this.frame.sidePaneManager.hide("groups");
            this.frame.groupToggle.setSelected(false);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    @Override
    public void reportError(String errorMessage) {
        System.err.println("Error in group search: " + errorMessage + ". Please report this on www.sf.net/projects/jabref");
    }

    @Override
    public void reportError(String errorMessage, Exception exception) {
        this.reportError(errorMessage);
    }

    public void showMatchingGroups(BibtexEntry[] entries, boolean requireAll) {
        GroupTreeNode node;
        if (entries == null || entries.length == 0) {
            this.groupsTree.setHighlight3Cells(null);
            this.groupsTree.revalidate();
            return;
        }
        Vector<GroupTreeNode> vec = new Vector<GroupTreeNode>();
        Enumeration<GroupTreeNode> e = this.groupsRoot.preorderEnumeration();
        while (e.hasMoreElements()) {
            int i;
            node = e.nextElement();
            AbstractGroup group = node.getGroup();
            for (i = 0; i < entries.length; ++i) {
                if (requireAll) {
                    if (group.contains(entries[i])) continue;
                    break;
                }
                if (!group.contains(entries[i])) continue;
                vec.add(node);
            }
            if (!requireAll || i < entries.length) continue;
            vec.add(node);
        }
        this.groupsTree.setHighlight3Cells(vec.toArray());
        for (int i = 0; i < vec.size(); ++i) {
            node = (GroupTreeNode)((GroupTreeNode)vec.elementAt(i)).getParent();
            if (node == null) continue;
            this.groupsTree.expandPath(new TreePath(node.getPath()));
        }
        this.groupsTree.revalidate();
    }

    protected void showOverlappingGroups(List<BibtexEntry> matches) {
        Vector<GroupTreeNode> vec = new Vector<GroupTreeNode>();
        HashMap<String, String> dummyMap = new HashMap<String, String>();
        Enumeration<GroupTreeNode> e = this.groupsRoot.depthFirstEnumeration();
        block0: while (e.hasMoreElements()) {
            GroupTreeNode node = e.nextElement();
            SearchRule rule = node.getSearchRule();
            for (BibtexEntry entry : matches) {
                if (rule.applyRule(dummyMap, entry) == 0) continue;
                vec.add(node);
                continue block0;
            }
        }
        this.groupsTree.setHighlight2Cells(vec.toArray());
    }

    public GroupsTree getGroupsTree() {
        return this.groupsTree;
    }

    private class MoveNodeRightAction
    extends NodeAction {
        public MoveNodeRightAction() {
            super(Globals.lang("Right"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            GroupSelector.this.moveNodeRight(node, false);
        }
    }

    private class MoveNodeLeftAction
    extends NodeAction {
        public MoveNodeLeftAction() {
            super(Globals.lang("Left"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            GroupSelector.this.moveNodeLeft(node, false);
        }
    }

    private class MoveNodeDownAction
    extends NodeAction {
        public MoveNodeDownAction() {
            super(Globals.lang("Down"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            GroupSelector.this.moveNodeDown(node, false);
        }
    }

    private class MoveNodeUpAction
    extends NodeAction {
        public MoveNodeUpAction() {
            super(Globals.lang("Up"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            GroupSelector.this.moveNodeUp(node, false);
        }
    }

    private class CollapseSubtreeAction
    extends NodeAction {
        public CollapseSubtreeAction() {
            super(Globals.lang("Collapse subtree"));
        }

        public void actionPerformed(ActionEvent ae) {
            GroupTreeNode node = this.getNodeToUse();
            TreePath path = new TreePath(node.getPath());
            GroupSelector.this.groupsTree.collapseSubtree((GroupTreeNode)path.getLastPathComponent());
            GroupSelector.this.revalidateGroups();
        }
    }

    private class ExpandSubtreeAction
    extends NodeAction {
        public ExpandSubtreeAction() {
            super(Globals.lang("Expand subtree"));
        }

        public void actionPerformed(ActionEvent ae) {
            GroupTreeNode node = this.getNodeToUse();
            TreePath path = new TreePath(node.getPath());
            GroupSelector.this.groupsTree.expandSubtree((GroupTreeNode)path.getLastPathComponent());
            GroupSelector.this.revalidateGroups();
        }
    }

    private class SortAllSubgroupsAction
    extends NodeAction {
        public SortAllSubgroupsAction() {
            super(Globals.lang("All subgroups (recursively)"));
        }

        public void actionPerformed(ActionEvent ae) {
            GroupTreeNode node = this.getNodeToUse();
            UndoableModifySubtree undo = new UndoableModifySubtree(GroupSelector.this, GroupSelector.this.getGroupTreeRoot(), node, Globals.lang("sort subgroups"));
            GroupSelector.this.groupsTree.sort(node, true);
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Sorted all subgroups recursively."));
        }
    }

    private class SortDirectSubgroupsAction
    extends NodeAction {
        public SortDirectSubgroupsAction() {
            super(Globals.lang("Immediate subgroups"));
        }

        public void actionPerformed(ActionEvent ae) {
            GroupTreeNode node = this.getNodeToUse();
            UndoableModifySubtree undo = new UndoableModifySubtree(GroupSelector.this, GroupSelector.this.getGroupTreeRoot(), node, Globals.lang("sort subgroups"));
            GroupSelector.this.groupsTree.sort(node, false);
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Sorted immediate subgroups."));
        }
    }

    private class RemoveGroupKeepSubgroupsAction
    extends NodeAction {
        public RemoveGroupKeepSubgroupsAction() {
            super(Globals.lang("Remove group, keep subgroups"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            AbstractGroup group = node.getGroup();
            int conf = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove group \"%0\"?", group.getName()), Globals.lang("Remove group"), 0);
            if (conf == 0) {
                UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, node, 1);
                GroupTreeNode parent = (GroupTreeNode)node.getParent();
                int childIndex = parent.getIndex(node);
                node.removeFromParent();
                while (node.getChildCount() > 0) {
                    parent.insert((GroupTreeNode)node.getFirstChild(), childIndex);
                }
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed group \"%0\".", group.getName()));
            }
        }
    }

    private class RemoveSubgroupsAction
    extends NodeAction {
        public RemoveSubgroupsAction() {
            super(Globals.lang("Remove all subgroups"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            AbstractGroup group = node.getGroup();
            int conf = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove all subgroups of \"%0\"?", group.getName()), Globals.lang("Remove all subgroups"), 0);
            if (conf == 0) {
                UndoableModifySubtree undo = new UndoableModifySubtree(GroupSelector.this, GroupSelector.this.getGroupTreeRoot(), node, "Remove all subgroups");
                node.removeAllChildren();
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed all subgroups of group \"%0\".", group.getName()));
            }
        }
    }

    private class RemoveGroupAndSubgroupsAction
    extends NodeAction {
        public RemoveGroupAndSubgroupsAction() {
            super(Globals.lang("Remove group and subgroups"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            AbstractGroup group = node.getGroup();
            int conf = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove group \"%0\" and its subgroups?", group.getName()), Globals.lang("Remove group and subgroups"), 0);
            if (conf == 0) {
                UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, node, 2);
                node.removeFromParent();
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed group \"%0\" and its subgroups.", group.getName()));
            }
        }
    }

    private class AddSubgroupAction
    extends NodeAction {
        public AddSubgroupAction() {
            super(Globals.lang("Add Subgroup"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            GroupDialog gd = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, null);
            gd.setVisible(true);
            if (!gd.okPressed()) {
                return;
            }
            AbstractGroup newGroup = gd.getResultingGroup();
            GroupTreeNode newNode = new GroupTreeNode(newGroup);
            node.add(newNode);
            UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, newNode, 0);
            GroupSelector.this.revalidateGroups();
            GroupSelector.this.groupsTree.expandPath(new TreePath(node.getPath()));
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Added group \"%0\".", newGroup.getName()));
        }
    }

    private class AddGroupAction
    extends NodeAction {
        public AddGroupAction() {
            super(Globals.lang("Add Group"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            GroupDialog gd = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, null);
            gd.setVisible(true);
            if (!gd.okPressed()) {
                return;
            }
            AbstractGroup newGroup = gd.getResultingGroup();
            GroupTreeNode newNode = new GroupTreeNode(newGroup);
            if (node == null) {
                GroupSelector.this.groupsRoot.add(newNode);
            } else {
                ((GroupTreeNode)node.getParent()).insert(newNode, node.getParent().getIndex(node) + 1);
            }
            UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, newNode, 0);
            GroupSelector.this.revalidateGroups();
            GroupSelector.this.groupsTree.expandPath(new TreePath((node != null ? node : GroupSelector.this.groupsRoot).getPath()));
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Added group \"%0\".", newGroup.getName()));
        }
    }

    private class EditGroupAction
    extends NodeAction {
        public EditGroupAction() {
            super(Globals.lang("Edit group"));
        }

        public void actionPerformed(ActionEvent e) {
            GroupTreeNode node = this.getNodeToUse();
            AbstractGroup oldGroup = node.getGroup();
            GroupDialog gd = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, oldGroup);
            gd.setVisible(true);
            if (gd.okPressed()) {
                AbstractGroup newGroup = gd.getResultingGroup();
                AbstractUndoableEdit undoAddPreviousEntries = gd.getUndoForAddPreviousEntries();
                UndoableModifyGroup undo = new UndoableModifyGroup(GroupSelector.this, GroupSelector.this.groupsRoot, node, newGroup);
                node.setGroup(newGroup);
                GroupSelector.this.revalidateGroups(node);
                if (undoAddPreviousEntries == null) {
                    ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undo);
                } else {
                    NamedCompound nc = new NamedCompound("Modify Group");
                    nc.addEdit(undo);
                    nc.addEdit(undoAddPreviousEntries);
                    nc.end();
                    ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(nc);
                }
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Modified group \"%0\".", newGroup.getName()));
            }
        }
    }

    private abstract class NodeAction
    extends AbstractAction {
        protected GroupTreeNode m_node;

        public NodeAction(String s) {
            super(s);
            this.m_node = null;
        }

        public GroupTreeNode getNode() {
            return this.m_node;
        }

        public void setNode(GroupTreeNode node) {
            this.m_node = node;
        }

        public GroupTreeNode getNodeToUse() {
            if (this.m_node != null) {
                return this.m_node;
            }
            TreePath path = GroupSelector.this.groupsTree.getSelectionPath();
            if (path != null) {
                return (GroupTreeNode)path.getLastPathComponent();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupingWorker
    extends AbstractWorker {
        private SearchRuleSet rules;
        private Hashtable<String, String> searchTerm;
        private ArrayList<BibtexEntry> matches = new ArrayList();
        private boolean showOverlappingGroupsP;
        int hits = 0;

        public GroupingWorker(SearchRuleSet rules, Hashtable<String, String> searchTerm) {
            this.rules = rules;
            this.searchTerm = searchTerm;
            this.showOverlappingGroupsP = GroupSelector.this.showOverlappingGroups.isSelected();
        }

        @Override
        public void run() {
            for (BibtexEntry entry : GroupSelector.this.panel.getDatabase().getEntries()) {
                boolean hit = this.rules.applyRule(this.searchTerm, entry) > 0;
                entry.setGroupHit(hit);
                if (!hit) continue;
                ++this.hits;
                if (!this.showOverlappingGroupsP) continue;
                this.matches.add(entry);
            }
        }

        @Override
        public void update() {
            if (GroupSelector.this.hideNonHits.isSelected()) {
                ((GroupSelector)GroupSelector.this).panel.mainTable.stopShowingFloatGrouping();
                GroupSelector.this.panel.setGroupMatcher(GroupMatcher.INSTANCE);
            } else if (GroupSelector.this.grayOut.isSelected()) {
                GroupSelector.this.panel.stopShowingGroup();
                ((GroupSelector)GroupSelector.this).panel.mainTable.showFloatGrouping(GroupMatcher.INSTANCE);
            }
            if (this.showOverlappingGroupsP) {
                GroupSelector.this.showOverlappingGroups(this.matches);
            }
            GroupSelector.this.frame.output(Globals.lang("Updated group selection") + ".");
        }
    }
}

