/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.TransferableFileLinkSelection;
import net.sf.jabref.groups.TransferableEntrySelection;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.imports.ImportMenuItem;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.net.URLDownload;
import spl.PdfImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryTableTransferHandler
extends TransferHandler {
    protected final MainTable entryTable;
    protected JabRefFrame frame;
    private BasePanel panel;
    protected DataFlavor urlFlavor;
    protected DataFlavor stringFlavor;
    protected static boolean DROP_ALLOWED = true;
    boolean draggingFile = false;

    public EntryTableTransferHandler(MainTable entryTable, JabRefFrame frame, BasePanel panel) {
        this.entryTable = entryTable;
        this.frame = frame;
        this.panel = panel;
        this.stringFlavor = DataFlavor.stringFlavor;
        try {
            this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException e) {
            Globals.logger("Unable to configure drag and drop for main table");
            e.printStackTrace();
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000000;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        if (!this.draggingFile) {
            return new TransferableEntrySelection(this.entryTable.getSelectedEntries());
        }
        this.draggingFile = false;
        return new TransferableFileLinkSelection(this.panel, this.entryTable.getSelectedEntries());
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        int dropRow = -1;
        if (comp instanceof JTable) {
            dropRow = ((JTable)comp).getSelectedRow();
        }
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                return this.handleDraggedFiles(l, dropRow);
            }
            if (t.isDataFlavorSupported(this.urlFlavor)) {
                URL dropLink = (URL)t.getTransferData(this.urlFlavor);
                return this.handleDropTransfer(dropLink, dropRow);
            }
            if (t.isDataFlavorSupported(this.stringFlavor)) {
                String dropStr = (String)t.getTransferData(this.stringFlavor);
                return this.handleDropTransfer(dropStr, dropRow);
            }
        }
        catch (IOException ioe) {
            System.err.println("failed to read dropped data: " + ioe.toString());
        }
        catch (UnsupportedFlavorException ufe) {
            System.err.println("drop type error: " + ufe.toString());
        }
        System.err.println("can't transfer input: ");
        DataFlavor[] inflavs = t.getTransferDataFlavors();
        for (int i = 0; i < inflavs.length; ++i) {
            System.out.println("  " + inflavs[i].toString());
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (!DROP_ALLOWED) {
            return false;
        }
        for (int i = 0; i < transferFlavors.length; ++i) {
            DataFlavor inflav = transferFlavors[i];
            if (!inflav.match(this.urlFlavor) && !inflav.match(this.stringFlavor) && !inflav.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            int col = this.entryTable.columnAtPoint(me.getPoint());
            String[] res = this.entryTable.getIconTypeForColumn(col);
            if (res == null) {
                super.exportAsDrag(comp, e, 0x40000000);
                return;
            }
            if (res == MainTableFormat.FILE) {
                System.out.println("dragging file");
                this.draggingFile = true;
            }
        }
        super.exportAsDrag(comp, e, 0x40000000);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        super.exportDone(source, data, action);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        super.exportToClipboard(comp, clip, action);
    }

    protected boolean handleDropTransfer(String dropStr, int dropRow) throws IOException {
        if (dropStr.startsWith("file:")) {
            if (this.handleDraggedFilenames(dropStr, dropRow)) {
                return true;
            }
        } else if (dropStr.startsWith("http:")) {
            URL url = new URL(dropStr);
            return this.handleDropTransfer(url, dropRow);
        }
        File tmpfile = File.createTempFile("jabrefimport", "");
        tmpfile.deleteOnExit();
        FileWriter fw = new FileWriter(tmpfile);
        fw.write(dropStr);
        fw.close();
        ImportMenuItem importer = new ImportMenuItem(this.frame, false);
        importer.automatedImport(new String[]{tmpfile.getAbsolutePath()});
        return true;
    }

    public static List<File> getFilesFromDraggedFilesString(String s) {
        String[] lines = s.replaceAll("\r", "").split("\n");
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < lines.length; ++i) {
            File f;
            String line = lines[i];
            File fl = null;
            try {
                URL url = new URL(line);
                fl = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (fl != null) {
                line = fl.getPath();
            } else {
                if (!line.startsWith("file:")) continue;
                line = line.substring(5);
            }
            if (line.startsWith("//")) {
                line = line.substring(2);
            }
            if (!(f = new File(line)).exists()) continue;
            files.add(f);
        }
        return files;
    }

    private boolean handleDraggedFilenames(String s, int dropRow) {
        return this.handleDraggedFiles(EntryTableTransferHandler.getFilesFromDraggedFilesString(s), dropRow);
    }

    private boolean handleDraggedFiles(List<File> files, final int dropRow) {
        final String[] fileNames = new String[files.size()];
        int i = 0;
        for (File file : files) {
            fileNames[i] = file.getAbsolutePath();
            ++i;
        }
        new Thread(new Runnable(){

            public void run() {
                String[] newfileNames = new PdfImporter(EntryTableTransferHandler.this.frame, EntryTableTransferHandler.this.panel, EntryTableTransferHandler.this.entryTable, dropRow).importPdfFiles(fileNames, (OutputPrinter)EntryTableTransferHandler.this.frame);
                if (newfileNames.length > 0) {
                    EntryTableTransferHandler.this.loadOrImportFiles(newfileNames, dropRow);
                }
            }
        }).start();
        return true;
    }

    private void loadOrImportFiles(String[] fileNames, int dropRow) {
        OpenDatabaseAction openAction = new OpenDatabaseAction(this.frame, false);
        ArrayList<String> notBibFiles = new ArrayList<String>();
        String encoding = Globals.prefs.get("defaultEncoding");
        for (int i = 0; i < fileNames.length; ++i) {
            String extension = "";
            ExternalFileType fileType = null;
            int index = fileNames[i].lastIndexOf(46);
            if (index >= 0 && index < fileNames[i].length()) {
                extension = fileNames[i].substring(index + 1).toLowerCase();
                fileType = Globals.prefs.getExternalFileTypeByExt(extension);
            }
            if (extension.equals("bib")) {
                File f = new File(fileNames[i]);
                try {
                    ParserResult pr = OpenDatabaseAction.loadDatabase(f, encoding);
                    if (pr == null || pr == ParserResult.INVALID_FORMAT) {
                        notBibFiles.add(fileNames[i]);
                        continue;
                    }
                    openAction.addNewDatabase(pr, f, true);
                    this.frame.getFileHistory().newFile(fileNames[i]);
                }
                catch (IOException e) {
                    notBibFiles.add(fileNames[i]);
                }
                continue;
            }
            if (fileType != null && dropRow >= 0) {
                boolean local = true;
                DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                dfh.handleDroppedfile(fileNames[i], fileType, local, this.entryTable, dropRow);
                continue;
            }
            notBibFiles.add(fileNames[i]);
        }
        if (notBibFiles.size() > 0) {
            String[] toImport = new String[notBibFiles.size()];
            notBibFiles.toArray(toImport);
            ImportMenuItem importer = new ImportMenuItem(this.frame, this.entryTable == null);
            importer.automatedImport(toImport);
        }
    }

    protected boolean handleDropTransfer(URL dropLink, int dropRow) throws IOException {
        File tmpfile = File.createTempFile("jabrefimport", "");
        tmpfile.deleteOnExit();
        new URLDownload(this.entryTable, dropLink, tmpfile).download();
        ImportMenuItem importer = new ImportMenuItem(this.frame, this.entryTable == null);
        importer.automatedImport(new String[]{tmpfile.getAbsolutePath()});
        return true;
    }
}

