/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToEmacs
implements PushToApplication {
    private JPanel settings = null;
    private JTextField citeCommand = new JTextField(30);
    private JTextField emacsPath = new JTextField(30);
    private JTextField additionalParams = new JTextField(30);
    private JCheckBox useEmacs23 = new JCheckBox();
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    public String getName() {
        return Globals.menuTitle("Insert selected citations into Emacs");
    }

    public String getApplicationName() {
        return "Emacs";
    }

    public String getTooltip() {
        return Globals.lang("Push selection to Emacs");
    }

    public Icon getIcon() {
        return GUIGlobals.getImage("emacs");
    }

    public String getKeyStrokeName() {
        return "Push to Emacs";
    }

    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.citeCommand.setText(Globals.prefs.get("citeCommandEmacs"));
        this.emacsPath.setText(Globals.prefs.get("emacsPath"));
        this.additionalParams.setText(Globals.prefs.get("emacsParameters"));
        this.useEmacs23.setSelected(Globals.prefs.getBoolean("emacsUseV23InsertString"));
        return this.settings;
    }

    public void storeSettings() {
        Globals.prefs.put("citeCommandEmacs", this.citeCommand.getText());
        Globals.prefs.put("emacsPath", this.emacsPath.getText());
        Globals.prefs.put("emacsParameters", this.additionalParams.getText());
        Globals.prefs.putBoolean("emacsUseV23InsertString", this.useEmacs23.isSelected());
    }

    private void initSettingsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        builder.append(new JLabel(Globals.lang("Path to gnuclient or emacsclient").concat(":")));
        builder.append(this.emacsPath);
        BrowseAction action = new BrowseAction(null, this.emacsPath, false);
        JButton browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(action);
        builder.append(browse);
        builder.nextLine();
        builder.append(Globals.lang("Additional parameters").concat(":"));
        builder.append(this.additionalParams);
        builder.nextLine();
        builder.append(Globals.lang("Use EMACS 23 insertion string").concat(":"));
        builder.append(this.useEmacs23);
        builder.nextLine();
        builder.append(Globals.lang("Cite command") + ":");
        builder.append(this.citeCommand);
        this.settings = builder.getPanel();
    }

    public void pushEntries(BibtexDatabase database, BibtexEntry[] entries, String keys, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        String command = Globals.prefs.get("emacsPath");
        String[] addParams = Globals.prefs.get("emacsParameters").split(" ");
        try {
            String suffix;
            String prefix;
            String[] com = new String[addParams.length + 2];
            com[0] = command;
            for (int i = 0; i < addParams.length; ++i) {
                com[i + 1] = addParams[i];
            }
            if (Globals.prefs.getBoolean("emacsUseV23InsertString")) {
                prefix = "(with-current-buffer (window-buffer) (insert ";
                suffix = "))";
            } else {
                prefix = "(insert ";
                suffix = ")";
            }
            com[com.length - 1] = Globals.ON_WIN ? prefix.concat("\\\"\\" + Globals.prefs.get("citeCommandEmacs").replaceAll("\\\\", "\\\\\\\\") + "{" + keys + "}\\\"").concat(suffix) : prefix.concat("\"" + Globals.prefs.get("citeCommandEmacs").replaceAll("\\\\", "\\\\\\\\") + "{" + keys + "}\"").concat(suffix);
            final Process p = Runtime.getRuntime().exec(com);
            Runnable errorListener = new Runnable(){

                public void run() {
                    InputStream out = p.getErrorStream();
                    StringBuffer sb = new StringBuffer();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (sb.toString().trim().length() > 0) {
                        System.out.println(sb.toString());
                        PushToEmacs.this.couldNotConnect = true;
                        return;
                    }
                }
            };
            Thread t = new Thread(errorListener);
            t.start();
            t.join();
        }
        catch (IOException excep) {
            this.couldNotRunClient = true;
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(panel.frame(), "<HTML>" + Globals.lang("Could not connect to a running gnuserv process. Make sure that Emacs or XEmacs is running,<BR>and that the server has been started (by running the command 'server-start'/'gnuserv-start').") + "</HTML>", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            JOptionPane.showMessageDialog(panel.frame(), Globals.lang("Could not run the gnuclient/emacsclient program. Make sure you have the emacsclient/gnuclient program installed and available in the PATH."), Globals.lang("Error"), 0);
        } else {
            panel.output(Globals.lang("Pushed citations to Emacs"));
        }
    }

    public boolean requiresBibtexKeys() {
        return true;
    }
}

