/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.export.layout.AbstractParamLayoutFormatter;

public class Authors
extends AbstractParamLayoutFormatter {
    static ArrayList<String> authorOrder = new ArrayList();
    static ArrayList<String> authorAbbr = new ArrayList();
    static ArrayList<String> authorPunc = new ArrayList();
    static ArrayList<String> separators = new ArrayList();
    static ArrayList<String> lastSeparators = new ArrayList();
    static Pattern numberPattern = Pattern.compile("[0-9]+");
    static final int FIRST_FIRST = 0;
    static final int LAST_FIRST = 1;
    static final int LF_FF = 2;
    static final String COMMA = ", ";
    static final String AMP = " & ";
    static final String COLON = ": ";
    static final String SEMICOLON = "; ";
    static final String AND = " and ";
    static final String OXFORD = ", and ";
    int flMode = 0;
    boolean abbreviate = true;
    boolean firstInitialOnly = false;
    boolean middleInitial = false;
    boolean lastNameOnly = false;
    boolean abbrDots = true;
    boolean abbrSpaces = true;
    boolean setSep = false;
    boolean setMaxAuthors = false;
    int maxAuthors = -1;
    int authorNumberEtAl = 1;
    String firstFirstSeparator = " ";
    String lastFirstSeparator = ", ";
    String separator = ", ";
    String lastSeparator = " and ";
    String etAlString = " et al.";
    String jrSeparator = " ";

    public void setArgument(String arg) {
        String[] parts = Authors.parseArgument(arg);
        for (int i = 0; i < parts.length; ++i) {
            int index = parts[i].indexOf("=");
            if (index > 0) {
                String key = parts[i].substring(0, index);
                String value = parts[i].substring(index + 1);
                this.handleArgument(key, value);
                continue;
            }
            this.handleArgument(parts[i], "");
        }
    }

    private void handleArgument(String key, String value) {
        if (authorOrder.contains(key.trim().toLowerCase())) {
            if (this.comp(key, "FirstFirst")) {
                this.flMode = 0;
            } else if (this.comp(key, "LastFirst")) {
                this.flMode = 1;
            } else if (this.comp(key, "LastFirstFirstFirst")) {
                this.flMode = 2;
            }
        } else if (authorAbbr.contains(key.trim().toLowerCase())) {
            if (this.comp(key, "FullName")) {
                this.abbreviate = false;
            } else if (this.comp(key, "Initials")) {
                this.abbreviate = true;
                this.firstInitialOnly = false;
            } else if (this.comp(key, "FirstInitial")) {
                this.abbreviate = true;
                this.firstInitialOnly = true;
            } else if (this.comp(key, "MiddleInitial")) {
                this.abbreviate = true;
                this.middleInitial = true;
            } else if (this.comp(key, "LastName")) {
                this.lastNameOnly = true;
            } else if (this.comp(key, "InitialsNoSpace")) {
                this.abbreviate = true;
                this.abbrSpaces = false;
            }
        } else if (authorPunc.contains(key.trim().toLowerCase())) {
            if (this.comp(key, "FullPunc")) {
                this.abbrDots = true;
                this.lastFirstSeparator = COMMA;
            } else if (this.comp(key, "NoPunc")) {
                this.abbrDots = false;
                this.lastFirstSeparator = " ";
            } else if (this.comp(key, "NoComma")) {
                this.abbrDots = true;
                this.lastFirstSeparator = " ";
            } else if (this.comp(key, "NoPeriod")) {
                this.abbrDots = false;
                this.lastFirstSeparator = COMMA;
            }
        } else if (separators.contains(key.trim().toLowerCase()) || lastSeparators.contains(key.trim().toLowerCase())) {
            if (this.comp(key, "Comma")) {
                if (!this.setSep) {
                    this.separator = COMMA;
                    this.setSep = true;
                } else {
                    this.lastSeparator = COMMA;
                }
            } else if (this.comp(key, "And")) {
                if (!this.setSep) {
                    this.separator = AND;
                    this.setSep = true;
                } else {
                    this.lastSeparator = AND;
                }
            } else if (this.comp(key, "Colon")) {
                if (!this.setSep) {
                    this.separator = COLON;
                    this.setSep = true;
                } else {
                    this.lastSeparator = COLON;
                }
            } else if (this.comp(key, "Semicolon")) {
                if (!this.setSep) {
                    this.separator = SEMICOLON;
                    this.setSep = true;
                } else {
                    this.lastSeparator = SEMICOLON;
                }
            } else if (this.comp(key, "Oxford")) {
                this.lastSeparator = OXFORD;
            } else if (this.comp(key, "Amp")) {
                this.lastSeparator = AMP;
            } else if (this.comp(key, "Sep") && value.length() > 0) {
                this.separator = value;
                this.setSep = true;
            } else if (this.comp(key, "LastSep") && value.length() > 0) {
                this.lastSeparator = value;
            }
        } else if (key.trim().toLowerCase().equals("etal") && value.length() > 0) {
            this.etAlString = value;
        } else if (numberPattern.matcher(key.trim()).matches()) {
            int num = Integer.parseInt(key.trim());
            if (!this.setMaxAuthors) {
                this.maxAuthors = num;
                this.setMaxAuthors = true;
            } else {
                this.authorNumberEtAl = num;
            }
        }
    }

    public boolean comp(String one, String two) {
        return one.trim().equalsIgnoreCase(two);
    }

    public String format(String fieldText) {
        StringBuilder sb = new StringBuilder();
        AuthorList al = AuthorList.getAuthorList(fieldText);
        if (this.maxAuthors < 0 || al.size() <= this.maxAuthors) {
            for (int i = 0; i < al.size(); ++i) {
                AuthorList.Author a = al.getAuthor(i);
                this.addSingleName(sb, a, this.flMode == 0 || this.flMode == 2 && i > 0);
                if (i < al.size() - 2) {
                    sb.append(this.separator);
                    continue;
                }
                if (i >= al.size() - 1) continue;
                sb.append(this.lastSeparator);
            }
        } else {
            for (int i = 0; i < Math.min(al.size() - 1, this.authorNumberEtAl); ++i) {
                if (i > 0) {
                    sb.append(this.separator);
                }
                this.addSingleName(sb, al.getAuthor(i), this.flMode == 0);
            }
            sb.append(this.etAlString);
        }
        return sb.toString();
    }

    private void addSingleName(StringBuilder sb, AuthorList.Author a, boolean firstFirst) {
        String jr;
        String firstNamePart = a.getFirst();
        String lastNamePart = a.getLast();
        String von = a.getVon();
        if (von != null && von.length() > 0) {
            lastNamePart = von + " " + lastNamePart;
        }
        if ((jr = a.getJr()) != null && jr.length() > 0) {
            lastNamePart = lastNamePart + this.jrSeparator + jr;
        }
        if (this.abbreviate && firstNamePart != null) {
            firstNamePart = a.getFirstAbbr();
            if (this.firstInitialOnly && firstNamePart.length() > 2) {
                firstNamePart = firstNamePart.substring(0, 2);
            } else if (this.middleInitial) {
                String abbr = firstNamePart;
                firstNamePart = a.getFirst();
                int index = firstNamePart.indexOf(" ");
                if (index >= 0) {
                    firstNamePart = firstNamePart.substring(0, index + 1);
                    if (abbr.length() > 3) {
                        firstNamePart = firstNamePart + abbr.substring(3);
                    }
                }
            }
            if (!this.abbrDots) {
                firstNamePart = firstNamePart.replaceAll("\\.", "");
            }
            if (!this.abbrSpaces) {
                firstNamePart = firstNamePart.replaceAll(" ", "");
            }
        }
        if (this.lastNameOnly || firstNamePart == null) {
            sb.append(lastNamePart);
        } else if (firstFirst) {
            sb.append(firstNamePart).append(this.firstFirstSeparator);
            sb.append(lastNamePart);
        } else {
            sb.append(lastNamePart).append(this.lastFirstSeparator).append(firstNamePart);
        }
    }

    public static void main(String[] args) {
        Authors format = new Authors();
        format.setArgument("lastfirstfirstfirst , initials,  Nocomma,Amp,Semicolon,30 ,EtAl = m.fl.");
        System.out.println(format.format("Alfredsen, Jr, Jo Arve and Morten Omholt Alver and Yngvar von Olsen and Sebastian A. L. M. Kooijman"));
    }

    static {
        authorOrder.add("firstfirst");
        authorOrder.add("lastfirst");
        authorOrder.add("lastfirstfirstfirst");
        authorAbbr.add("fullname");
        authorAbbr.add("initials");
        authorAbbr.add("firstinitial");
        authorAbbr.add("middleinitial");
        authorAbbr.add("lastname");
        authorAbbr.add("initialsnospace");
        authorPunc.add("fullpunc");
        authorPunc.add("nopunc");
        authorPunc.add("nocomma");
        authorPunc.add("noperiod");
        separators.add("comma");
        separators.add("and");
        separators.add("colon");
        separators.add("semicolon");
        separators.add("sep");
        lastSeparators.add("and");
        lastSeparators.add("colon");
        lastSeparators.add("semicolon");
        lastSeparators.add("amp");
        lastSeparators.add("oxford");
        lastSeparators.add("lastsep");
    }
}

