/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;

public class AutoSaveManager {
    private JabRefFrame frame;
    private Timer t = null;
    private TimerTask task = null;

    public AutoSaveManager(JabRefFrame frame) {
        this.frame = frame;
    }

    public void startAutoSaveTimer() {
        this.task = new AutoSaveTask();
        this.t = new Timer();
        long interval = 60000 * Globals.prefs.getInt("autoSaveInterval");
        this.t.scheduleAtFixedRate(this.task, interval, interval);
    }

    public void stopAutoSaveTimer() {
        this.t.cancel();
    }

    public static File getAutoSaveFile(File f) {
        String n = f.getName();
        return new File(f.getParentFile(), ".$" + n + "$");
    }

    public static boolean autoSave(BasePanel panel) {
        File backupFile = AutoSaveManager.getAutoSaveFile(panel.getFile());
        try {
            SaveSession ss = FileActions.saveDatabase(panel.database(), panel.metaData(), backupFile, Globals.prefs, false, false, panel.getEncoding(), true);
            ss.commit();
        }
        catch (SaveException e) {
            e.printStackTrace();
            return false;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean deleteAutoSaveFile(BasePanel panel) {
        if (panel.getFile() == null) {
            return true;
        }
        File backupFile = AutoSaveManager.getAutoSaveFile(panel.getFile());
        if (backupFile.exists()) {
            return backupFile.delete();
        }
        return true;
    }

    public void clearAutoSaves() {
        ArrayList<BasePanel> panels = new ArrayList<BasePanel>();
        for (int i = 0; i < this.frame.baseCount(); ++i) {
            panels.add(this.frame.baseAt(i));
        }
        for (BasePanel panel : panels) {
            AutoSaveManager.deleteAutoSaveFile(panel);
        }
    }

    public static boolean newerAutoSaveExists(File f) {
        File asFile = AutoSaveManager.getAutoSaveFile(f);
        return asFile.exists() && asFile.lastModified() > f.lastModified();
    }

    class AutoSaveTask
    extends TimerTask {
        AutoSaveTask() {
        }

        public void run() {
            int i;
            ArrayList<BasePanel> panels = new ArrayList<BasePanel>();
            for (i = 0; i < AutoSaveManager.this.frame.baseCount(); ++i) {
                panels.add(AutoSaveManager.this.frame.baseAt(i));
            }
            i = 0;
            for (BasePanel panel : panels) {
                if (panel.isBaseChanged() && panel.getFile() != null) {
                    AutoSaveManager.autoSave(panel);
                }
                ++i;
            }
        }
    }
}

