/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveString;

public class StringRemoveChange
extends Change {
    BibtexString string;
    BibtexString inMem;
    InfoPane tp = new InfoPane();
    JScrollPane sp = new JScrollPane(this.tp);
    private BibtexString tmpString;

    public StringRemoveChange(BibtexString string, BibtexString tmpString, BibtexString inMem) {
        this.tmpString = tmpString;
        this.name = Globals.lang("Removed string") + ": '" + string.getName() + "'";
        this.string = string;
        this.inMem = inMem;
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML><H2>");
        sb.append(Globals.lang("Removed string"));
        sb.append("</H2><H3>");
        sb.append(Globals.lang("Label")).append(":</H3>");
        sb.append(string.getName());
        sb.append("<H3>");
        sb.append(Globals.lang("Content")).append(":</H3>");
        sb.append(string.getContent());
        sb.append("</HTML>");
        this.tp.setText(sb.toString());
    }

    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        try {
            panel.database().removeString(this.inMem.getId());
            undoEdit.addEdit(new UndoableRemoveString(panel, panel.database(), this.string));
        }
        catch (Exception ex) {
            Globals.logger("Error: could not add string '" + this.string.getName() + "': " + ex.getMessage());
        }
        secondary.removeString(this.tmpString.getId());
        return true;
    }

    JComponent description() {
        return this.sp;
    }
}

