/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;

public class ChangeDisplayDialog
extends JDialog
implements TreeSelectionListener {
    private BibtexDatabase secondary;
    DefaultMutableTreeNode root;
    JTree tree;
    JPanel infoPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel infoBorder = new JPanel();
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JCheckBox cb = new JCheckBox(Globals.lang("Accept change"));
    JLabel rootInfo = new JLabel(Globals.lang("Select the tree nodes to view and accept or reject changes") + ".");
    Change selected = null;
    JComponent infoShown = null;
    private boolean okPressed = false;

    public ChangeDisplayDialog(JFrame owner, final BasePanel panel, BibtexDatabase secondary, final DefaultMutableTreeNode root) {
        super(owner, Globals.lang("External changes"), true);
        this.secondary = secondary;
        if (secondary == null) {
            this.secondary = new BibtexDatabase();
        }
        this.root = root;
        this.tree = new JTree(root);
        this.tree.addTreeSelectionListener(this);
        JSplitPane pane = new JSplitPane();
        pane.setLeftComponent(new JScrollPane(this.tree));
        pane.setRightComponent(this.infoBorder);
        this.cb.setMargin(new Insets(2, 2, 2, 2));
        this.cb.setEnabled(false);
        this.infoPanel.setLayout(new BorderLayout());
        this.infoBorder.setLayout(new BorderLayout());
        this.infoBorder.setBorder(BorderFactory.createEtchedBorder());
        this.infoBorder.add((Component)this.infoPanel, "Center");
        this.setInfo(this.rootInfo);
        this.infoPanel.add((Component)this.cb, "South");
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.cb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ChangeDisplayDialog.this.selected != null) {
                    ChangeDisplayDialog.this.selected.setAccepted(ChangeDisplayDialog.this.cb.isSelected());
                }
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChangeDisplayDialog.this.dispose();
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NamedCompound ce = new NamedCompound(Globals.lang("Merged external changes"));
                Enumeration<TreeNode> enumer = root.children();
                boolean anyDisabled = false;
                while (enumer.hasMoreElements()) {
                    Change c = (Change)enumer.nextElement();
                    boolean allAccepted = false;
                    if (c.isAcceptable() && c.isAccepted()) {
                        allAccepted = c.makeChange(panel, ChangeDisplayDialog.this.secondary, ce);
                    }
                    if (allAccepted) continue;
                    anyDisabled = true;
                }
                ce.end();
                panel.undoManager.addEdit(ce);
                if (anyDisabled) {
                    panel.markBaseChanged();
                }
                panel.setUpdatedExternally(false);
                ChangeDisplayDialog.this.dispose();
                ChangeDisplayDialog.this.okPressed = true;
            }
        });
        this.pack();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void setInfo(JComponent comp) {
        if (this.infoShown != null) {
            this.infoPanel.remove(this.infoShown);
        }
        this.infoShown = comp;
        this.infoPanel.add((Component)this.infoShown, "Center");
        this.infoPanel.revalidate();
        this.infoPanel.repaint();
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object o = this.tree.getLastSelectedPathComponent();
        if (o instanceof Change) {
            this.selected = (Change)o;
            this.setInfo(this.selected.description());
            this.cb.setSelected(this.selected.isAccepted());
            this.cb.setEnabled(this.selected.isAcceptable());
        } else {
            this.setInfo(this.rootInfo);
            this.selected = null;
            this.cb.setEnabled(false);
        }
    }
}

