/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;

public class NameFieldAutoCompleter
extends AbstractAutoCompleter {
    private String[] fieldNames;
    private boolean lastNameOnly;
    private String prefix = "";
    private boolean autoCompFF;
    private boolean autoCompLF;

    protected NameFieldAutoCompleter(String fieldName) {
        this(new String[]{fieldName}, false);
    }

    public NameFieldAutoCompleter(String[] fieldNames, boolean lastNameOnly) {
        this.fieldNames = fieldNames;
        this.lastNameOnly = lastNameOnly;
        if (Globals.prefs.getBoolean("autoCompFF")) {
            this.autoCompFF = true;
            this.autoCompLF = false;
        } else if (Globals.prefs.getBoolean("autoCompLF")) {
            this.autoCompFF = false;
            this.autoCompLF = true;
        } else {
            this.autoCompFF = true;
            this.autoCompLF = true;
        }
    }

    public boolean isSingleUnitField() {
        return true;
    }

    public void addBibtexEntry(String fieldValue, BibtexEntry entry) {
        this.addBibtexEntry(entry);
    }

    public void addBibtexEntry(BibtexEntry entry) {
        if (entry != null) {
            for (int i = 0; i < this.fieldNames.length; ++i) {
                String fieldValue = entry.getField(this.fieldNames[i]);
                if (fieldValue == null) continue;
                AuthorList authorList = AuthorList.getAuthorList(fieldValue);
                for (int j = 0; j < authorList.size(); ++j) {
                    AuthorList.Author author = authorList.getAuthor(j);
                    if (this.lastNameOnly) {
                        this.addWordToIndex(author.getLastOnly());
                        continue;
                    }
                    if (this.autoCompLF) {
                        this.addWordToIndex(author.getLastFirst(true));
                        this.addWordToIndex(author.getLastFirst(false));
                    }
                    if (!this.autoCompFF) continue;
                    this.addWordToIndex(author.getFirstLast(true));
                    this.addWordToIndex(author.getFirstLast(false));
                }
            }
        }
    }

    public String[] complete(String str) {
        int index = str.toLowerCase().lastIndexOf(" and ");
        if (index >= 0) {
            this.prefix = str.substring(0, index + 5);
            str = str.substring(index + 5);
        } else {
            this.prefix = "";
        }
        String[] res = super.complete(str);
        return res;
    }

    public String getFieldName() {
        return this.fieldNames[0];
    }

    public String getPrefix() {
        return this.prefix;
    }
}

