/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class TablePrefsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    private JCheckBox autoResizeMode;
    private JCheckBox priDesc;
    private JCheckBox secDesc;
    private JCheckBox terDesc;
    private JCheckBox floatMarked;
    private JCheckBox pdfColumn;
    private JCheckBox urlColumn;
    private JCheckBox fileColumn;
    private JCheckBox arxivColumn;
    private JRadioButton namesAsIs;
    private JRadioButton namesFf;
    private JRadioButton namesFl;
    private JRadioButton namesNatbib;
    private JRadioButton abbrNames;
    private JRadioButton noAbbrNames;
    private JRadioButton lastNamesOnly;
    private JComboBox priSort;
    private JComboBox secSort;
    private JComboBox terSort;
    private JTextField priField;
    private JTextField secField;
    private JTextField terField;
    private JTextField numericFields;

    public TablePrefsTab(JabRefPreferences prefs, JabRefFrame frame) {
        this._prefs = prefs;
        this.setLayout(new BorderLayout());
        Vector<String> v = new Vector<String>(Arrays.asList(BibtexFields.getAllFieldNames()));
        v.add("bibtexkey");
        Collections.sort(v);
        Object[] allPlusKey = v.toArray();
        this.priSort = new JComboBox<Object>(allPlusKey);
        this.secSort = new JComboBox<Object>(allPlusKey);
        this.terSort = new JComboBox<Object>(allPlusKey);
        this.autoResizeMode = new JCheckBox(Globals.lang("Fit table horizontally on screen"));
        this.namesAsIs = new JRadioButton(Globals.lang("Show names unchanged"));
        this.namesFf = new JRadioButton(Globals.lang("Show 'Firstname Lastname'"));
        this.namesFl = new JRadioButton(Globals.lang("Show 'Lastname, Firstname'"));
        this.namesNatbib = new JRadioButton(Globals.lang("Natbib style"));
        this.noAbbrNames = new JRadioButton(Globals.lang("Do not abbreviate names"));
        this.abbrNames = new JRadioButton(Globals.lang("Abbreviate names"));
        this.lastNamesOnly = new JRadioButton(Globals.lang("Show last names only"));
        this.fileColumn = new JCheckBox(Globals.lang("Show file column"));
        this.pdfColumn = new JCheckBox(Globals.lang("Show PDF/PS column"));
        this.urlColumn = new JCheckBox(Globals.lang("Show URL/DOI column"));
        this.arxivColumn = new JCheckBox(Globals.lang("Show ArXiv column"));
        this.floatMarked = new JCheckBox(Globals.lang("Float marked entries"));
        this.priField = new JTextField(10);
        this.secField = new JTextField(10);
        this.terField = new JTextField(10);
        this.numericFields = new JTextField(30);
        this.priSort.insertItemAt(Globals.lang("<select>"), 0);
        this.secSort.insertItemAt(Globals.lang("<select>"), 0);
        this.terSort.insertItemAt(Globals.lang("<select>"), 0);
        this.priSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TablePrefsTab.this.priSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.priField.setText(TablePrefsTab.this.priSort.getSelectedItem().toString());
                    TablePrefsTab.this.priSort.setSelectedIndex(0);
                }
            }
        });
        this.secSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TablePrefsTab.this.secSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.secField.setText(TablePrefsTab.this.secSort.getSelectedItem().toString());
                    TablePrefsTab.this.secSort.setSelectedIndex(0);
                }
            }
        });
        this.terSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TablePrefsTab.this.terSort.getSelectedIndex() > 0) {
                    TablePrefsTab.this.terField.setText(TablePrefsTab.this.terSort.getSelectedItem().toString());
                    TablePrefsTab.this.terSort.setSelectedIndex(0);
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.namesAsIs);
        bg.add(this.namesNatbib);
        bg.add(this.namesFf);
        bg.add(this.namesFl);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.lastNamesOnly);
        bg2.add(this.abbrNames);
        bg2.add(this.noAbbrNames);
        this.priDesc = new JCheckBox(Globals.lang("Descending"));
        this.secDesc = new JCheckBox(Globals.lang("Descending"));
        this.terDesc = new JCheckBox(Globals.lang("Descending"));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        builder.appendSeparator(Globals.lang("Special table columns"));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.fileColumn);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.pdfColumn);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.urlColumn);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.arxivColumn);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Format of author and editor names"));
        DefaultFormBuilder nameBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 8dlu, left:pref", ""));
        nameBuilder.append(this.namesAsIs);
        nameBuilder.append(this.noAbbrNames);
        nameBuilder.nextLine();
        nameBuilder.append(this.namesFf);
        nameBuilder.append(this.abbrNames);
        nameBuilder.nextLine();
        nameBuilder.append(this.namesFl);
        nameBuilder.append(this.lastNamesOnly);
        nameBuilder.nextLine();
        nameBuilder.append(this.namesNatbib);
        builder.append(pan);
        builder.append(nameBuilder.getPanel());
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Default sort criteria"));
        FormLayout layout2 = new FormLayout("left:pref, 8dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, left:pref", "");
        DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
        JLabel lab = new JLabel(Globals.lang("Primary sort criterion"));
        builder2.append(lab);
        builder2.append(this.priSort);
        builder2.append(this.priField);
        builder2.append(this.priDesc);
        builder2.nextLine();
        lab = new JLabel(Globals.lang("Secondary sort criterion"));
        builder2.append(lab);
        builder2.append(this.secSort);
        builder2.append(this.secField);
        builder2.append(this.secDesc);
        builder2.nextLine();
        lab = new JLabel(Globals.lang("Tertiary sort criterion"));
        builder2.append(lab);
        builder2.append(this.terSort);
        builder2.append(this.terField);
        builder2.append(this.terDesc);
        builder.nextLine();
        builder.append(pan);
        builder.append(builder2.getPanel());
        builder.nextLine();
        builder.append(pan);
        builder.append(this.floatMarked);
        builder.nextLine();
        builder.append(pan);
        builder2 = new DefaultFormBuilder(new FormLayout("left:pref, 8dlu, fill:pref", ""));
        builder2.append(Globals.lang("Sort the following fields as numeric fields") + ":");
        builder2.append(this.numericFields);
        builder.append((Component)builder2.getPanel(), 5);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("General"));
        builder.append(pan);
        builder.append(this.autoResizeMode);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
        this.namesNatbib.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TablePrefsTab.this.abbrNames.setEnabled(!TablePrefsTab.this.namesNatbib.isSelected());
                TablePrefsTab.this.lastNamesOnly.setEnabled(!TablePrefsTab.this.namesNatbib.isSelected());
                TablePrefsTab.this.noAbbrNames.setEnabled(!TablePrefsTab.this.namesNatbib.isSelected());
            }
        });
    }

    public void setValues() {
        this.autoResizeMode.setSelected(this._prefs.getInt("autoResizeMode") == 4);
        this.fileColumn.setSelected(this._prefs.getBoolean("fileColumn"));
        this.pdfColumn.setSelected(this._prefs.getBoolean("pdfColumn"));
        this.urlColumn.setSelected(this._prefs.getBoolean("urlColumn"));
        this.fileColumn.setSelected(this._prefs.getBoolean("fileColumn"));
        this.arxivColumn.setSelected(this._prefs.getBoolean("arxivColumn"));
        this.priField.setText(this._prefs.get("priSort"));
        this.secField.setText(this._prefs.get("secSort"));
        this.terField.setText(this._prefs.get("terSort"));
        this.priSort.setSelectedIndex(0);
        this.secSort.setSelectedIndex(0);
        this.terSort.setSelectedIndex(0);
        if (this._prefs.getBoolean("namesAsIs")) {
            this.namesAsIs.setSelected(true);
        } else if (this._prefs.getBoolean("namesFf")) {
            this.namesFf.setSelected(true);
        } else if (this._prefs.getBoolean("namesNatbib")) {
            this.namesNatbib.setSelected(true);
        } else {
            this.namesFl.setSelected(true);
        }
        if (this._prefs.getBoolean("abbrAuthorNames")) {
            this.abbrNames.setSelected(true);
        } else if (this._prefs.getBoolean("namesLastOnly")) {
            this.lastNamesOnly.setSelected(true);
        } else {
            this.noAbbrNames.setSelected(true);
        }
        this.priDesc.setSelected(this._prefs.getBoolean("priDescending"));
        this.secDesc.setSelected(this._prefs.getBoolean("secDescending"));
        this.terDesc.setSelected(this._prefs.getBoolean("terDescending"));
        this.floatMarked.setSelected(this._prefs.getBoolean("floatMarkedEntries"));
        this.abbrNames.setEnabled(!this.namesNatbib.isSelected());
        this.lastNamesOnly.setEnabled(!this.namesNatbib.isSelected());
        this.noAbbrNames.setEnabled(!this.namesNatbib.isSelected());
        String numF = this._prefs.get("numericFields");
        if (numF == null) {
            this.numericFields.setText("");
        } else {
            this.numericFields.setText(numF);
        }
    }

    public void storeSettings() {
        this._prefs.putBoolean("namesAsIs", this.namesAsIs.isSelected());
        this._prefs.putBoolean("namesFf", this.namesFf.isSelected());
        this._prefs.putBoolean("namesNatbib", this.namesNatbib.isSelected());
        this._prefs.putBoolean("namesLastOnly", this.lastNamesOnly.isSelected());
        this._prefs.putBoolean("abbrAuthorNames", this.abbrNames.isSelected());
        this._prefs.putBoolean("fileColumn", this.fileColumn.isSelected());
        this._prefs.putBoolean("pdfColumn", this.pdfColumn.isSelected());
        this._prefs.putBoolean("urlColumn", this.urlColumn.isSelected());
        this._prefs.putBoolean("arxivColumn", this.arxivColumn.isSelected());
        this._prefs.putInt("autoResizeMode", this.autoResizeMode.isSelected() ? 4 : 0);
        this._prefs.putBoolean("priDescending", this.priDesc.isSelected());
        this._prefs.putBoolean("secDescending", this.secDesc.isSelected());
        this._prefs.putBoolean("terDescending", this.terDesc.isSelected());
        this._prefs.put("priSort", this.priField.getText().toLowerCase().trim());
        this._prefs.put("secSort", this.secField.getText().toLowerCase().trim());
        this._prefs.put("terSort", this.terField.getText().toLowerCase().trim());
        this._prefs.putBoolean("floatMarkedEntries", this.floatMarked.isSelected());
        String oldVal = this._prefs.get("numericFields");
        String newVal = this.numericFields.getText().trim();
        if (newVal.length() == 0) {
            newVal = null;
        }
        if (newVal != null && oldVal == null || newVal == null && oldVal != null || newVal != null && !newVal.equals(oldVal)) {
            this._prefs.put("numericFields", newVal);
            BibtexFields.setNumericFieldsFromPrefs();
        }
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("Entry table");
    }
}

