/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.PrefsTab;

public class ImportSettingsTab
extends JPanel
implements PrefsTab {
    public static final String PREF_IMPORT_ALWAYSUSE = "importAlwaysUsePDFImportStyle";
    public static final String PREF_IMPORT_DEFAULT_PDF_IMPORT_STYLE = "importDefaultPDFimportStyle";
    public static final int DEFAULT_STYLE = 2;
    public static final String PREF_IMPORT_FILENAMEPATTERN = "importFileNamePattern";
    public static final String[] DEFAULT_FILENAMEPATTERNS_DISPLAY = new String[]{"bibtexkey", "bibtexkey - title"};
    public static final String[] DEFAULT_FILENAMEPATTERNS = new String[]{"\\bibtexkey", "\\bibtexkey\\begin{title} - \\format[RemoveBrackets]{\\title}\\end{title}"};
    private JRadioButton radioButtonXmp;
    private JRadioButton radioButtonPDFcontent;
    private JRadioButton radioButtonMrDlib;
    private JRadioButton radioButtonNoMeta;
    private JRadioButton radioButtononlyAttachPDF;
    private JRadioButton radioButtonUpdateEmptyFields;
    private JCheckBox useDefaultPDFImportStyle;
    private JTextField fileNamePattern;
    private JButton selectFileNamePattern;

    public ImportSettingsTab() {
        this.setLayout(new BorderLayout());
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:3dlu");
        this.radioButtonNoMeta = new JRadioButton(Globals.lang("Create_blank_entry_linking_the_PDF"));
        this.radioButtonXmp = new JRadioButton(Globals.lang("Create_entry_based_on_XMP_data"));
        this.radioButtonPDFcontent = new JRadioButton(Globals.lang("Create_entry_based_on_content"));
        this.radioButtonMrDlib = new JRadioButton(Globals.lang("Create_entry_based_on_data_fetched_from"));
        this.radioButtononlyAttachPDF = new JRadioButton(Globals.lang("Only_attach_PDF"));
        this.radioButtonUpdateEmptyFields = new JRadioButton(Globals.lang("Update_empty_fields_with_data_fetched_from"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radioButtonNoMeta);
        bg.add(this.radioButtonXmp);
        bg.add(this.radioButtonPDFcontent);
        bg.add(this.radioButtonMrDlib);
        bg.add(this.radioButtononlyAttachPDF);
        bg.add(this.radioButtonUpdateEmptyFields);
        this.useDefaultPDFImportStyle = new JCheckBox(Globals.lang("Always use this PDF import style (and do not ask for each import)"));
        this.fileNamePattern = new JTextField(50);
        this.selectFileNamePattern = new JButton(Globals.lang("Choose pattern"));
        this.selectFileNamePattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportSettingsTab.this.openFilePatternMenu();
            }
        });
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        builder.appendSeparator(Globals.lang("Default import style for drag&drop of PDFs"));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonNoMeta);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonXmp);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonPDFcontent);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonMrDlib);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtononlyAttachPDF);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.radioButtonUpdateEmptyFields);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.useDefaultPDFImportStyle);
        builder.nextLine();
        builder.appendSeparator(Globals.lang("Default PDF file link action"));
        builder.nextLine();
        builder.append(pan);
        JPanel pan2 = new JPanel();
        JLabel lab = new JLabel(Globals.lang("File name format pattern").concat(":"));
        pan2.add(lab);
        pan2.add(this.fileNamePattern);
        pan2.add(this.selectFileNamePattern);
        builder.append(pan2);
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    public void setValues() {
        this.useDefaultPDFImportStyle.setSelected(Globals.prefs.getBoolean(PREF_IMPORT_ALWAYSUSE));
        int style = Globals.prefs.getInt(PREF_IMPORT_DEFAULT_PDF_IMPORT_STYLE);
        switch (style) {
            case 0: {
                this.radioButtonNoMeta.setSelected(true);
                break;
            }
            case 1: {
                this.radioButtonXmp.setSelected(true);
                break;
            }
            case 2: {
                this.radioButtonPDFcontent.setSelected(true);
                break;
            }
            case 3: {
                this.radioButtonMrDlib.setSelected(true);
                break;
            }
            case 4: {
                this.radioButtononlyAttachPDF.setSelected(true);
                break;
            }
            case 5: {
                this.radioButtonUpdateEmptyFields.setSelected(true);
                break;
            }
            default: {
                this.radioButtonPDFcontent.setSelected(true);
            }
        }
        this.fileNamePattern.setText(Globals.prefs.get(PREF_IMPORT_FILENAMEPATTERN));
    }

    public void storeSettings() {
        Globals.prefs.putBoolean(PREF_IMPORT_ALWAYSUSE, this.useDefaultPDFImportStyle.isSelected());
        int style = 2;
        if (this.radioButtonNoMeta.isSelected()) {
            style = 0;
        } else if (this.radioButtonXmp.isSelected()) {
            style = 1;
        } else if (this.radioButtonPDFcontent.isSelected()) {
            style = 2;
        } else if (this.radioButtonMrDlib.isSelected()) {
            style = 3;
        } else if (this.radioButtononlyAttachPDF.isSelected()) {
            style = 4;
        } else if (this.radioButtonUpdateEmptyFields.isSelected()) {
            style = 5;
        }
        Globals.prefs.putInt(PREF_IMPORT_DEFAULT_PDF_IMPORT_STYLE, style);
        Globals.prefs.put(PREF_IMPORT_FILENAMEPATTERN, this.fileNamePattern.getText());
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("Import");
    }

    private void openFilePatternMenu() {
        JPopupMenu popup = new JPopupMenu();
        for (int i = 0; i < DEFAULT_FILENAMEPATTERNS.length; ++i) {
            JMenuItem item = new JMenuItem(DEFAULT_FILENAMEPATTERNS_DISPLAY[i]);
            final String toSet = DEFAULT_FILENAMEPATTERNS[i];
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImportSettingsTab.this.fileNamePattern.setText(toSet);
                }
            });
            popup.add(item);
        }
        popup.show(this.selectFileNamePattern, 0, this.selectFileNamePattern.getHeight());
    }
}

