/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIGlobals {
    public static String frameTitle = "JabRef";
    public static String version = Globals.VERSION;
    public static String stringsTitle = "Strings for database";
    public static String untitledTitle = "untitled";
    public static String helpTitle = "JabRef help";
    public static String TYPE_HEADER = "entrytype";
    public static String NUMBER_COL = "#";
    public static String encPrefix = "Encoding: ";
    public static String linuxDefaultLookAndFeel = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static String windowsDefaultLookAndFeel = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    public static Font CURRENTFONT;
    public static Font typeNameFont;
    public static Font jabRefFont;
    public static Font fieldNameFont;
    public static final String SIGNATURE = "This file was created with JabRef";
    static Dimension helpSize;
    static Dimension aboutSize;
    static Dimension searchPaneSize;
    static Dimension searchFieldSize;
    public static final int SPLIT_PANE_DIVIDER_SIZE = 4;
    public static final int SPLIT_PANE_DIVIDER_LOCATION = 160;
    public static final int TABLE_ROW_PADDING = 4;
    public static final int KEYBIND_COL_0 = 200;
    public static final int KEYBIND_COL_1 = 80;
    public static final int MAX_CONTENT_SELECTOR_WIDTH = 240;
    public static String backupExt;
    public static String imageSize;
    public static String extension;
    public static String ex;
    public static String pre;
    public static String helpPre;
    public static String fontPath;
    static HashMap<String, JLabel> tableIcons;
    public static Color activeEditor;
    static HashMap<String, String> iconMap;
    public static String baseFrameHelp;
    public static String entryEditorHelp;
    public static String stringEditorHelp;
    public static String helpContents;
    public static String searchHelp;
    public static String groupsHelp;
    public static String customEntriesHelp;
    public static String contentSelectorHelp;
    public static String labelPatternHelp;
    public static String ownerHelp;
    public static String timeStampHelp;
    public static String pdfHelp;
    public static String exportCustomizationHelp;
    public static String importCustomizationHelp;
    public static String medlineHelp;
    public static String citeSeerHelp;
    public static String generalFieldsHelp;
    public static String aboutPage;
    public static String shortPlainImport;
    public static String importInspectionHelp;
    public static String shortIntegrityCheck;
    public static String remoteHelp;
    public static String journalAbbrHelp;
    public static String regularExpressionSearchHelp;
    public static String nameFormatterHelp;
    public static String previewHelp;
    public static String pluginHelp;
    public static String autosaveHelp;
    public static Color lightGray;
    public static Color entryEditorLabelColor;
    public static Color nullFieldColor;
    public static Color gradientGray;
    public static Color gradientBlue;
    public static Color activeTabbed;
    public static Color inActiveTabbed;
    public static Color infoField;
    public static Color editorTextColor;
    public static Color validFieldBackgroundColor;
    public static Color activeBackground;
    public static Color invalidFieldBackgroundColor;
    public static String META_FLAG;
    public static String META_FLAG_OLD;
    public static String ENTRYTYPE_FLAG;
    public static final double DEFAULT_FIELD_WEIGHT = 1.0;
    public static final double MAX_FIELD_WEIGHT = 2.0;
    public static final int STANDARD_EDITOR = 1;
    public static final int FILE_LIST_EDITOR = 2;
    public static final int MAX_BACK_HISTORY_SIZE = 10;
    public static final String FILE_FIELD = "file";
    public static final double SMALL_W = 0.3;
    public static final double MEDIUM_W = 0.5;
    public static final double LARGE_W = 1.5;
    public static final double PE_HEIGHT = 2.0;
    public static int[] FORM_WIDTH;
    public static int[] FORM_HEIGHT;
    public static final int INDENT = 4;
    public static final int LINE_LENGTH = 65;
    public static int DEFAULT_FIELD_LENGTH;
    public static int NUMBER_COL_LENGTH;
    public static int WIDTH_ICON_COL;
    public static final int EXPORT_DIALOG_COL_0_WIDTH = 50;
    public static final int EXPORT_DIALOG_COL_1_WIDTH = 200;
    public static final int EXPORT_DIALOG_COL_2_WIDTH = 30;
    public static final int IMPORT_DIALOG_COL_0_WIDTH = 200;
    public static final int IMPORT_DIALOG_COL_1_WIDTH = 80;
    public static final int IMPORT_DIALOG_COL_2_WIDTH = 200;
    public static final int IMPORT_DIALOG_COL_3_WIDTH = 200;
    public static final Map<String, String> LANGUAGES;

    public static JLabel getTableIcon(String fieldType) {
        JLabel o = tableIcons.get(fieldType);
        if (o == null) {
            Globals.logger("Error: no table icon defined for type '" + fieldType + "'.");
            return null;
        }
        return o;
    }

    public static void updateEntryEditorColors() {
        activeBackground = JabRefPreferences.getInstance().getColor("activeFieldEditorBackgroundColor");
        validFieldBackgroundColor = JabRefPreferences.getInstance().getColor("validFieldBackgroundColor");
        invalidFieldBackgroundColor = JabRefPreferences.getInstance().getColor("invalidFieldBackgroundColor");
        editorTextColor = JabRefPreferences.getInstance().getColor("fieldEditorTextColor");
    }

    public static void setUpIconTheme() {
        block7: {
            String filename;
            URL defaultResource;
            String defaultPrefix;
            String prefix = defaultPrefix = "/images/crystal_16/";
            URL resource = defaultResource = GUIGlobals.class.getResource(prefix + "Icons.properties");
            if (Globals.prefs.getBoolean("useCustomIconTheme") && (filename = Globals.prefs.get("customIconThemeFile")) != null) {
                try {
                    File file = new File(filename);
                    String parent = file.getParentFile().getAbsolutePath();
                    prefix = "file://" + parent + System.getProperty("file.separator");
                    resource = new URL("file://" + file.getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            try {
                iconMap = GUIGlobals.readIconThemeFile(resource, prefix);
            }
            catch (IOException e) {
                System.err.println(Globals.lang("Unable to read icon theme file") + " '" + resource.toString() + "'");
                if (resource == defaultResource) break block7;
                try {
                    iconMap = GUIGlobals.readIconThemeFile(defaultResource, defaultPrefix);
                }
                catch (IOException e2) {
                    System.err.println(Globals.lang("Unable to read default icon theme."));
                }
            }
        }
    }

    public static URL getIconUrl(String name) {
        if (iconMap.containsKey(name)) {
            String path = iconMap.get(name);
            URL url = GUIGlobals.class.getResource(path);
            if (url == null) {
                try {
                    url = new URL(path);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (url == null) {
                System.err.println(Globals.lang("Could not find image file") + " '" + path + "'");
            }
            return url;
        }
        return null;
    }

    public static ImageIcon getImage(String name) {
        URL u = GUIGlobals.getIconUrl(name);
        return u != null ? new ImageIcon(GUIGlobals.getIconUrl(name)) : null;
    }

    public static Map<String, String> getAllIcons() {
        return Collections.unmodifiableMap(iconMap);
    }

    private static HashMap<String, String> readIconThemeFile(URL file, String prefix) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream in = null;
        try {
            int c;
            in = file.openStream();
            StringBuffer buffer = new StringBuffer();
            while ((c = in.read()) != -1) {
                buffer.append((char)c);
            }
            String[] lines = buffer.toString().split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                int index = line.indexOf("=");
                if (index < 0) continue;
                String key = line.substring(0, index).trim();
                String value = prefix + line.substring(index + 1).trim();
                map.put(key, value);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return map;
    }

    public static String getLocaleHelpPath() {
        JabRefPreferences prefs = JabRefPreferences.getInstance();
        String middle = prefs.get("language") + "/";
        if (middle.equals("en/")) {
            middle = "";
        }
        return helpPre + middle;
    }

    public static void init() {
        typeNameFont = new Font("arial", 3, 24);
        fieldNameFont = new Font("arial", 3, 14);
        JLabel lab = new JLabel(GUIGlobals.getImage("pdfSmall"));
        lab.setToolTipText(Globals.lang("Open") + " PDF");
        tableIcons.put("pdf", lab);
        lab = new JLabel(GUIGlobals.getImage("wwwSmall"));
        lab.setToolTipText(Globals.lang("Open") + " URL");
        tableIcons.put("url", lab);
        lab = new JLabel(GUIGlobals.getImage("citeseer"));
        lab.setToolTipText(Globals.lang("Open") + " CiteSeer URL");
        tableIcons.put("citeseerurl", lab);
        lab = new JLabel(GUIGlobals.getImage("arxiv"));
        lab.setToolTipText(Globals.lang("Open") + " ArXiv URL");
        tableIcons.put("eprint", lab);
        lab = new JLabel(GUIGlobals.getImage("doiSmall"));
        lab.setToolTipText(Globals.lang("Open") + " DOI " + Globals.lang("web link"));
        tableIcons.put("doi", lab);
        lab = new JLabel(GUIGlobals.getImage("psSmall"));
        lab.setToolTipText(Globals.lang("Open") + " PS");
        tableIcons.put("ps", lab);
        lab = new JLabel(GUIGlobals.getImage("psSmall"));
        lab.setToolTipText(Globals.lang("Open file"));
        tableIcons.put(FILE_FIELD, lab);
    }

    static {
        helpSize = new Dimension(700, 600);
        aboutSize = new Dimension(600, 265);
        searchPaneSize = new Dimension(430, 70);
        searchFieldSize = new Dimension(215, 25);
        backupExt = ".bak";
        imageSize = "24";
        extension = ".gif";
        ex = imageSize + extension;
        pre = "/images/";
        helpPre = "/help/";
        fontPath = "/images/font/";
        tableIcons = new HashMap();
        activeEditor = new Color(230, 230, 255);
        baseFrameHelp = "BaseFrameHelp.html";
        entryEditorHelp = "EntryEditorHelp.html";
        stringEditorHelp = "StringEditorHelp.html";
        helpContents = "Contents.html";
        searchHelp = "SearchHelp.html";
        groupsHelp = "GroupsHelp.html";
        customEntriesHelp = "CustomEntriesHelp.html";
        contentSelectorHelp = "ContentSelectorHelp.html";
        labelPatternHelp = "LabelPatterns.html";
        ownerHelp = "OwnerHelp.html";
        timeStampHelp = "TimeStampHelp.html";
        pdfHelp = "ExternalFiles.html";
        exportCustomizationHelp = "CustomExports.html";
        importCustomizationHelp = "CustomImports.html";
        medlineHelp = "MedlineHelp.html";
        citeSeerHelp = "CiteSeerHelp.html";
        generalFieldsHelp = "GeneralFields.html";
        aboutPage = "About.html";
        shortPlainImport = "ShortPlainImport.html";
        importInspectionHelp = "ImportInspectionDialog.html";
        shortIntegrityCheck = "ShortIntegrityCheck.html";
        remoteHelp = "RemoteHelp.html";
        journalAbbrHelp = "JournalAbbreviations.html";
        regularExpressionSearchHelp = "ExternalFiles.html#RegularExpressionSearch";
        nameFormatterHelp = "CustomExports.html#NameFormatter";
        previewHelp = "PreviewHelp.html";
        pluginHelp = "Plugin.html";
        autosaveHelp = "Autosave.html";
        lightGray = new Color(230, 30, 30);
        entryEditorLabelColor = new Color(100, 100, 150);
        nullFieldColor = new Color(75, 130, 95);
        gradientGray = new Color(112, 121, 165);
        gradientBlue = new Color(0, 27, 102);
        activeTabbed = entryEditorLabelColor.darker();
        inActiveTabbed = Color.black;
        infoField = new Color(254, 255, 225);
        editorTextColor = null;
        validFieldBackgroundColor = null;
        activeBackground = null;
        invalidFieldBackgroundColor = null;
        META_FLAG = "jabref-meta: ";
        META_FLAG_OLD = "bibkeeper-meta: ";
        ENTRYTYPE_FLAG = "jabref-entrytype: ";
        FORM_WIDTH = new int[]{500, 650, 820};
        FORM_HEIGHT = new int[]{90, 110, 130};
        DEFAULT_FIELD_LENGTH = 100;
        NUMBER_COL_LENGTH = 32;
        WIDTH_ICON_COL = 19;
        LANGUAGES = new TreeMap<String, String>();
        LANGUAGES.put("English", "en");
        LANGUAGES.put("Dansk", "da");
        LANGUAGES.put("Deutsch", "de");
        LANGUAGES.put("Fran\u00e7ais", "fr");
        LANGUAGES.put("Italiano", "it");
        LANGUAGES.put("Japanese", "ja");
        LANGUAGES.put("Nederlands", "nl");
        LANGUAGES.put("Norsk", "no");
        LANGUAGES.put("Turkish", "tr");
        LANGUAGES.put("Simplified Chinese", "zh");
        LANGUAGES.put("Vietnamese", "vi");
        LANGUAGES.put("Bahasa Indonesia", "in");
        LANGUAGES.put("Brazilian Portugese", "pt_BR");
        GUIGlobals.updateEntryEditorColors();
    }
}

