/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart.impl;

import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.MultiPartConfig;
import com.sun.jersey.spi.CloseableService;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.jvnet.mimepull.Header;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEParsingException;
import org.jvnet.mimepull.MIMEPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Consumes(value={"multipart/*"})
public class MultiPartReader
implements MessageBodyReader<MultiPart> {
    private final Providers providers;
    private final MultiPartConfig config;
    private final CloseableService closeableService;
    private final MIMEConfig mimeConfig;

    public MultiPartReader(@Context Providers providers, @Context MultiPartConfig config, @Context CloseableService closeableService) {
        this.providers = providers;
        if (config == null) {
            throw new IllegalArgumentException("The MultiPartConfig instance we expected is not present.  Have you registered the MultiPartConfigProvider class?");
        }
        this.config = config;
        this.closeableService = closeableService;
        this.mimeConfig = new MIMEConfig();
        this.mimeConfig.setMemoryThreshold(config.getBufferThreshold());
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    @Override
    public MultiPart readFrom(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, WebApplicationException {
        try {
            MIMEMessage mm = new MIMEMessage(stream, mediaType.getParameters().get("boundary"), this.mimeConfig);
            boolean formData = false;
            MultiPart multiPart = null;
            if (MediaTypes.typeEquals(mediaType, MediaType.MULTIPART_FORM_DATA_TYPE)) {
                multiPart = new FormDataMultiPart();
                formData = true;
            } else {
                multiPart = new MultiPart();
            }
            multiPart.setProviders(this.providers);
            MultivaluedMap<String, String> mpHeaders = multiPart.getHeaders();
            for (Map.Entry entry : headers.entrySet()) {
                List values = (List)entry.getValue();
                for (String string : values) {
                    mpHeaders.add((String)entry.getKey(), string);
                }
            }
            if (!formData) {
                multiPart.setMediaType(mediaType);
            }
            for (MIMEPart mp : mm.getAttachments()) {
                BodyPart bodyPart = null;
                bodyPart = formData ? new FormDataBodyPart() : new BodyPart();
                bodyPart.setProviders(this.providers);
                for (Header header : mp.getAllHeaders()) {
                    bodyPart.getHeaders().add(header.getName(), header.getValue());
                }
                try {
                    String contentType = bodyPart.getHeaders().getFirst("Content-Type");
                    if (contentType != null) {
                        bodyPart.setMediaType(MediaType.valueOf(contentType));
                    }
                    bodyPart.getContentDisposition();
                }
                catch (IllegalArgumentException ex) {
                    throw new WebApplicationException((Throwable)ex, 400);
                }
                bodyPart.setEntity(new BodyPartEntity(mp));
                multiPart.getBodyParts().add(bodyPart);
            }
            if (this.closeableService != null) {
                this.closeableService.add(multiPart);
            }
            return multiPart;
        }
        catch (MIMEParsingException ex) {
            throw new WebApplicationException((Throwable)ex, 400);
        }
    }
}

