/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserResult {
    public static ParserResult INVALID_FORMAT = new ParserResult(null, null, null);
    public static ParserResult FILE_LOCKED = new ParserResult(null, null, null);
    private BibtexDatabase base;
    private HashMap<String, String> metaData;
    private HashMap<String, BibtexEntryType> entryTypes;
    private File file = null;
    private ArrayList<String> warnings = new ArrayList();
    private String errorMessage = null;
    private String encoding = null;
    private boolean postponedAutosaveFound = false;
    private boolean invalid = false;
    private String jabrefVersion = null;
    private int jabrefMajorVersion = 0;
    private int jabrefMinorVersion = 0;
    private boolean toOpenTab = false;

    public ParserResult(Collection<BibtexEntry> entries) {
        this(ImportFormatReader.createDatabase(entries), null, new HashMap<String, BibtexEntryType>());
    }

    public ParserResult(BibtexDatabase base, HashMap<String, String> metaData, HashMap<String, BibtexEntryType> entryTypes) {
        this.base = base;
        this.metaData = metaData;
        this.entryTypes = entryTypes;
    }

    public boolean toOpenTab() {
        return this.toOpenTab;
    }

    public void setToOpenTab(boolean toOpenTab) {
        this.toOpenTab = toOpenTab;
    }

    public String getJabrefVersion() {
        return this.jabrefVersion;
    }

    public void setJabrefVersion(String jabrefVersion) {
        this.jabrefVersion = jabrefVersion;
    }

    public int getJabrefMajorVersion() {
        return this.jabrefMajorVersion;
    }

    public void setJabrefMajorVersion(int jabrefMajorVersion) {
        this.jabrefMajorVersion = jabrefMajorVersion;
    }

    public int getJabrefMinorVersion() {
        return this.jabrefMinorVersion;
    }

    public void setJabrefMinorVersion(int jabrefMinorVersion) {
        this.jabrefMinorVersion = jabrefMinorVersion;
    }

    public BibtexDatabase getDatabase() {
        return this.base;
    }

    public HashMap<String, String> getMetaData() {
        return this.metaData;
    }

    public HashMap<String, BibtexEntryType> getEntryTypes() {
        return this.entryTypes;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void addWarning(String s) {
        if (!this.warnings.contains(s)) {
            this.warnings.add(s);
        }
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public String[] warnings() {
        String[] s = new String[this.warnings.size()];
        for (int i = 0; i < this.warnings.size(); ++i) {
            s[i] = this.warnings.get(i);
        }
        return s;
    }

    public boolean isPostponedAutosaveFound() {
        return this.postponedAutosaveFound;
    }

    public void setPostponedAutosaveFound(boolean postponedAutosaveFound) {
        this.postponedAutosaveFound = postponedAutosaveFound;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

