/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JstorImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "JStor (tab delimited)";
    }

    @Override
    public String getCLIId() {
        return "jstor";
    }

    @Override
    public boolean isRecognizedFormat(InputStream in) throws IOException {
        return true;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream) throws IOException {
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        String s = "";
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        while (s != null && !s.startsWith("Item Type")) {
            s = in.readLine();
        }
        while ((s = in.readLine()) != null) {
            if (s.equals("")) continue;
            if (s.startsWith("-----------------------------")) break;
            String[] fields = s.split("\t");
            BibtexEntry be = new BibtexEntry(Util.createNeutralId());
            try {
                if (fields[0].equals("FLA")) {
                    be.setType(BibtexEntryType.getType("article"));
                }
                ImportFormatReader.setIfNecessary(be, "title", fields[2]);
                ImportFormatReader.setIfNecessary(be, "author", AuthorList.fixAuthor_lastNameFirst(fields[4].replaceAll("; ", " and ")));
                ImportFormatReader.setIfNecessary(be, "journal", fields[7]);
                ImportFormatReader.setIfNecessary(be, "volume", fields[9]);
                ImportFormatReader.setIfNecessary(be, "number", fields[10]);
                String[] datefield = fields[12].split(" ");
                ImportFormatReader.setIfNecessary(be, "year", datefield[datefield.length - 1]);
                if (datefield.length > 1) {
                    if (datefield[0].endsWith(",")) {
                        datefield[0] = datefield[0].substring(0, datefield[0].length() - 1);
                    }
                    ImportFormatReader.setIfNecessary(be, "month", datefield[0]);
                }
                ImportFormatReader.setIfNecessary(be, "pages", fields[13].replaceAll("-", "--"));
                ImportFormatReader.setIfNecessary(be, "url", fields[14]);
                ImportFormatReader.setIfNecessary(be, "issn", fields[15]);
                ImportFormatReader.setIfNecessary(be, "abstract", fields[16]);
                ImportFormatReader.setIfNecessary(be, "keywords", fields[17]);
                ImportFormatReader.setIfNecessary(be, "copyright", fields[21]);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
            bibitems.add(be);
        }
        return bibitems;
    }
}

