/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.util.CaseChanger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsiImporter
extends ImportFormat {
    static final Pattern isiPattern = Pattern.compile("FN ISI Export Format|VR 1.|PY \\d{4}");
    static Pattern subsupPattern = Pattern.compile("/(sub|sup)\\s+(.*?)\\s*/");

    @Override
    public String getFormatName() {
        return "ISI";
    }

    @Override
    public String getCLIId() {
        return "isi";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        for (int i = 0; (str = in.readLine()) != null && i < 50; ++i) {
            if (!isiPattern.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    public static void processSubSup(HashMap<String, String> map) {
        String[] subsup = new String[]{"title", "abstract", "review", "notes"};
        for (int i = 0; i < subsup.length; ++i) {
            if (!map.containsKey(subsup[i])) continue;
            Matcher m = subsupPattern.matcher(map.get(subsup[i]));
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String group2 = m.group(2);
                if ((group2 = group2.replaceAll("\\$", "\\\\\\\\\\\\\\$")).length() > 1) {
                    group2 = "{" + group2 + "}";
                }
                if (m.group(1).equals("sub")) {
                    m.appendReplacement(sb, "\\$_" + group2 + "\\$");
                    continue;
                }
                m.appendReplacement(sb, "\\$^" + group2 + "\\$");
            }
            m.appendTail(sb);
            map.put(subsup[i], sb.toString());
        }
    }

    public static void processCapitalization(HashMap<String, String> map) {
        String[] subsup = new String[]{"title", "journal", "publisher"};
        for (int i = 0; i < subsup.length; ++i) {
            String s;
            if (!map.containsKey(subsup[i]) || !(s = map.get(subsup[i])).toUpperCase().equals(s)) continue;
            s = CaseChanger.changeCase(s, 3, true);
            map.put(subsup[i], s);
        }
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream) throws IOException {
        String str;
        if (stream == null) {
            throw new IOException("No stream given.");
        }
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        while ((str = in.readLine()) != null) {
            if (str.length() < 3) continue;
            if (str.substring(0, 3).equals("PT ")) {
                sb.append("::").append(str);
                continue;
            }
            String beg = str.substring(0, 3).trim();
            if (beg.length() == 2) {
                sb.append(" ## ");
                sb.append(str);
                continue;
            }
            sb.append("EOLEOL");
            sb.append(str.trim());
        }
        String[] entries = sb.toString().split("::");
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 0; i < entries.length; ++i) {
            String[] fields = entries[i].split(" ## ");
            if (fields.length == 0) {
                fields = entries[i].split("\n");
            }
            String Type2 = "";
            String PT = "";
            String pages = "";
            hm.clear();
            for (int j = 0; j < fields.length; ++j) {
                if (fields[j].length() <= 2) continue;
                String beg = fields[j].substring(0, 2);
                String value = fields[j].substring(3);
                if (value.startsWith(" - ")) {
                    value = value.substring(3);
                }
                value = value.trim();
                if (beg.equals("PT")) {
                    PT = value.startsWith("J") ? "article" : value;
                    Type2 = "article";
                    continue;
                }
                if (beg.equals("TY")) {
                    if ("JOUR".equals(value)) {
                        Type2 = "article";
                        continue;
                    }
                    if (!"CONF".equals(value)) continue;
                    Type2 = "inproceedings";
                    continue;
                }
                if (beg.equals("JO")) {
                    hm.put("booktitle", value);
                    continue;
                }
                if (beg.equals("AU")) {
                    String author = IsiImporter.isiAuthorsConvert(value.replaceAll("EOLEOL", " and "));
                    if (hm.get("author") != null) {
                        author = hm.get("author") + " and " + author;
                    }
                    hm.put("author", author);
                    continue;
                }
                if (beg.equals("TI")) {
                    hm.put("title", value.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("SO") || beg.equals("JA")) {
                    hm.put("journal", value.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("ID") || beg.equals("KW")) {
                    value = value.replaceAll("EOLEOL", " ");
                    String existingKeywords = hm.get("keywords");
                    existingKeywords = existingKeywords != null && existingKeywords.indexOf(value) == -1 ? existingKeywords + ", " + value : value;
                    hm.put("keywords", existingKeywords);
                    continue;
                }
                if (beg.equals("AB")) {
                    hm.put("abstract", value.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("BP") || beg.equals("BR") || beg.equals("SP")) {
                    pages = value;
                    continue;
                }
                if (beg.equals("EP")) {
                    int detpos = value.indexOf(32);
                    if (detpos != -1 && value.substring(0, detpos).trim().length() > 0) {
                        value = value.substring(0, detpos);
                    }
                    pages = pages + "--" + value;
                    continue;
                }
                if (beg.equals("PS")) {
                    pages = IsiImporter.parsePages(value);
                    continue;
                }
                if (beg.equals("AR")) {
                    pages = value;
                    continue;
                }
                if (beg.equals("IS")) {
                    hm.put("number", value);
                    continue;
                }
                if (beg.equals("PY")) {
                    hm.put("year", value);
                    continue;
                }
                if (beg.equals("VL")) {
                    hm.put("volume", value);
                    continue;
                }
                if (beg.equals("PU")) {
                    hm.put("publisher", value);
                    continue;
                }
                if (beg.equals("DI")) {
                    hm.put("doi", value);
                    continue;
                }
                if (beg.equals("PD")) {
                    String month = IsiImporter.parseMonth(value);
                    if (month == null) continue;
                    hm.put("month", month);
                    continue;
                }
                if (beg.equals("DT")) {
                    Type2 = value;
                    if (Type2.equals("Review")) {
                        Type2 = "article";
                        continue;
                    }
                    if (Type2.startsWith("Article") || Type2.startsWith("Journal") || PT.equals("article")) {
                        Type2 = "article";
                        continue;
                    }
                    Type2 = "misc";
                    continue;
                }
                if (beg.equals("CR")) {
                    hm.put("CitedReferences", value.replaceAll("EOLEOL", " ; ").trim());
                    continue;
                }
                if (beg.equals("ER") || beg.equals("EF") || beg.equals("VR") || beg.equals("FN")) continue;
                hm.put(beg, value);
            }
            if (!"".equals(pages)) {
                hm.put("pages", pages);
            }
            if (hm.size() == 0) continue;
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            ArrayList toRemove = new ArrayList();
            for (Object key : hm.keySet()) {
                String content = (String)hm.get(key);
                if (content != null && content.trim().length() != 0) continue;
                toRemove.add(key);
            }
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                hm.remove(iterator.next());
            }
            IsiImporter.processSubSup(hm);
            IsiImporter.processCapitalization(hm);
            b.setField(hm);
            bibitems.add(b);
        }
        return bibitems;
    }

    public static String parsePages(String value) {
        int lastDash = value.lastIndexOf("-");
        return value.substring(0, lastDash) + "--" + value.substring(lastDash + 1);
    }

    public static String parseMonth(String value) {
        int ii;
        String[] parts = value.split("\\s|\\-");
        for (ii = 0; ii < parts.length; ++ii) {
            if (!Globals.MONTH_STRINGS.containsKey(parts[ii].toLowerCase())) continue;
            return "#" + parts[ii].toLowerCase() + "#";
        }
        for (ii = 0; ii < parts.length; ++ii) {
            try {
                int number = Integer.parseInt(parts[ii]);
                if (number < 1 || number > 12) continue;
                return "#" + Globals.MONTHS[number - 1] + "#";
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static String isiAuthorConvert(String author) {
        String[] s = author.split(",");
        if (s.length != 2) {
            return author;
        }
        StringBuffer sb = new StringBuffer();
        String last = s[0].trim();
        sb.append(last).append(", ");
        String first = s[1].trim();
        String[] firstParts = first.split("\\s+");
        for (int i = 0; i < firstParts.length; ++i) {
            first = firstParts[i];
            if (first.toUpperCase().equals(first)) {
                first = first.replaceAll("\\.", "");
                for (int j = 0; j < first.length(); ++j) {
                    sb.append(first.charAt(j)).append(".");
                    if (j >= first.length() - 1) continue;
                    sb.append(" ");
                }
            } else {
                sb.append(first);
            }
            if (i >= firstParts.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String[] isiAuthorsConvert(String[] authors) {
        String[] result = new String[authors.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = IsiImporter.isiAuthorConvert(authors[i]);
        }
        return result;
    }

    public static String isiAuthorsConvert(String authors) {
        String[] s = IsiImporter.isiAuthorsConvert(authors.split(" and |;"));
        return Util.join(s, " and ", 0, s.length);
    }
}

