/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiomailImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "Biomail";
    }

    @Override
    public String getCLIId() {
        return "biomail";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        Pattern pat1 = Pattern.compile("BioMail");
        while ((str = in.readLine()) != null) {
            if (!pat1.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream) throws IOException {
        String str;
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        while ((str = in.readLine()) != null) {
            if (str.length() < 3) continue;
            if (str.substring(0, 6).equals("PMID- ")) {
                sb.append("::").append(str);
                continue;
            }
            String beg = str.substring(0, 6);
            if (beg.indexOf(" ") > 0) {
                sb.append(" ## ");
                sb.append(str);
                continue;
            }
            sb.append("EOLEOL");
            sb.append(str.trim());
        }
        String[] entries = sb.toString().split("::");
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int i = 0; i < entries.length; ++i) {
            String[] fields = entries[i].split(" ## ");
            if (fields.length == 0) {
                fields = entries[i].split("\n");
            }
            String Type2 = "";
            String pages = "";
            String shortauthor = "";
            String fullauthor = "";
            hm.clear();
            for (int j = 0; j < fields.length; ++j) {
                String[] parts;
                String tmpauthor;
                System.out.println(">>>" + fields[j] + "<<<");
                if (fields[j].length() <= 2) continue;
                String beg = fields[j].substring(0, 6);
                String value = fields[j].substring(6);
                value = value.trim();
                if (beg.equals("PT  - ")) {
                    Type2 = "article";
                    continue;
                }
                if (beg.equals("TY  - ")) {
                    if (!"CONF".equals(value)) continue;
                    Type2 = "inproceedings";
                    continue;
                }
                if (beg.equals("JO  - ")) {
                    hm.put("booktitle", value);
                    continue;
                }
                if (beg.equals("FAU - ")) {
                    tmpauthor = value.replaceAll("EOLEOL", " and ");
                    if (!"".equals(fullauthor)) {
                        fullauthor = fullauthor + " and " + tmpauthor;
                        continue;
                    }
                    fullauthor = tmpauthor;
                    continue;
                }
                if (beg.equals("AU  - ")) {
                    tmpauthor = value.replaceAll("EOLEOL", " and ").replaceAll(" ", ", ");
                    if (!"".equals(shortauthor)) {
                        shortauthor = shortauthor + " and " + tmpauthor;
                        continue;
                    }
                    shortauthor = tmpauthor;
                    continue;
                }
                if (beg.equals("TI  - ")) {
                    hm.put("title", value.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("TA  - ")) {
                    hm.put("journal", value.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("AB  - ")) {
                    hm.put("abstract", value.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (beg.equals("PG  - ")) {
                    pages = value.replaceAll("-", "--");
                    continue;
                }
                if (beg.equals("IP  - ")) {
                    hm.put("number", value);
                    continue;
                }
                if (beg.equals("DP  - ")) {
                    parts = value.split(" ");
                    hm.put("year", parts[0]);
                    continue;
                }
                if (beg.equals("VI  - ")) {
                    hm.put("volume", value);
                    continue;
                }
                if (!beg.equals("AID - ") || !"[doi]".equals((parts = value.split(" "))[1])) continue;
                hm.put("doi", parts[0]);
                hm.put("url", "http://dx.doi.org/" + parts[0]);
            }
            if (!"".equals(pages)) {
                hm.put("pages", pages);
            }
            if (!"".equals(fullauthor)) {
                hm.put("author", fullauthor);
            } else if (!"".equals(shortauthor)) {
                hm.put("author", shortauthor);
            }
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(Type2));
            b.setField(hm);
            if (hm.get("author") == null && hm.get("title") == null) continue;
            bibitems.add(b);
        }
        return bibitems;
    }
}

