/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.GenFieldsCustomizer_cancel_actionAdapter;
import net.sf.jabref.gui.GenFieldsCustomizer_ok_actionAdapter;
import net.sf.jabref.gui.GenFieldsCustomizer_revert_actionAdapter;

public class GenFieldsCustomizer
extends JDialog {
    JPanel buttons = new JPanel();
    JButton ok = new JButton();
    JButton cancel = new JButton();
    JButton helpBut = new JButton();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    JLabel jLabel1 = new JLabel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JLabel jLabel2 = new JLabel();
    JTextArea fieldsArea = new JTextArea();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JabRefFrame parent;
    JButton revert = new JButton();
    HelpAction help;

    public GenFieldsCustomizer(JabRefFrame frame) {
        super(frame, Globals.lang("Set general fields"), false);
        this.parent = frame;
        this.help = new HelpAction(this.parent.helpDiag, GUIGlobals.generalFieldsHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.helpBut = new JButton(Globals.lang("Help"));
        this.helpBut.addActionListener(this.help);
        try {
            this.jbInit();
            this.setSize(new Dimension(650, 300));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.ok.setText(Globals.lang("Ok"));
        this.ok.addActionListener(new GenFieldsCustomizer_ok_actionAdapter(this));
        this.cancel.setText(Globals.lang("Cancel"));
        this.cancel.addActionListener(new GenFieldsCustomizer_cancel_actionAdapter(this));
        this.jLabel1.setText(Globals.lang("Delimit fields with semicolon, ex.") + ": url;pdf;note");
        this.jPanel3.setLayout(this.gridBagLayout2);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setLayout(this.gridBagLayout1);
        this.jLabel2.setText(Globals.lang("General fields"));
        this.setFieldsText();
        this.revert.setText(Globals.lang("Default"));
        this.revert.addActionListener(new GenFieldsCustomizer_revert_actionAdapter(this));
        this.getContentPane().add((Component)this.buttons, "South");
        ButtonBarBuilder bb = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.revert);
        bb.addGridded(this.cancel);
        bb.addStrut(Sizes.DLUX5);
        bb.addGridded(this.helpBut);
        bb.addGlue();
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel3.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 318, 193));
        this.jPanel4.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.fieldsArea, null);
        this.jPanel4.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        ActionMap am = this.buttons.getActionMap();
        InputMap im = this.buttons.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GenFieldsCustomizer.this.dispose();
            }
        });
    }

    void ok_actionPerformed(ActionEvent e) {
        int i;
        String[] lines = this.fieldsArea.getText().split("\n");
        for (i = 0; i < lines.length; ++i) {
            String[] parts = lines[i].split(":");
            if (parts.length != 2) {
                String field = Globals.lang("field");
                JOptionPane.showMessageDialog(this, Globals.lang("Each line must be on the following form") + " '" + Globals.lang("Tabname") + ":" + field + "1;" + field + "2;...;" + field + "N'", Globals.lang("Error"), 0);
                return;
            }
            String testString = Util.checkLegalKey(parts[1]);
            if (!testString.equals(parts[1]) || parts[1].indexOf(38) >= 0) {
                JOptionPane.showMessageDialog(this, Globals.lang("Field names are not allowed to contain white space or the following characters") + ": # { } ~ , ^ &", Globals.lang("Error"), 0);
                return;
            }
            Globals.prefs.put(Globals.prefs.CUSTOM_TAB_NAME + i, parts[0]);
            Globals.prefs.put(Globals.prefs.CUSTOM_TAB_FIELDS + i, parts[1].toLowerCase());
        }
        Globals.prefs.purgeSeries(Globals.prefs.CUSTOM_TAB_NAME, i);
        Globals.prefs.purgeSeries(Globals.prefs.CUSTOM_TAB_FIELDS, i);
        Globals.prefs.updateEntryEditorTabList();
        this.parent.removeCachedEntryEditors();
        this.dispose();
    }

    void cancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void setFieldsText() {
        StringBuffer sb = new StringBuffer();
        EntryEditorTabList tabList = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < tabList.getTabCount(); ++i) {
            sb.append(tabList.getTabName(i));
            sb.append(":");
            Iterator<String> j = tabList.getTabFields(i).iterator();
            while (j.hasNext()) {
                String field = j.next();
                sb.append(field);
                if (!j.hasNext()) continue;
                sb.append(";");
            }
            sb.append("\n");
        }
        this.fieldsArea.setText(sb.toString());
    }

    void revert_actionPerformed(ActionEvent e) {
        StringBuffer sb = new StringBuffer();
        String name = null;
        String fields = null;
        int i = 0;
        while ((name = (String)Globals.prefs.defaults.get(Globals.prefs.CUSTOM_TAB_NAME + "_def" + i)) != null) {
            sb.append(name);
            fields = (String)Globals.prefs.defaults.get(Globals.prefs.CUSTOM_TAB_FIELDS + "_def" + i);
            sb.append(":");
            sb.append(fields);
            sb.append("\n");
            ++i;
        }
        this.fieldsArea.setText(sb.toString());
    }
}

